/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.inject.CreationException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Injector;
import org.elasticsearch.common.inject.Injectors;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.inject.ModulesBuilder;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.env.ShardLock;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexComponent;
import org.elasticsearch.index.IndexShardAlreadyExistsException;
import org.elasticsearch.index.aliases.IndexAliasesService;
import org.elasticsearch.index.analysis.AnalysisService;
import org.elasticsearch.index.cache.IndexCache;
import org.elasticsearch.index.cache.bitset.BitsetFilterCache;
import org.elasticsearch.index.deletionpolicy.DeletionPolicyModule;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.IndexFieldDataService;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.query.IndexQueryParserService;
import org.elasticsearch.index.settings.IndexSettingsService;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.IndexShardModule;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardNotFoundException;
import org.elasticsearch.index.shard.ShardPath;
import org.elasticsearch.index.shard.StoreRecoveryService;
import org.elasticsearch.index.similarity.SimilarityService;
import org.elasticsearch.index.store.IndexStore;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.store.StoreModule;
import org.elasticsearch.index.translog.TranslogService;
import org.elasticsearch.indices.IndicesLifecycle;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.InternalIndicesLifecycle;
import org.elasticsearch.indices.cache.query.IndicesQueryCache;
import org.elasticsearch.plugins.PluginsService;

public class IndexService
extends AbstractIndexComponent
implements IndexComponent,
Iterable<IndexShard> {
    private final Injector injector;
    private final PluginsService pluginsService;
    private final InternalIndicesLifecycle indicesLifecycle;
    private final AnalysisService analysisService;
    private final MapperService mapperService;
    private final IndexQueryParserService queryParserService;
    private final SimilarityService similarityService;
    private final IndexAliasesService aliasesService;
    private final IndexCache indexCache;
    private final IndexFieldDataService indexFieldData;
    private final BitsetFilterCache bitsetFilterCache;
    private final IndexSettingsService settingsService;
    private final NodeEnvironment nodeEnv;
    private final IndicesService indicesServices;
    private volatile ImmutableMap<Integer, IndexShardInjectorPair> shards = ImmutableMap.of();
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final AtomicBoolean deleted = new AtomicBoolean(false);

    @Inject
    public IndexService(Injector injector, Index index, NodeEnvironment nodeEnv, AnalysisService analysisService, MapperService mapperService, IndexQueryParserService queryParserService, SimilarityService similarityService, IndexAliasesService aliasesService, IndexCache indexCache, IndexSettingsService settingsService, IndexFieldDataService indexFieldData, BitsetFilterCache bitSetFilterCache, IndicesService indicesServices) {
        super(index, settingsService.getSettings());
        this.injector = injector;
        this.analysisService = analysisService;
        this.mapperService = mapperService;
        this.queryParserService = queryParserService;
        this.similarityService = similarityService;
        this.aliasesService = aliasesService;
        this.indexCache = indexCache;
        this.indexFieldData = indexFieldData;
        this.settingsService = settingsService;
        this.bitsetFilterCache = bitSetFilterCache;
        this.pluginsService = injector.getInstance(PluginsService.class);
        this.indicesServices = indicesServices;
        this.indicesLifecycle = (InternalIndicesLifecycle)injector.getInstance(IndicesLifecycle.class);
        indexFieldData.setListener(new FieldDataCacheListener(this));
        bitSetFilterCache.setListener(new BitsetCacheListener(this));
        this.nodeEnv = nodeEnv;
    }

    public int numberOfShards() {
        return this.shards.size();
    }

    public InternalIndicesLifecycle indicesLifecycle() {
        return this.indicesLifecycle;
    }

    @Override
    public Iterator<IndexShard> iterator() {
        return Iterators.transform((Iterator)this.shards.values().iterator(), (Function)new Function<IndexShardInjectorPair, IndexShard>(){

            public IndexShard apply(IndexShardInjectorPair input) {
                return input.getIndexShard();
            }
        });
    }

    public boolean hasShard(int shardId) {
        return this.shards.containsKey((Object)shardId);
    }

    @Nullable
    public IndexShard shard(int shardId) {
        IndexShardInjectorPair indexShardInjectorPair = (IndexShardInjectorPair)this.shards.get((Object)shardId);
        if (indexShardInjectorPair != null) {
            return indexShardInjectorPair.getIndexShard();
        }
        return null;
    }

    public IndexShard shardSafe(int shardId) {
        IndexShard indexShard = this.shard(shardId);
        if (indexShard == null) {
            throw new ShardNotFoundException(new ShardId(this.index, shardId));
        }
        return indexShard;
    }

    public Set<Integer> shardIds() {
        return this.shards.keySet();
    }

    public Injector injector() {
        return this.injector;
    }

    public IndexSettingsService settingsService() {
        return this.settingsService;
    }

    public IndexCache cache() {
        return this.indexCache;
    }

    public IndexFieldDataService fieldData() {
        return this.indexFieldData;
    }

    public BitsetFilterCache bitsetFilterCache() {
        return this.bitsetFilterCache;
    }

    public AnalysisService analysisService() {
        return this.analysisService;
    }

    public MapperService mapperService() {
        return this.mapperService;
    }

    public IndexQueryParserService queryParserService() {
        return this.queryParserService;
    }

    public SimilarityService similarityService() {
        return this.similarityService;
    }

    public IndexAliasesService aliasesService() {
        return this.aliasesService;
    }

    public synchronized void close(String reason, boolean delete) {
        if (this.closed.compareAndSet(false, true)) {
            this.deleted.compareAndSet(false, delete);
            Set<Integer> shardIds = this.shardIds();
            for (int shardId : shardIds) {
                try {
                    this.removeShard(shardId, reason);
                }
                catch (Throwable t) {
                    this.logger.warn("failed to close shard", t, new Object[0]);
                }
            }
        }
    }

    public Injector shardInjectorSafe(int shardId) {
        IndexShardInjectorPair indexShardInjectorPair = (IndexShardInjectorPair)this.shards.get((Object)shardId);
        if (indexShardInjectorPair == null) {
            throw new ShardNotFoundException(new ShardId(this.index, shardId));
        }
        return indexShardInjectorPair.getInjector();
    }

    public String indexUUID() {
        return this.indexSettings().get("index.uuid", "_na_");
    }

    private long getAvgShardSizeInBytes() throws IOException {
        long sum = 0L;
        int count = 0;
        for (IndexShard indexShard : this) {
            sum += indexShard.store().stats().sizeInBytes();
            ++count;
        }
        if (count == 0) {
            return -1L;
        }
        return sum / (long)count;
    }

    public synchronized IndexShard createShard(ShardRouting routing) {
        IndexShard indexShard;
        block21: {
            boolean primary = routing.primary();
            Settings indexSettings = this.indexSettings();
            final ShardId shardId = routing.shardId();
            if (this.closed.get()) {
                throw new IllegalStateException("Can't create shard " + shardId + ", closed");
            }
            ShardLock lock = null;
            boolean success = false;
            Injector shardInjector = null;
            try {
                ElasticsearchException ex;
                ShardPath path;
                lock = this.nodeEnv.shardLock(shardId, TimeUnit.SECONDS.toMillis(5L));
                this.indicesLifecycle.beforeIndexShardCreated(shardId, indexSettings);
                try {
                    path = ShardPath.loadShardPath(this.logger, this.nodeEnv, shardId, indexSettings);
                }
                catch (IllegalStateException ex2) {
                    this.logger.warn("{} failed to load shard path, trying to remove leftover", shardId);
                    try {
                        ShardPath.deleteLeftoverShardDirectory(this.logger, this.nodeEnv, lock, indexSettings);
                        path = ShardPath.loadShardPath(this.logger, this.nodeEnv, shardId, indexSettings);
                    }
                    catch (Throwable t) {
                        t.addSuppressed(ex2);
                        throw t;
                    }
                }
                if (path == null) {
                    HashMap<Path, Integer> dataPathToShardCount = new HashMap<Path, Integer>();
                    for (Object shard : this) {
                        Path dataPath = ((IndexShard)shard).shardPath().getRootStatePath();
                        Integer curCount = (Integer)dataPathToShardCount.get(dataPath);
                        if (curCount == null) {
                            curCount = 0;
                        }
                        dataPathToShardCount.put(dataPath, curCount + 1);
                    }
                    path = ShardPath.selectNewPathForShard(this.nodeEnv, shardId, indexSettings, routing.getExpectedShardSize() == -1L ? this.getAvgShardSizeInBytes() : routing.getExpectedShardSize(), dataPathToShardCount);
                    this.logger.debug("{} creating using a new path [{}]", shardId, path);
                } else {
                    this.logger.debug("{} creating using an existing path [{}]", shardId, path);
                }
                if (this.shards.containsKey((Object)shardId.id())) {
                    throw new IndexShardAlreadyExistsException(shardId + " already exists");
                }
                this.logger.debug("creating shard_id {}", shardId);
                boolean canDeleteShardContent = !IndexMetaData.isOnSharedFilesystem(indexSettings) || primary && IndexMetaData.isOnSharedFilesystem(indexSettings);
                ModulesBuilder modules = new ModulesBuilder();
                for (Module pluginModule : this.pluginsService.shardModules(indexSettings)) {
                    modules.add(pluginModule);
                }
                modules.add(new IndexShardModule(shardId, primary, indexSettings));
                modules.add(new StoreModule(this.injector.getInstance(IndexStore.class).shardDirectory(), lock, new StoreCloseListener(shardId, canDeleteShardContent, new Closeable(){

                    @Override
                    public void close() throws IOException {
                        IndexService.this.injector.getInstance(IndicesQueryCache.class).onClose(shardId);
                    }
                }), path));
                modules.add(new DeletionPolicyModule());
                this.pluginsService.processModules(modules);
                try {
                    shardInjector = modules.createChildInjector(this.injector);
                }
                catch (CreationException e) {
                    ex = new ElasticsearchException("failed to create shard", Injectors.getFirstErrorFailure(e), new Object[0]);
                    ex.setShard(shardId);
                    throw ex;
                }
                catch (Throwable e) {
                    ex = new ElasticsearchException("failed to create shard", e, new Object[0]);
                    ex.setShard(shardId);
                    throw ex;
                }
                IndexShard indexShard2 = shardInjector.getInstance(IndexShard.class);
                this.indicesLifecycle.indexShardStateChanged(indexShard2, null, "shard created");
                this.indicesLifecycle.afterIndexShardCreated(indexShard2);
                indexShard2.updateRoutingEntry(routing, true);
                this.shards = MapBuilder.newMapBuilder(this.shards).put(shardId.id(), new IndexShardInjectorPair(indexShard2, shardInjector)).immutableMap();
                success = true;
                indexShard = indexShard2;
                if (success) break block21;
            }
            catch (IOException e) {
                try {
                    ElasticsearchException ex = new ElasticsearchException("failed to create shard", (Throwable)e, new Object[0]);
                    ex.setShard(shardId);
                    throw ex;
                }
                catch (Throwable throwable) {
                    if (!success) {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{lock});
                        if (shardInjector != null) {
                            IndexShard indexShard3 = shardInjector.getInstance(IndexShard.class);
                            this.closeShardInjector("initialization failed", shardId, shardInjector, indexShard3);
                        }
                    }
                    throw throwable;
                }
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{lock});
            if (shardInjector != null) {
                IndexShard indexShard4 = shardInjector.getInstance(IndexShard.class);
                this.closeShardInjector("initialization failed", shardId, shardInjector, indexShard4);
            }
        }
        return indexShard;
    }

    public synchronized void removeShard(int shardId, String reason) {
        ShardId sId = new ShardId(this.index, shardId);
        if (!this.shards.containsKey((Object)shardId)) {
            return;
        }
        this.logger.debug("[{}] closing... (reason: [{}])", shardId, reason);
        HashMap tmpShardsMap = Maps.newHashMap(this.shards);
        IndexShardInjectorPair indexShardInjectorPair = (IndexShardInjectorPair)tmpShardsMap.remove(shardId);
        IndexShard indexShard = indexShardInjectorPair.getIndexShard();
        Injector shardInjector = indexShardInjectorPair.getInjector();
        this.shards = ImmutableMap.copyOf((Map)tmpShardsMap);
        this.closeShardInjector(reason, sId, shardInjector, indexShard);
        this.logger.debug("[{}] closed (reason: [{}])", shardId, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeShardInjector(String reason, ShardId sId, Injector shardInjector, IndexShard indexShard) {
        int shardId = sId.id();
        Settings indexSettings = this.indexSettings();
        try {
            try {
                this.indicesLifecycle.beforeIndexShardClosed(sId, indexShard, indexSettings);
            }
            catch (Throwable throwable) {
                for (Class<? extends Closeable> closeable : this.pluginsService.shardServices()) {
                    try {
                        shardInjector.getInstance(closeable).close();
                    }
                    catch (Throwable e) {
                        this.logger.debug("[{}] failed to clean plugin shard service [{}]", e, shardId, closeable);
                    }
                }
                this.closeInjectorOptionalResource(sId, shardInjector, TranslogService.class);
                if (indexShard != null) {
                    try {
                        boolean flushEngine = !this.deleted.get() && this.closed.get();
                        indexShard.close(reason, flushEngine);
                    }
                    catch (Throwable e) {
                        this.logger.debug("[{}] failed to close index shard", e, shardId);
                    }
                }
                this.closeInjectorResource(sId, shardInjector, StoreRecoveryService.class);
                this.indicesLifecycle.afterIndexShardClosed(sId, indexShard, indexSettings);
                throw throwable;
            }
            for (Class<? extends Closeable> closeable : this.pluginsService.shardServices()) {
                try {
                    shardInjector.getInstance(closeable).close();
                }
                catch (Throwable e) {
                    this.logger.debug("[{}] failed to clean plugin shard service [{}]", e, shardId, closeable);
                }
            }
            this.closeInjectorOptionalResource(sId, shardInjector, TranslogService.class);
            if (indexShard != null) {
                try {
                    boolean flushEngine = !this.deleted.get() && this.closed.get();
                    indexShard.close(reason, flushEngine);
                }
                catch (Throwable e) {
                    this.logger.debug("[{}] failed to close index shard", e, shardId);
                }
            }
            this.closeInjectorResource(sId, shardInjector, StoreRecoveryService.class);
            this.indicesLifecycle.afterIndexShardClosed(sId, indexShard, indexSettings);
        }
        catch (Throwable throwable) {
            try {
                shardInjector.getInstance(Store.class).close();
            }
            catch (Throwable e) {
                this.logger.warn("[{}] failed to close store on shard removal (reason: [{}])", e, shardId, reason);
            }
            throw throwable;
        }
        try {
            shardInjector.getInstance(Store.class).close();
        }
        catch (Throwable e) {
            this.logger.warn("[{}] failed to close store on shard removal (reason: [{}])", e, shardId, reason);
        }
    }

    private void closeInjectorResource(ShardId shardId, Injector shardInjector, Class<? extends Closeable> ... toClose) {
        for (Class<? extends Closeable> closeable : toClose) {
            if (this.closeInjectorOptionalResource(shardId, shardInjector, closeable)) continue;
            this.logger.warn("[{}] no instance available for [{}], ignoring... ", shardId, closeable.getSimpleName());
        }
    }

    private boolean closeInjectorOptionalResource(ShardId shardId, Injector shardInjector, Class<? extends Closeable> toClose) {
        try {
            Closeable instance = shardInjector.getInstance(toClose);
            if (instance == null) {
                return false;
            }
            IOUtils.close((Closeable[])new Closeable[]{instance});
        }
        catch (Throwable t) {
            this.logger.debug("{} failed to close {}", t, shardId, Strings.toUnderscoreCase(toClose.getSimpleName()));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onShardClose(ShardLock lock, boolean ownsShard) {
        block6: {
            if (this.deleted.get()) {
                Settings indexSettings = this.indexSettings();
                try {
                    if (!ownsShard) break block6;
                    try {
                        this.indicesLifecycle.beforeIndexShardDeleted(lock.getShardId(), indexSettings);
                    }
                    finally {
                        this.indicesServices.deleteShardStore("delete index", lock, indexSettings);
                        this.indicesLifecycle.afterIndexShardDeleted(lock.getShardId(), indexSettings);
                    }
                }
                catch (IOException e) {
                    this.indicesServices.addPendingDelete(lock.getShardId(), indexSettings);
                    this.logger.debug("[{}] failed to delete shard content - scheduled a retry", e, lock.getShardId().id());
                }
            }
        }
    }

    @Override
    public Settings indexSettings() {
        return this.settingsService.getSettings();
    }

    private final class FieldDataCacheListener
    implements IndexFieldDataCache.Listener {
        final IndexService indexService;

        public FieldDataCacheListener(IndexService indexService2) {
            this.indexService = indexService2;
        }

        @Override
        public void onCache(ShardId shardId, MappedFieldType.Names fieldNames, FieldDataType fieldDataType, Accountable ramUsage) {
            IndexShard shard;
            if (shardId != null && (shard = this.indexService.shard(shardId.id())) != null) {
                shard.fieldData().onCache(shardId, fieldNames, fieldDataType, ramUsage);
            }
        }

        @Override
        public void onRemoval(ShardId shardId, MappedFieldType.Names fieldNames, FieldDataType fieldDataType, boolean wasEvicted, long sizeInBytes) {
            IndexShard shard;
            if (shardId != null && (shard = this.indexService.shard(shardId.id())) != null) {
                shard.fieldData().onRemoval(shardId, fieldNames, fieldDataType, wasEvicted, sizeInBytes);
            }
        }
    }

    private static final class BitsetCacheListener
    implements BitsetFilterCache.Listener {
        final IndexService indexService;

        private BitsetCacheListener(IndexService indexService) {
            this.indexService = indexService;
        }

        @Override
        public void onCache(ShardId shardId, Accountable accountable) {
            IndexShard shard;
            if (shardId != null && (shard = this.indexService.shard(shardId.id())) != null) {
                long ramBytesUsed = accountable != null ? accountable.ramBytesUsed() : 0L;
                shard.shardBitsetFilterCache().onCached(ramBytesUsed);
            }
        }

        @Override
        public void onRemoval(ShardId shardId, Accountable accountable) {
            IndexShard shard;
            if (shardId != null && (shard = this.indexService.shard(shardId.id())) != null) {
                long ramBytesUsed = accountable != null ? accountable.ramBytesUsed() : 0L;
                shard.shardBitsetFilterCache().onRemoval(ramBytesUsed);
            }
        }
    }

    private class StoreCloseListener
    implements Store.OnClose {
        private final ShardId shardId;
        private final boolean ownsShard;
        private final Closeable[] toClose;

        public StoreCloseListener(ShardId shardId, boolean ownsShard, Closeable ... toClose) {
            this.shardId = shardId;
            this.ownsShard = ownsShard;
            this.toClose = toClose;
        }

        @Override
        public void handle(ShardLock lock) {
            try {
                assert (lock.getShardId().equals(this.shardId)) : "shard id mismatch, expected: " + this.shardId + " but got: " + lock.getShardId();
                IndexService.this.onShardClose(lock, this.ownsShard);
            }
            finally {
                try {
                    IOUtils.close((Closeable[])this.toClose);
                }
                catch (IOException ex) {
                    IndexService.this.logger.debug("failed to close resource", ex, new Object[0]);
                }
            }
        }
    }

    private static class IndexShardInjectorPair {
        private final IndexShard indexShard;
        private final Injector injector;

        public IndexShardInjectorPair(IndexShard indexShard, Injector injector) {
            this.indexShard = indexShard;
            this.injector = injector;
        }

        public IndexShard getIndexShard() {
            return this.indexShard;
        }

        public Injector getInjector() {
            return this.injector;
        }
    }
}

