/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import com.google.common.collect.ImmutableSet;
import java.io.Reader;
import org.apache.lucene.analysis.charfilter.HTMLStripCharFilter;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractCharFilterFactory;
import org.elasticsearch.index.settings.IndexSettingsService;

public class HtmlStripCharFilterFactory
extends AbstractCharFilterFactory {
    private final ImmutableSet<String> escapedTags;

    @Inject
    public HtmlStripCharFilterFactory(Index index, IndexSettingsService indexSettingsService, @Assisted String name, @Assisted Settings settings) {
        super(index, indexSettingsService.getSettings(), name);
        Object[] escapedTags = settings.getAsArray("escaped_tags");
        this.escapedTags = escapedTags.length > 0 ? ImmutableSet.copyOf((Object[])escapedTags) : null;
    }

    public ImmutableSet<String> escapedTags() {
        return this.escapedTags;
    }

    @Override
    public Reader create(Reader tokenStream) {
        return new HTMLStripCharFilter(tokenStream, this.escapedTags);
    }
}

