/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.action;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.dfs.DfsSearchResult;
import org.elasticsearch.search.fetch.FetchSearchResult;
import org.elasticsearch.search.fetch.QueryFetchSearchResult;
import org.elasticsearch.search.fetch.ScrollQueryFetchSearchResult;
import org.elasticsearch.search.fetch.ShardFetchRequest;
import org.elasticsearch.search.fetch.ShardFetchSearchRequest;
import org.elasticsearch.search.internal.InternalScrollSearchRequest;
import org.elasticsearch.search.internal.ShardSearchTransportRequest;
import org.elasticsearch.search.query.QuerySearchRequest;
import org.elasticsearch.search.query.QuerySearchResult;
import org.elasticsearch.search.query.QuerySearchResultProvider;
import org.elasticsearch.search.query.ScrollQuerySearchResult;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public class SearchServiceTransportAction
extends AbstractComponent {
    public static final String FREE_CONTEXT_SCROLL_ACTION_NAME = "indices:data/read/search[free_context/scroll]";
    public static final String FREE_CONTEXT_ACTION_NAME = "indices:data/read/search[free_context]";
    public static final String CLEAR_SCROLL_CONTEXTS_ACTION_NAME = "indices:data/read/search[clear_scroll_contexts]";
    public static final String DFS_ACTION_NAME = "indices:data/read/search[phase/dfs]";
    public static final String QUERY_ACTION_NAME = "indices:data/read/search[phase/query]";
    public static final String QUERY_ID_ACTION_NAME = "indices:data/read/search[phase/query/id]";
    public static final String QUERY_SCROLL_ACTION_NAME = "indices:data/read/search[phase/query/scroll]";
    public static final String QUERY_FETCH_ACTION_NAME = "indices:data/read/search[phase/query+fetch]";
    public static final String QUERY_QUERY_FETCH_ACTION_NAME = "indices:data/read/search[phase/query/query+fetch]";
    public static final String QUERY_FETCH_SCROLL_ACTION_NAME = "indices:data/read/search[phase/query+fetch/scroll]";
    public static final String FETCH_ID_SCROLL_ACTION_NAME = "indices:data/read/search[phase/fetch/id/scroll]";
    public static final String FETCH_ID_ACTION_NAME = "indices:data/read/search[phase/fetch/id]";
    public static final String SCAN_ACTION_NAME = "indices:data/read/search[phase/scan]";
    public static final String SCAN_SCROLL_ACTION_NAME = "indices:data/read/search[phase/scan/scroll]";
    private final TransportService transportService;
    private final SearchService searchService;

    @Inject
    public SearchServiceTransportAction(Settings settings, TransportService transportService, SearchService searchService) {
        super(settings);
        this.transportService = transportService;
        this.searchService = searchService;
        transportService.registerRequestHandler(FREE_CONTEXT_SCROLL_ACTION_NAME, ScrollFreeContextRequest.class, "same", new FreeContextTransportHandler());
        transportService.registerRequestHandler(FREE_CONTEXT_ACTION_NAME, SearchFreeContextRequest.class, "same", new FreeContextTransportHandler());
        transportService.registerRequestHandler(CLEAR_SCROLL_CONTEXTS_ACTION_NAME, ClearScrollContextsRequest.class, "same", new ClearScrollContextsTransportHandler());
        transportService.registerRequestHandler(DFS_ACTION_NAME, ShardSearchTransportRequest.class, "search", new SearchDfsTransportHandler());
        transportService.registerRequestHandler(QUERY_ACTION_NAME, ShardSearchTransportRequest.class, "search", new SearchQueryTransportHandler());
        transportService.registerRequestHandler(QUERY_ID_ACTION_NAME, QuerySearchRequest.class, "search", new SearchQueryByIdTransportHandler());
        transportService.registerRequestHandler(QUERY_SCROLL_ACTION_NAME, InternalScrollSearchRequest.class, "search", new SearchQueryScrollTransportHandler());
        transportService.registerRequestHandler(QUERY_FETCH_ACTION_NAME, ShardSearchTransportRequest.class, "search", new SearchQueryFetchTransportHandler());
        transportService.registerRequestHandler(QUERY_QUERY_FETCH_ACTION_NAME, QuerySearchRequest.class, "search", new SearchQueryQueryFetchTransportHandler());
        transportService.registerRequestHandler(QUERY_FETCH_SCROLL_ACTION_NAME, InternalScrollSearchRequest.class, "search", new SearchQueryFetchScrollTransportHandler());
        transportService.registerRequestHandler(FETCH_ID_SCROLL_ACTION_NAME, ShardFetchRequest.class, "search", new FetchByIdTransportHandler());
        transportService.registerRequestHandler(FETCH_ID_ACTION_NAME, ShardFetchSearchRequest.class, "search", new FetchByIdTransportHandler());
        transportService.registerRequestHandler(SCAN_ACTION_NAME, ShardSearchTransportRequest.class, "search", new SearchScanTransportHandler());
        transportService.registerRequestHandler(SCAN_SCROLL_ACTION_NAME, InternalScrollSearchRequest.class, "search", new SearchScanScrollTransportHandler());
    }

    public void sendFreeContext(DiscoveryNode node, long contextId, SearchRequest request) {
        this.transportService.sendRequest(node, FREE_CONTEXT_ACTION_NAME, new SearchFreeContextRequest(request, contextId), new ActionListenerResponseHandler<SearchFreeContextResponse>((ActionListener)new ActionListener<SearchFreeContextResponse>(){

            @Override
            public void onResponse(SearchFreeContextResponse response) {
            }

            @Override
            public void onFailure(Throwable e) {
            }
        }){

            @Override
            public SearchFreeContextResponse newInstance() {
                return new SearchFreeContextResponse();
            }
        });
    }

    public void sendFreeContext(DiscoveryNode node, long contextId, ClearScrollRequest request, ActionListener<SearchFreeContextResponse> listener) {
        this.transportService.sendRequest(node, FREE_CONTEXT_SCROLL_ACTION_NAME, new ScrollFreeContextRequest(request, contextId), new ActionListenerResponseHandler<SearchFreeContextResponse>(listener){

            @Override
            public SearchFreeContextResponse newInstance() {
                return new SearchFreeContextResponse();
            }
        });
    }

    public void sendClearAllScrollContexts(DiscoveryNode node, ClearScrollRequest request, ActionListener<TransportResponse> listener) {
        this.transportService.sendRequest(node, CLEAR_SCROLL_CONTEXTS_ACTION_NAME, new ClearScrollContextsRequest(request), new ActionListenerResponseHandler<TransportResponse>(listener){

            @Override
            public TransportResponse newInstance() {
                return TransportResponse.Empty.INSTANCE;
            }
        });
    }

    public void sendExecuteDfs(DiscoveryNode node, ShardSearchTransportRequest request, ActionListener<DfsSearchResult> listener) {
        this.transportService.sendRequest(node, DFS_ACTION_NAME, request, new ActionListenerResponseHandler<DfsSearchResult>(listener){

            @Override
            public DfsSearchResult newInstance() {
                return new DfsSearchResult();
            }
        });
    }

    public void sendExecuteQuery(DiscoveryNode node, ShardSearchTransportRequest request, ActionListener<QuerySearchResultProvider> listener) {
        this.transportService.sendRequest(node, QUERY_ACTION_NAME, request, new ActionListenerResponseHandler<QuerySearchResultProvider>(listener){

            @Override
            public QuerySearchResult newInstance() {
                return new QuerySearchResult();
            }
        });
    }

    public void sendExecuteQuery(DiscoveryNode node, QuerySearchRequest request, ActionListener<QuerySearchResult> listener) {
        this.transportService.sendRequest(node, QUERY_ID_ACTION_NAME, request, new ActionListenerResponseHandler<QuerySearchResult>(listener){

            @Override
            public QuerySearchResult newInstance() {
                return new QuerySearchResult();
            }
        });
    }

    public void sendExecuteQuery(DiscoveryNode node, InternalScrollSearchRequest request, ActionListener<ScrollQuerySearchResult> listener) {
        this.transportService.sendRequest(node, QUERY_SCROLL_ACTION_NAME, request, new ActionListenerResponseHandler<ScrollQuerySearchResult>(listener){

            @Override
            public ScrollQuerySearchResult newInstance() {
                return new ScrollQuerySearchResult();
            }
        });
    }

    public void sendExecuteFetch(DiscoveryNode node, ShardSearchTransportRequest request, ActionListener<QueryFetchSearchResult> listener) {
        this.transportService.sendRequest(node, QUERY_FETCH_ACTION_NAME, request, new ActionListenerResponseHandler<QueryFetchSearchResult>(listener){

            @Override
            public QueryFetchSearchResult newInstance() {
                return new QueryFetchSearchResult();
            }
        });
    }

    public void sendExecuteFetch(DiscoveryNode node, QuerySearchRequest request, ActionListener<QueryFetchSearchResult> listener) {
        this.transportService.sendRequest(node, QUERY_QUERY_FETCH_ACTION_NAME, request, new ActionListenerResponseHandler<QueryFetchSearchResult>(listener){

            @Override
            public QueryFetchSearchResult newInstance() {
                return new QueryFetchSearchResult();
            }
        });
    }

    public void sendExecuteFetch(DiscoveryNode node, InternalScrollSearchRequest request, ActionListener<ScrollQueryFetchSearchResult> listener) {
        this.transportService.sendRequest(node, QUERY_FETCH_SCROLL_ACTION_NAME, request, new ActionListenerResponseHandler<ScrollQueryFetchSearchResult>(listener){

            @Override
            public ScrollQueryFetchSearchResult newInstance() {
                return new ScrollQueryFetchSearchResult();
            }
        });
    }

    public void sendExecuteFetch(DiscoveryNode node, ShardFetchSearchRequest request, ActionListener<FetchSearchResult> listener) {
        this.sendExecuteFetch(node, FETCH_ID_ACTION_NAME, request, listener);
    }

    public void sendExecuteFetchScroll(DiscoveryNode node, ShardFetchRequest request, ActionListener<FetchSearchResult> listener) {
        this.sendExecuteFetch(node, FETCH_ID_SCROLL_ACTION_NAME, request, listener);
    }

    private void sendExecuteFetch(DiscoveryNode node, String action, ShardFetchRequest request, ActionListener<FetchSearchResult> listener) {
        this.transportService.sendRequest(node, action, request, new ActionListenerResponseHandler<FetchSearchResult>(listener){

            @Override
            public FetchSearchResult newInstance() {
                return new FetchSearchResult();
            }
        });
    }

    public void sendExecuteScan(DiscoveryNode node, ShardSearchTransportRequest request, ActionListener<QuerySearchResult> listener) {
        this.transportService.sendRequest(node, SCAN_ACTION_NAME, request, new ActionListenerResponseHandler<QuerySearchResult>(listener){

            @Override
            public QuerySearchResult newInstance() {
                return new QuerySearchResult();
            }
        });
    }

    public void sendExecuteScan(DiscoveryNode node, InternalScrollSearchRequest request, ActionListener<ScrollQueryFetchSearchResult> listener) {
        this.transportService.sendRequest(node, SCAN_SCROLL_ACTION_NAME, request, new ActionListenerResponseHandler<ScrollQueryFetchSearchResult>(listener){

            @Override
            public ScrollQueryFetchSearchResult newInstance() {
                return new ScrollQueryFetchSearchResult();
            }
        });
    }

    class SearchScanScrollTransportHandler
    extends TransportRequestHandler<InternalScrollSearchRequest> {
        SearchScanScrollTransportHandler() {
        }

        @Override
        public void messageReceived(InternalScrollSearchRequest request, TransportChannel channel) throws Exception {
            ScrollQueryFetchSearchResult result = SearchServiceTransportAction.this.searchService.executeScan(request);
            channel.sendResponse(result);
        }
    }

    @Deprecated
    class SearchScanTransportHandler
    extends TransportRequestHandler<ShardSearchTransportRequest> {
        SearchScanTransportHandler() {
        }

        @Override
        public void messageReceived(ShardSearchTransportRequest request, TransportChannel channel) throws Exception {
            QuerySearchResult result = SearchServiceTransportAction.this.searchService.executeScan(request);
            channel.sendResponse(result);
        }
    }

    class SearchQueryFetchScrollTransportHandler
    extends TransportRequestHandler<InternalScrollSearchRequest> {
        SearchQueryFetchScrollTransportHandler() {
        }

        @Override
        public void messageReceived(InternalScrollSearchRequest request, TransportChannel channel) throws Exception {
            ScrollQueryFetchSearchResult result = SearchServiceTransportAction.this.searchService.executeFetchPhase(request);
            channel.sendResponse(result);
        }
    }

    class FetchByIdTransportHandler<Request extends ShardFetchRequest>
    extends TransportRequestHandler<Request> {
        FetchByIdTransportHandler() {
        }

        @Override
        public void messageReceived(Request request, TransportChannel channel) throws Exception {
            FetchSearchResult result = SearchServiceTransportAction.this.searchService.executeFetchPhase((ShardFetchRequest)request);
            channel.sendResponse(result);
        }
    }

    class SearchQueryQueryFetchTransportHandler
    extends TransportRequestHandler<QuerySearchRequest> {
        SearchQueryQueryFetchTransportHandler() {
        }

        @Override
        public void messageReceived(QuerySearchRequest request, TransportChannel channel) throws Exception {
            QueryFetchSearchResult result = SearchServiceTransportAction.this.searchService.executeFetchPhase(request);
            channel.sendResponse(result);
        }
    }

    class SearchQueryFetchTransportHandler
    extends TransportRequestHandler<ShardSearchTransportRequest> {
        SearchQueryFetchTransportHandler() {
        }

        @Override
        public void messageReceived(ShardSearchTransportRequest request, TransportChannel channel) throws Exception {
            QueryFetchSearchResult result = SearchServiceTransportAction.this.searchService.executeFetchPhase(request);
            channel.sendResponse(result);
        }
    }

    class SearchQueryScrollTransportHandler
    extends TransportRequestHandler<InternalScrollSearchRequest> {
        SearchQueryScrollTransportHandler() {
        }

        @Override
        public void messageReceived(InternalScrollSearchRequest request, TransportChannel channel) throws Exception {
            ScrollQuerySearchResult result = SearchServiceTransportAction.this.searchService.executeQueryPhase(request);
            channel.sendResponse(result);
        }
    }

    class SearchQueryByIdTransportHandler
    extends TransportRequestHandler<QuerySearchRequest> {
        SearchQueryByIdTransportHandler() {
        }

        @Override
        public void messageReceived(QuerySearchRequest request, TransportChannel channel) throws Exception {
            QuerySearchResult result = SearchServiceTransportAction.this.searchService.executeQueryPhase(request);
            channel.sendResponse(result);
        }
    }

    class SearchQueryTransportHandler
    extends TransportRequestHandler<ShardSearchTransportRequest> {
        SearchQueryTransportHandler() {
        }

        @Override
        public void messageReceived(ShardSearchTransportRequest request, TransportChannel channel) throws Exception {
            QuerySearchResultProvider result = SearchServiceTransportAction.this.searchService.executeQueryPhase(request);
            channel.sendResponse(result);
        }
    }

    class SearchDfsTransportHandler
    extends TransportRequestHandler<ShardSearchTransportRequest> {
        SearchDfsTransportHandler() {
        }

        @Override
        public void messageReceived(ShardSearchTransportRequest request, TransportChannel channel) throws Exception {
            DfsSearchResult result = SearchServiceTransportAction.this.searchService.executeDfsPhase(request);
            channel.sendResponse(result);
        }
    }

    class ClearScrollContextsTransportHandler
    extends TransportRequestHandler<ClearScrollContextsRequest> {
        ClearScrollContextsTransportHandler() {
        }

        @Override
        public void messageReceived(ClearScrollContextsRequest request, TransportChannel channel) throws Exception {
            SearchServiceTransportAction.this.searchService.freeAllScrollContexts();
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        }
    }

    public static class ClearScrollContextsRequest
    extends TransportRequest {
        public ClearScrollContextsRequest() {
        }

        ClearScrollContextsRequest(TransportRequest request) {
            super(request);
        }
    }

    class FreeContextTransportHandler<FreeContextRequest extends ScrollFreeContextRequest>
    extends TransportRequestHandler<FreeContextRequest> {
        FreeContextTransportHandler() {
        }

        @Override
        public void messageReceived(FreeContextRequest request, TransportChannel channel) throws Exception {
            boolean freed = SearchServiceTransportAction.this.searchService.freeContext(((ScrollFreeContextRequest)request).id());
            channel.sendResponse(new SearchFreeContextResponse(freed));
        }
    }

    public static class SearchFreeContextResponse
    extends TransportResponse {
        private boolean freed;

        SearchFreeContextResponse() {
        }

        SearchFreeContextResponse(boolean freed) {
            this.freed = freed;
        }

        public boolean isFreed() {
            return this.freed;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.freed = in.readBoolean();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeBoolean(this.freed);
        }
    }

    public static class SearchFreeContextRequest
    extends ScrollFreeContextRequest
    implements IndicesRequest {
        private OriginalIndices originalIndices;

        public SearchFreeContextRequest() {
        }

        SearchFreeContextRequest(SearchRequest request, long id) {
            super(request, id);
            this.originalIndices = new OriginalIndices(request);
        }

        @Override
        public String[] indices() {
            if (this.originalIndices == null) {
                return null;
            }
            return this.originalIndices.indices();
        }

        @Override
        public IndicesOptions indicesOptions() {
            if (this.originalIndices == null) {
                return null;
            }
            return this.originalIndices.indicesOptions();
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.originalIndices = OriginalIndices.readOriginalIndices(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            OriginalIndices.writeOriginalIndices(this.originalIndices, out);
        }
    }

    public static class ScrollFreeContextRequest
    extends TransportRequest {
        private long id;

        public ScrollFreeContextRequest() {
        }

        ScrollFreeContextRequest(ClearScrollRequest request, long id) {
            this((TransportRequest)request, id);
        }

        private ScrollFreeContextRequest(TransportRequest request, long id) {
            super(request);
            this.id = id;
        }

        public long id() {
            return this.id;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.id = in.readLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeLong(this.id);
        }
    }
}

