/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.plugins;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Map;
import net.jcip.annotations.NotThreadSafe;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.Nullable;
import org.gradle.api.Plugin;
import org.gradle.api.internal.DefaultDomainObjectSet;
import org.gradle.api.internal.plugins.DefaultPluginContainer;
import org.gradle.api.internal.plugins.PluginApplicationException;
import org.gradle.api.internal.plugins.PluginApplicator;
import org.gradle.api.internal.plugins.PluginImplementation;
import org.gradle.api.internal.plugins.PluginManagerInternal;
import org.gradle.api.internal.plugins.PluginRegistry;
import org.gradle.api.internal.plugins.PotentialPlugin;
import org.gradle.api.plugins.AppliedPlugin;
import org.gradle.api.plugins.InvalidPluginException;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.plugins.PluginInstantiationException;
import org.gradle.api.plugins.UnknownPluginException;
import org.gradle.internal.Cast;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.reflect.ObjectInstantiationException;
import org.gradle.plugin.internal.PluginId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class DefaultPluginManager
implements PluginManagerInternal {
    public static final String CORE_PLUGIN_NAMESPACE = "org.gradle";
    public static final String CORE_PLUGIN_PREFIX = "org.gradle.";
    private final Instantiator instantiator;
    private final PluginApplicator applicator;
    private final PluginRegistry pluginRegistry;
    private final DefaultPluginContainer pluginContainer;
    private final Map<Class<?>, PluginImplementation<?>> plugins = Maps.newHashMap();
    private final Map<Class<?>, Plugin<?>> instances = Maps.newHashMap();
    private final Map<PluginId, DomainObjectSet<PluginManagerInternal.PluginWithId>> idMappings = Maps.newHashMap();

    public DefaultPluginManager(PluginRegistry pluginRegistry, Instantiator instantiator, PluginApplicator applicator) {
        this.instantiator = instantiator;
        this.applicator = applicator;
        this.pluginRegistry = pluginRegistry;
        this.pluginContainer = new DefaultPluginContainer(pluginRegistry, this);
    }

    private <T> T instantiatePlugin(Class<T> type) {
        try {
            return (T)this.instantiator.newInstance(type, new Object[0]);
        }
        catch (ObjectInstantiationException e) {
            throw new PluginInstantiationException(String.format("Could not create plugin of type '%s'.", type.getSimpleName()), e.getCause());
        }
    }

    @Override
    public <P extends Plugin> P addImperativePlugin(PluginImplementation<P> plugin) {
        this.doApply(plugin);
        Class pluginClass = plugin.asClass();
        return (P)((Plugin)pluginClass.cast(this.instances.get(pluginClass)));
    }

    @Override
    public <P extends Plugin> P addImperativePlugin(Class<P> type) {
        return this.addImperativePlugin(this.pluginRegistry.inspect(type));
    }

    @Nullable
    private Runnable addPluginInternal(final PluginImplementation<?> plugin) {
        final Class pluginClass = plugin.asClass();
        if (this.plugins.containsKey(pluginClass)) {
            return null;
        }
        this.plugins.put(pluginClass, plugin);
        return new Runnable(){

            public void run() {
                ArrayList pluginIds = Lists.newArrayList(DefaultPluginManager.this.idMappings.keySet());
                for (PluginId id : pluginIds) {
                    if (!plugin.isAlsoKnownAs(id)) continue;
                    ((DomainObjectSet)DefaultPluginManager.this.idMappings.get(id)).add(new PluginManagerInternal.PluginWithId(id, pluginClass));
                }
            }
        };
    }

    @Override
    public PluginContainer getPluginContainer() {
        return this.pluginContainer;
    }

    @Override
    public void apply(PluginImplementation<?> plugin) {
        this.doApply(plugin);
    }

    @Override
    public void apply(String pluginId) {
        PluginImplementation<?> plugin = this.pluginRegistry.lookup(PluginId.unvalidated(pluginId));
        if (plugin == null) {
            throw new UnknownPluginException("Plugin with id '" + pluginId + "' not found.");
        }
        this.doApply(plugin);
    }

    @Override
    public void apply(Class<?> type) {
        this.doApply(this.pluginRegistry.inspect(type));
    }

    private void doApply(PluginImplementation<?> plugin) {
        PluginId pluginId = plugin.getPluginId();
        String pluginIdStr = pluginId == null ? null : pluginId.toString();
        Class pluginClass = plugin.asClass();
        try {
            if (plugin.getType().equals((Object)PotentialPlugin.Type.UNKNOWN)) {
                throw new InvalidPluginException("'" + pluginClass.getName() + "' is neither a plugin or a rule source and cannot be applied.");
            }
            boolean imperative = plugin.isImperative();
            Runnable adder = this.addPluginInternal(plugin);
            if (adder != null) {
                if (imperative) {
                    Plugin<?> pluginInstance = this.producePluginInstance(pluginClass);
                    this.instances.put(pluginClass, pluginInstance);
                    if (plugin.isHasRules()) {
                        this.applicator.applyImperativeRulesHybrid(pluginIdStr, pluginInstance);
                    } else {
                        this.applicator.applyImperative(pluginIdStr, pluginInstance);
                    }
                    this.pluginContainer.add(pluginInstance);
                } else {
                    this.applicator.applyRules(pluginIdStr, pluginClass);
                }
                adder.run();
            }
        }
        catch (PluginApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PluginApplicationException(plugin.getDisplayName(), e);
        }
    }

    private Plugin<?> producePluginInstance(Class<?> pluginClass) {
        Object instance = this.findInstance(pluginClass, this.pluginContainer);
        if (instance == null) {
            instance = this.instantiatePlugin(pluginClass);
        }
        return (Plugin)Cast.uncheckedCast(instance);
    }

    private <T> T findInstance(Class<T> clazz, Iterable<?> instances) {
        for (Object instance : instances) {
            if (!instance.getClass().equals(clazz)) continue;
            return clazz.cast(instance);
        }
        return null;
    }

    @Override
    public DomainObjectSet<PluginManagerInternal.PluginWithId> pluginsForId(String id) {
        PluginId pluginId = PluginId.unvalidated(id);
        DomainObjectSet<PluginManagerInternal.PluginWithId> pluginsForId = this.idMappings.get(pluginId);
        if (pluginsForId == null) {
            pluginsForId = new DefaultDomainObjectSet<PluginManagerInternal.PluginWithId>(PluginManagerInternal.PluginWithId.class, Sets.newLinkedHashSet());
            this.idMappings.put(pluginId, pluginsForId);
            for (PluginImplementation<?> plugin : this.plugins.values()) {
                if (!plugin.isAlsoKnownAs(pluginId)) continue;
                pluginsForId.add(new PluginManagerInternal.PluginWithId(pluginId, plugin.asClass()));
            }
        }
        return pluginsForId;
    }

    @Override
    public AppliedPlugin findPlugin(String id) {
        DomainObjectSet<PluginManagerInternal.PluginWithId> pluginWithIds = this.pluginsForId(id);
        if (!pluginWithIds.isEmpty()) {
            return ((PluginManagerInternal.PluginWithId)pluginWithIds.iterator().next()).asAppliedPlugin();
        }
        return null;
    }

    @Override
    public boolean hasPlugin(String id) {
        return this.findPlugin(id) != null;
    }

    @Override
    public void withPlugin(String id, final Action<? super AppliedPlugin> action) {
        Action<PluginManagerInternal.PluginWithId> wrappedAction = new Action<PluginManagerInternal.PluginWithId>(){

            public void execute(PluginManagerInternal.PluginWithId pluginWithId) {
                action.execute((Object)pluginWithId.asAppliedPlugin());
            }
        };
        this.pluginsForId(id).all(wrappedAction);
    }
}

