/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.filewatch.jdk7;

import com.google.common.base.Throwables;
import com.sun.nio.file.ExtendedWatchEventModifier;
import com.sun.nio.file.SensitivityWatchEventModifier;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystemException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.api.internal.file.FileSystemSubset;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.filewatch.FileWatcher;
import org.gradle.internal.filewatch.FileWatcherEvent;
import org.gradle.internal.filewatch.FileWatcherListener;
import org.gradle.internal.filewatch.jdk7.WatchPointsRegistry;
import org.gradle.internal.os.OperatingSystem;

class WatchServiceRegistrar
implements FileWatcherListener {
    private static final Logger LOG;
    private static final boolean FILE_TREE_WATCHING_SUPPORTED;
    private static final WatchEvent.Modifier[] WATCH_MODIFIERS;
    private static final WatchEvent.Kind[] WATCH_KINDS;
    private final WatchService watchService;
    private final FileWatcherListener delegate;
    private final Lock lock = new ReentrantLock(true);
    private final WatchPointsRegistry watchPointsRegistry = new WatchPointsRegistry(!FILE_TREE_WATCHING_SUPPORTED);

    WatchServiceRegistrar(WatchService watchService, FileWatcherListener delegate) {
        this.watchService = watchService;
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void watch(FileSystemSubset fileSystemSubset) throws IOException {
        this.lock.lock();
        try {
            LOG.debug("Begin - adding watches for {}", fileSystemSubset);
            final WatchPointsRegistry.Delta delta = this.watchPointsRegistry.appendFileSystemSubset(fileSystemSubset);
            Iterable<? extends File> startingWatchPoints = delta.getStartingWatchPoints();
            for (File file : startingWatchPoints) {
                LOG.debug("Begin - handling starting point {}", file);
                final Path dirPath = file.toPath();
                this.watchDir(dirPath);
                if (!FILE_TREE_WATCHING_SUPPORTED) {
                    Files.walkFileTree(dirPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes attrs) throws IOException {
                            if (!path.equals(dirPath)) {
                                if (delta.shouldWatch(path.toFile())) {
                                    WatchServiceRegistrar.this.watchDir(path);
                                    return FileVisitResult.CONTINUE;
                                }
                                LOG.debug("Skipping watching for {}, filtered by WatchPointsRegistry", path);
                                return FileVisitResult.SKIP_SUBTREE;
                            }
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                LOG.debug("End - handling starting point {}", file);
            }
            LOG.debug("End - adding watches for {}", fileSystemSubset);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void watchDir(Path dir) throws IOException {
        LOG.debug("Registering watch for {}", dir);
        if (Thread.currentThread().isInterrupted()) {
            LOG.debug("Skipping adding watch since current thread is interrupted.");
        }
        int retryCount = 0;
        IOException lastException = null;
        while (retryCount++ < 2) {
            try {
                dir.register(this.watchService, WATCH_KINDS, WATCH_MODIFIERS);
                return;
            }
            catch (IOException e) {
                LOG.debug("Exception in registering for watching of " + dir, e);
                lastException = e;
                if (e instanceof FileSystemException && e.getMessage() != null && e.getMessage().contains("Bad file descriptor")) {
                    LOG.debug("Retrying after 'Bad file descriptor'");
                    continue;
                }
                if (!Files.exists(dir, new LinkOption[0])) {
                    LOG.debug("Return silently since directory doesn't exist.");
                    return;
                }
                throw e;
            }
        }
        LOG.debug("Retry count exceeded, throwing last exception");
        throw lastException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChange(FileWatcher watcher, FileWatcherEvent event) {
        block7: {
            this.lock.lock();
            try {
                if (event.getType().equals((Object)FileWatcherEvent.Type.UNDEFINED) || event.getFile() == null) {
                    LOG.debug("Calling onChange with event {}", event);
                    this.deliverEventToDelegate(watcher, event);
                    return;
                }
                File file = event.getFile();
                this.maybeFire(watcher, event);
                if (Thread.currentThread().isInterrupted() || !watcher.isRunning() || !file.isDirectory() || !event.getType().equals((Object)FileWatcherEvent.Type.CREATE)) break block7;
                try {
                    this.newDirectory(watcher, file);
                }
                catch (IOException e) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    protected void deliverEventToDelegate(FileWatcher watcher, FileWatcherEvent event) {
        if (!Thread.currentThread().isInterrupted()) {
            try {
                this.delegate.onChange(watcher, event);
            }
            catch (RuntimeException e) {
                if (Throwables.getRootCause((Throwable)e) instanceof InterruptedException) {
                    return;
                }
                throw e;
            }
        } else {
            LOG.debug("Skipping event delivery since current thread is interrupted.");
        }
    }

    private void maybeFire(FileWatcher watcher, FileWatcherEvent event) {
        if (this.watchPointsRegistry.shouldFire(event.getFile())) {
            LOG.debug("Calling onChange with event {}", event);
            this.deliverEventToDelegate(watcher, event);
        } else {
            LOG.debug("Ignoring event {}", event);
        }
    }

    private void newDirectory(FileWatcher watcher, File dir) throws IOException {
        if (!watcher.isRunning()) {
            return;
        }
        LOG.debug("Begin - newDirectory {}", dir);
        if (dir.exists()) {
            File[] contents;
            if (!FILE_TREE_WATCHING_SUPPORTED) {
                this.watchDir(dir.toPath());
            }
            if ((contents = dir.listFiles()) != null) {
                for (File file : contents) {
                    this.maybeFire(watcher, FileWatcherEvent.create(file));
                    if (!watcher.isRunning()) {
                        return;
                    }
                    if (!file.isDirectory()) continue;
                    this.newDirectory(watcher, file);
                }
            }
        }
        LOG.debug("End - newDirectory {}", dir);
    }

    static {
        WatchEvent.Modifier[] modifierArray;
        LOG = Logging.getLogger(WatchServiceRegistrar.class);
        FILE_TREE_WATCHING_SUPPORTED = OperatingSystem.current().isWindows();
        if (FILE_TREE_WATCHING_SUPPORTED) {
            WatchEvent.Modifier[] modifierArray2 = new WatchEvent.Modifier[2];
            modifierArray2[0] = ExtendedWatchEventModifier.FILE_TREE;
            modifierArray = modifierArray2;
            modifierArray2[1] = SensitivityWatchEventModifier.HIGH;
        } else {
            WatchEvent.Modifier[] modifierArray3 = new WatchEvent.Modifier[1];
            modifierArray = modifierArray3;
            modifierArray3[0] = SensitivityWatchEventModifier.HIGH;
        }
        WATCH_MODIFIERS = modifierArray;
        WATCH_KINDS = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY};
    }
}

