/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.web;

import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.context.embedded.EmbeddedServletContainerInitializedEvent;
import org.springframework.boot.context.embedded.EmbeddedWebApplicationContext;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StringUtils;

public class ServerPortInfoApplicationContextInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    public void initialize(ConfigurableApplicationContext applicationContext) {
        applicationContext.addApplicationListener((ApplicationListener)new ApplicationListener<EmbeddedServletContainerInitializedEvent>(){

            public void onApplicationEvent(EmbeddedServletContainerInitializedEvent event) {
                ServerPortInfoApplicationContextInitializer.this.onApplicationEvent(event);
            }
        });
    }

    protected void onApplicationEvent(EmbeddedServletContainerInitializedEvent event) {
        String propertyName = this.getPropertyName(event.getApplicationContext());
        this.setPortProperty((ApplicationContext)event.getApplicationContext(), propertyName, event.getEmbeddedServletContainer().getPort());
    }

    protected String getPropertyName(EmbeddedWebApplicationContext context) {
        String name = context.getNamespace();
        if (StringUtils.isEmpty((Object)name)) {
            name = "server";
        }
        return "local." + name + ".port";
    }

    private void setPortProperty(ApplicationContext context, String propertyName, int port) {
        if (context instanceof ConfigurableApplicationContext) {
            Map<String, Integer> map;
            ConfigurableEnvironment environment = ((ConfigurableApplicationContext)context).getEnvironment();
            MutablePropertySources sources = environment.getPropertySources();
            if (!sources.contains("server.ports")) {
                map = new HashMap();
                MapPropertySource source = new MapPropertySource("server.ports", map);
                sources.addFirst((PropertySource)source);
            } else {
                Map value = (Map)sources.get("server.ports").getSource();
                map = value;
            }
            map.put(propertyName, port);
        }
        if (context.getParent() != null) {
            this.setPortProperty(context.getParent(), propertyName, port);
        }
    }
}

