/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.jackrabbit.webdav.version.report;

import hidden.org.apache.jackrabbit.webdav.DavConstants;
import hidden.org.apache.jackrabbit.webdav.DavException;
import hidden.org.apache.jackrabbit.webdav.DavResource;
import hidden.org.apache.jackrabbit.webdav.DavResourceLocator;
import hidden.org.apache.jackrabbit.webdav.property.HrefProperty;
import hidden.org.apache.jackrabbit.webdav.version.ActivityResource;
import hidden.org.apache.jackrabbit.webdav.version.DeltaVConstants;
import hidden.org.apache.jackrabbit.webdav.version.VersionHistoryResource;
import hidden.org.apache.jackrabbit.webdav.version.VersionResource;
import hidden.org.apache.jackrabbit.webdav.version.report.Report;
import hidden.org.apache.jackrabbit.webdav.version.report.ReportInfo;
import hidden.org.apache.jackrabbit.webdav.version.report.ReportType;
import hidden.org.apache.jackrabbit.webdav.xml.DomUtil;
import hidden.org.slf4j.Logger;
import hidden.org.slf4j.LoggerFactory;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LatestActivityVersionReport
implements Report {
    private static Logger log = LoggerFactory.getLogger(LatestActivityVersionReport.class);
    private static final String XML_LATEST_ACTIVITY_VERSION = "latest-activity-version";
    private static final String XML_LATEST_ACTIVITY_VERSION_REPORT = "latest-activity-version-report";
    public static final ReportType LATEST_ACTIVITY_VERSION = ReportType.register("latest-activity-version", DeltaVConstants.NAMESPACE, LatestActivityVersionReport.class);
    private VersionHistoryResource vhResource;
    private DavResource activity;

    public ReportType getType() {
        return LATEST_ACTIVITY_VERSION;
    }

    public boolean isMultiStatusReport() {
        return false;
    }

    public void init(DavResource resource, ReportInfo info) throws DavException {
        if (!this.getType().isRequestedReportType(info)) {
            throw new DavException(400, "DAV:latest-activity-version element expected.");
        }
        if (resource == null || !(resource instanceof VersionHistoryResource)) {
            throw new DavException(400, "DAV:latest-activity-version report can only be created for a version history resource.");
        }
        this.vhResource = (VersionHistoryResource)resource;
        String activityHref = DomUtil.getText(info.getContentElement("href", DavConstants.NAMESPACE));
        DavResourceLocator vhLocator = resource.getLocator();
        DavResourceLocator activityLocator = vhLocator.getFactory().createResourceLocator(vhLocator.getPrefix(), activityHref);
        this.activity = resource.getFactory().createResource(activityLocator, resource.getSession());
        if (!(this.activity instanceof ActivityResource)) {
            throw new DavException(400, "DAV:latest-activity-version report: The DAV:href in the request body MUST identify an activity.");
        }
    }

    public Element toXml(Document document) {
        String latestVersionHref = this.getLatestVersionHref();
        Element el = DomUtil.createElement(document, XML_LATEST_ACTIVITY_VERSION_REPORT, DeltaVConstants.NAMESPACE);
        el.appendChild(DomUtil.hrefToXml(latestVersionHref, document));
        return el;
    }

    private String getLatestVersionHref() {
        String latestVersionHref = "";
        try {
            List versionHrefs = new HrefProperty(this.activity.getProperty(ActivityResource.ACTIVITY_VERSION_SET)).getHrefs();
            VersionResource[] versions = this.vhResource.getVersions();
            for (int i = 0; i < versions.length; ++i) {
                VersionResource vr = versions[i];
                String href = vr.getHref();
                if (!versionHrefs.contains(href)) continue;
                if ("".equals(latestVersionHref)) {
                    latestVersionHref = href;
                    continue;
                }
                List predecessors = new HrefProperty(vr.getProperty(VersionResource.PREDECESSOR_SET)).getHrefs();
                if (!predecessors.contains(latestVersionHref)) continue;
                latestVersionHref = href;
            }
        }
        catch (DavException e) {
            log.error("Unexpected error while retrieving href of latest version.", e);
        }
        return latestVersionHref;
    }
}

