/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.jira.jql;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.tasks.jira.jql.JqlElementTypes;
import com.intellij.tasks.jira.jql.JqlFile;
import com.intellij.tasks.jira.jql.JqlLexer;
import com.intellij.tasks.jira.jql.JqlParser;
import com.intellij.tasks.jira.jql.JqlTokenTypes;
import org.jetbrains.annotations.NotNull;

public class JqlParserDefinition
implements ParserDefinition {
    private static final Logger LOG = Logger.getInstance(JqlParserDefinition.class);

    @NotNull
    public Lexer createLexer(Project project) {
        JqlLexer jqlLexer = new JqlLexer();
        if (jqlLexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/jira/jql/JqlParserDefinition", "createLexer"));
        }
        return jqlLexer;
    }

    public PsiParser createParser(Project project) {
        return new JqlParser();
    }

    public IFileElementType getFileNodeType() {
        return JqlElementTypes.FILE;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = JqlTokenTypes.WHITESPACES;
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/jira/jql/JqlParserDefinition", "getWhitespaceTokens"));
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = TokenSet.EMPTY;
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/jira/jql/JqlParserDefinition", "getCommentTokens"));
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = TokenSet.create((IElementType[])new IElementType[]{JqlTokenTypes.STRING_LITERAL});
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/jira/jql/JqlParserDefinition", "getStringLiteralElements"));
        }
        return tokenSet;
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        PsiElement psiElement = JqlElementTypes.Factory.createElement(node);
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/jira/jql/JqlParserDefinition", "createElement"));
        }
        return psiElement;
    }

    public PsiFile createFile(FileViewProvider viewProvider) {
        return new JqlFile(viewProvider);
    }

    public ParserDefinition.SpaceRequirements spaceExistanceTypeBetweenTokens(ASTNode left, ASTNode right) {
        return ParserDefinition.SpaceRequirements.MAY;
    }
}

