/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api;

import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubCommitSha;
import org.jetbrains.plugins.github.api.GithubUser;

public class GithubCommit
extends GithubCommitSha {
    @Nullable
    private final GithubUser myAuthor;
    @Nullable
    private final GithubUser myCommitter;
    @NotNull
    private final List<GithubCommitSha> myParents;
    @NotNull
    private final GitCommit myCommit;

    public GithubCommit(@NotNull String url, @NotNull String sha, @Nullable GithubUser author, @Nullable GithubUser committer, @NotNull List<GithubCommitSha> parents, @NotNull GitCommit commit) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/plugins/github/api/GithubCommit", "<init>"));
        }
        if (sha == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sha", "org/jetbrains/plugins/github/api/GithubCommit", "<init>"));
        }
        if (parents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parents", "org/jetbrains/plugins/github/api/GithubCommit", "<init>"));
        }
        if (commit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commit", "org/jetbrains/plugins/github/api/GithubCommit", "<init>"));
        }
        super(url, sha);
        this.myAuthor = author;
        this.myCommitter = committer;
        this.myParents = parents;
        this.myCommit = commit;
    }

    @Nullable
    public GithubUser getAuthor() {
        return this.myAuthor;
    }

    @Nullable
    public GithubUser getCommitter() {
        return this.myCommitter;
    }

    @NotNull
    public List<GithubCommitSha> getParents() {
        List<GithubCommitSha> list = this.myParents;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubCommit", "getParents"));
        }
        return list;
    }

    @NotNull
    public GitCommit getCommit() {
        GitCommit gitCommit = this.myCommit;
        if (gitCommit == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubCommit", "getCommit"));
        }
        return gitCommit;
    }

    public static class GitUser {
        @NotNull
        private final String myName;
        @NotNull
        private final String myEmail;
        @NotNull
        private final Date myDate;

        public GitUser(@NotNull String name, @NotNull String email, @NotNull Date date) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/github/api/GithubCommit$GitUser", "<init>"));
            }
            if (email == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "email", "org/jetbrains/plugins/github/api/GithubCommit$GitUser", "<init>"));
            }
            if (date == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "date", "org/jetbrains/plugins/github/api/GithubCommit$GitUser", "<init>"));
            }
            this.myName = name;
            this.myEmail = email;
            this.myDate = date;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubCommit$GitUser", "getName"));
            }
            return string;
        }

        @NotNull
        public String getEmail() {
            String string = this.myEmail;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubCommit$GitUser", "getEmail"));
            }
            return string;
        }

        @NotNull
        public Date getDate() {
            Date date = this.myDate;
            if (date == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubCommit$GitUser", "getDate"));
            }
            return date;
        }
    }

    public static class GitCommit {
        @NotNull
        private final String myMessage;
        @NotNull
        private final GitUser myAuthor;
        @NotNull
        private final GitUser myCommitter;

        public GitCommit(@NotNull String message, @NotNull GitUser author, @NotNull GitUser committer) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/plugins/github/api/GithubCommit$GitCommit", "<init>"));
            }
            if (author == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "author", "org/jetbrains/plugins/github/api/GithubCommit$GitCommit", "<init>"));
            }
            if (committer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "committer", "org/jetbrains/plugins/github/api/GithubCommit$GitCommit", "<init>"));
            }
            this.myMessage = message;
            this.myAuthor = author;
            this.myCommitter = committer;
        }

        @NotNull
        public String getMessage() {
            String string = this.myMessage;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubCommit$GitCommit", "getMessage"));
            }
            return string;
        }

        @NotNull
        public GitUser getAuthor() {
            GitUser gitUser = this.myAuthor;
            if (gitUser == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubCommit$GitCommit", "getAuthor"));
            }
            return gitUser;
        }

        @NotNull
        public GitUser getCommitter() {
            GitUser gitUser = this.myCommitter;
            if (gitUser == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubCommit$GitCommit", "getCommitter"));
            }
            return gitUser;
        }
    }
}

