/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.ui;

import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.plugins.github.ui.GithubShareDialog;

public class GithubSharePanel {
    private JPanel myPanel;
    private JTextField myRepositoryTextField;
    private JCheckBox myPrivateCheckBox;
    private JTextArea myDescriptionTextArea;
    private JTextField myRemoteTextField;
    private final GithubShareDialog myGithubShareDialog;

    public GithubSharePanel(GithubShareDialog githubShareDialog) {
        this.myGithubShareDialog = githubShareDialog;
        this.$$$setupUI$$$();
        this.myPrivateCheckBox.setSelected(false);
        DocumentAdapter changeListener = new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                GithubSharePanel.this.myGithubShareDialog.updateOkButton();
            }
        };
        this.myRepositoryTextField.getDocument().addDocumentListener((DocumentListener)changeListener);
        this.myRemoteTextField.getDocument().addDocumentListener((DocumentListener)changeListener);
    }

    public JPanel getPanel() {
        return this.myPanel;
    }

    public JComponent getPreferredFocusComponent() {
        return this.myRepositoryTextField;
    }

    public String getRepositoryName() {
        return this.myRepositoryTextField.getText().trim();
    }

    public void setRepositoryName(String name) {
        this.myRepositoryTextField.setText(name);
    }

    public String getRemoteName() {
        return this.myRemoteTextField.getText().trim();
    }

    public void setRemoteName(String name) {
        this.myRemoteTextField.setText(name);
    }

    public boolean isPrivate() {
        return this.myPrivateCheckBox.isSelected();
    }

    public String getDescription() {
        return this.myDescriptionTextArea.getText().trim();
    }

    public void setPrivateRepoAvailable(boolean privateRepoAllowed) {
        if (!privateRepoAllowed) {
            this.myPrivateCheckBox.setEnabled(false);
            this.myPrivateCheckBox.setToolTipText("Your account doesn't support private repositories");
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JCheckBox jCheckBox;
        JTextArea jTextArea;
        JTextField jTextField2;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        jLabel.setText("New repository name:");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myRepositoryTextField = jTextField2 = new JTextField();
        jPanel.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(2, 1, 1, 2, 0, 3, 7, 7, null, new Dimension(250, 100), null));
        jBScrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        this.myDescriptionTextArea = jTextArea = new JTextArea();
        jBScrollPane.setViewportView(jTextArea);
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Description");
        jPanel.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        this.myPrivateCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Private");
        jPanel.add((Component)jCheckBox, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 2, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Remote name:");
        jPanel.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myRemoteTextField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

