/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.util;

import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.ide.passwordSafe.PasswordSafeException;
import com.intellij.ide.passwordSafe.config.PasswordSafeSettings;
import com.intellij.ide.passwordSafe.impl.PasswordSafeImpl;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ThreeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.util.GithubAuthData;
import org.jetbrains.plugins.github.util.GithubUtil;

@com.intellij.openapi.components.State(name="GithubSettings", storages={@Storage(value="github_settings.xml")})
public class GithubSettings
implements PersistentStateComponent<State> {
    private static final Logger LOG = GithubUtil.LOG;
    private static final String GITHUB_SETTINGS_PASSWORD_KEY = "GITHUB_SETTINGS_PASSWORD_KEY";
    private State myState = new State();

    public State getState() {
        return this.myState;
    }

    public void loadState(State state) {
        this.myState = state;
    }

    public static GithubSettings getInstance() {
        return (GithubSettings)ServiceManager.getService(GithubSettings.class);
    }

    public int getConnectionTimeout() {
        return this.myState.CONNECTION_TIMEOUT;
    }

    public void setConnectionTimeout(int timeout) {
        this.myState.CONNECTION_TIMEOUT = timeout;
    }

    @NotNull
    public String getHost() {
        String string = this.myState.HOST;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/util/GithubSettings", "getHost"));
        }
        return string;
    }

    @Nullable
    public String getLogin() {
        return this.myState.LOGIN;
    }

    @NotNull
    public GithubAuthData.AuthType getAuthType() {
        GithubAuthData.AuthType authType = this.myState.AUTH_TYPE;
        if (authType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/util/GithubSettings", "getAuthType"));
        }
        return authType;
    }

    public boolean isAuthConfigured() {
        return !this.myState.AUTH_TYPE.equals((Object)GithubAuthData.AuthType.ANONYMOUS);
    }

    private void setHost(@NotNull String host) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "org/jetbrains/plugins/github/util/GithubSettings", "setHost"));
        }
        this.myState.HOST = StringUtil.notNullize((String)host, (String)"github.com");
    }

    private void setLogin(@Nullable String login) {
        this.myState.LOGIN = login;
    }

    private void setAuthType(@NotNull GithubAuthData.AuthType authType) {
        if (authType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "authType", "org/jetbrains/plugins/github/util/GithubSettings", "setAuthType"));
        }
        this.myState.AUTH_TYPE = authType;
    }

    public boolean isAnonymousGist() {
        return this.myState.ANONYMOUS_GIST;
    }

    public boolean isOpenInBrowserGist() {
        return this.myState.OPEN_IN_BROWSER_GIST;
    }

    public boolean isPrivateGist() {
        return this.myState.PRIVATE_GIST;
    }

    public boolean isSavePassword() {
        return this.myState.SAVE_PASSWORD;
    }

    public boolean isValidGitAuth() {
        return this.myState.VALID_GIT_AUTH;
    }

    public boolean isSavePasswordMakesSense() {
        PasswordSafeImpl passwordSafe = (PasswordSafeImpl)PasswordSafe.getInstance();
        return passwordSafe.getSettings().getProviderType() == PasswordSafeSettings.ProviderType.MASTER_PASSWORD;
    }

    public boolean isCloneGitUsingSsh() {
        return this.myState.CLONE_GIT_USING_SSH;
    }

    @NotNull
    public ThreeState getCreatePullRequestCreateRemote() {
        ThreeState threeState = this.myState.CREATE_PULL_REQUEST_CREATE_REMOTE;
        if (threeState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/util/GithubSettings", "getCreatePullRequestCreateRemote"));
        }
        return threeState;
    }

    public void setCreatePullRequestCreateRemote(@NotNull ThreeState value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/plugins/github/util/GithubSettings", "setCreatePullRequestCreateRemote"));
        }
        this.myState.CREATE_PULL_REQUEST_CREATE_REMOTE = value;
    }

    public void setAnonymousGist(boolean anonymousGist) {
        this.myState.ANONYMOUS_GIST = anonymousGist;
    }

    public void setPrivateGist(boolean privateGist) {
        this.myState.PRIVATE_GIST = privateGist;
    }

    public void setSavePassword(boolean savePassword) {
        this.myState.SAVE_PASSWORD = savePassword;
    }

    public void setValidGitAuth(boolean validGitAuth) {
        this.myState.VALID_GIT_AUTH = validGitAuth;
    }

    public void setOpenInBrowserGist(boolean openInBrowserGist) {
        this.myState.OPEN_IN_BROWSER_GIST = openInBrowserGist;
    }

    public void setCloneGitUsingSsh(boolean value) {
        this.myState.CLONE_GIT_USING_SSH = value;
    }

    @NotNull
    private String getPassword() {
        String password;
        try {
            password = PasswordSafe.getInstance().getPassword(null, GithubSettings.class, GITHUB_SETTINGS_PASSWORD_KEY);
        }
        catch (PasswordSafeException e) {
            LOG.info("Couldn't get password for key [GITHUB_SETTINGS_PASSWORD_KEY]", (Throwable)e);
            password = "";
        }
        String string = StringUtil.notNullize((String)password);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/util/GithubSettings", "getPassword"));
        }
        return string;
    }

    private void setPassword(@NotNull String password, boolean rememberPassword) {
        if (password == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "password", "org/jetbrains/plugins/github/util/GithubSettings", "setPassword"));
        }
        try {
            if (rememberPassword) {
                PasswordSafe.getInstance().storePassword(null, GithubSettings.class, GITHUB_SETTINGS_PASSWORD_KEY, password);
            } else {
                PasswordSafeImpl passwordSafe = (PasswordSafeImpl)PasswordSafe.getInstance();
                if (passwordSafe.getSettings().getProviderType() != PasswordSafeSettings.ProviderType.DO_NOT_STORE) {
                    passwordSafe.getMemoryProvider().storePassword(null, GithubSettings.class, GITHUB_SETTINGS_PASSWORD_KEY, password);
                }
            }
        }
        catch (PasswordSafeException e) {
            LOG.info("Couldn't set password for key [GITHUB_SETTINGS_PASSWORD_KEY]", (Throwable)e);
        }
    }

    private static boolean isValidGitAuth(@NotNull GithubAuthData auth) {
        if (auth == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "auth", "org/jetbrains/plugins/github/util/GithubSettings", "isValidGitAuth"));
        }
        switch (auth.getAuthType()) {
            case BASIC: {
                assert (auth.getBasicAuth() != null);
                return auth.getBasicAuth().getCode() == null;
            }
            case TOKEN: {
                return true;
            }
            case ANONYMOUS: {
                return false;
            }
        }
        throw new IllegalStateException("GithubSettings: setAuthData - wrong AuthType: " + (Object)((Object)auth.getAuthType()));
    }

    @NotNull
    public GithubAuthData getAuthData() {
        switch (this.getAuthType()) {
            case BASIC: {
                GithubAuthData githubAuthData = GithubAuthData.createBasicAuth(this.getHost(), this.getLogin(), this.getPassword());
                if (githubAuthData == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/util/GithubSettings", "getAuthData"));
                }
                return githubAuthData;
            }
            case TOKEN: {
                GithubAuthData githubAuthData = GithubAuthData.createTokenAuth(this.getHost(), this.getPassword());
                if (githubAuthData == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/util/GithubSettings", "getAuthData"));
                }
                return githubAuthData;
            }
            case ANONYMOUS: {
                GithubAuthData githubAuthData = GithubAuthData.createAnonymous();
                if (githubAuthData == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/util/GithubSettings", "getAuthData"));
                }
                return githubAuthData;
            }
        }
        throw new IllegalStateException("GithubSettings: getAuthData - wrong AuthType: " + (Object)((Object)this.getAuthType()));
    }

    public void setAuthData(@NotNull GithubAuthData auth, boolean rememberPassword) {
        if (auth == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "auth", "org/jetbrains/plugins/github/util/GithubSettings", "setAuthData"));
        }
        this.setValidGitAuth(GithubSettings.isValidGitAuth(auth));
        this.setAuthType(auth.getAuthType());
        this.setHost(auth.getHost());
        switch (auth.getAuthType()) {
            case BASIC: {
                assert (auth.getBasicAuth() != null);
                this.setLogin(auth.getBasicAuth().getLogin());
                this.setPassword(auth.getBasicAuth().getPassword(), rememberPassword);
                break;
            }
            case TOKEN: {
                assert (auth.getTokenAuth() != null);
                this.setLogin(null);
                this.setPassword(auth.getTokenAuth().getToken(), rememberPassword);
                break;
            }
            case ANONYMOUS: {
                this.setLogin(null);
                this.setPassword("", rememberPassword);
                break;
            }
            default: {
                throw new IllegalStateException("GithubSettings: setAuthData - wrong AuthType: " + (Object)((Object)auth.getAuthType()));
            }
        }
    }

    public static class State {
        @Nullable
        public String LOGIN = null;
        @NotNull
        public String HOST = "github.com";
        @NotNull
        public GithubAuthData.AuthType AUTH_TYPE = GithubAuthData.AuthType.ANONYMOUS;
        public boolean ANONYMOUS_GIST = false;
        public boolean OPEN_IN_BROWSER_GIST = true;
        public boolean PRIVATE_GIST = true;
        public boolean SAVE_PASSWORD = true;
        public int CONNECTION_TIMEOUT = 5000;
        public boolean VALID_GIT_AUTH = true;
        public ThreeState CREATE_PULL_REQUEST_CREATE_REMOTE = ThreeState.UNSURE;
        public boolean CLONE_GIT_USING_SSH = false;
    }
}

