/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.sequentialparsers.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.intellij.markdown.parser.sequentialparsers.SequentialParserUtil;
import org.intellij.markdown.parser.sequentialparsers.TokensCache;
import org.intellij.markdown.parser.sequentialparsers.impl.LinkParserUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016"}, d2={"Lorg/intellij/markdown/parser/sequentialparsers/impl/ReferenceLinkParser;", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParser;", "()V", "parse", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParser$ParsingResult;", "tokens", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache;", "rangesToGlue", "", "Lkotlin/ranges/IntRange;", "Companion"})
public final class ReferenceLinkParser
implements SequentialParser {
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public SequentialParser.ParsingResult parse(@NotNull TokensCache tokens, @NotNull Collection<IntRange> rangesToGlue) {
        Intrinsics.checkParameterIsNotNull((Object)tokens, (String)"tokens");
        Intrinsics.checkParameterIsNotNull(rangesToGlue, (String)"rangesToGlue");
        SequentialParser.ParsingResult result = new SequentialParser.ParsingResult();
        ArrayList<Integer> delegateIndices = new ArrayList<Integer>();
        List<Integer> indices = SequentialParserUtil.Companion.textRangesToIndices(rangesToGlue);
        TokensCache.Iterator iterator = tokens.new TokensCache.ListIterator(indices, 0);
        while (iterator.getType() != null) {
            ArrayList localDelegates;
            ArrayList resultNodes;
            TokensCache.Iterator afterLink;
            if (Intrinsics.areEqual((Object)iterator.getType(), (Object)MarkdownTokenTypes.LBRACKET) && (afterLink = Companion.parseReferenceLink(resultNodes = new ArrayList(), localDelegates = new ArrayList(), iterator)) != null) {
                iterator = afterLink.advance();
                result = result.withNodes(resultNodes).withFurtherProcessing(SequentialParserUtil.Companion.indicesToTextRanges(localDelegates));
                continue;
            }
            delegateIndices.add(iterator.getIndex());
            iterator = iterator.advance();
        }
        return result.withFurtherProcessing(SequentialParserUtil.Companion.indicesToTextRanges((List<Integer>)delegateIndices));
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a\b\u0018\u00010\u0004R\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\n\u0010\f\u001a\u00060\u0004R\u00020\u0005H\u0002J4\u0010\r\u001a\b\u0018\u00010\u0004R\u00020\u00052\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\n\u0010\f\u001a\u00060\u0004R\u00020\u0005J6\u0010\u0010\u001a\b\u0018\u00010\u0004R\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\n\u0010\f\u001a\u00060\u0004R\u00020\u0005H\u0002"}, d2={"Lorg/intellij/markdown/parser/sequentialparsers/impl/ReferenceLinkParser$Companion;", "", "()V", "parseFullReferenceLink", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache$Iterator;", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache;", "result", "", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParser$Node;", "delegateIndices", "", "", "iterator", "parseReferenceLink", "resultNodes", "localDelegates", "parseShortReferenceLink"})
    public static final class Companion {
        @Nullable
        public final TokensCache.Iterator parseReferenceLink(@NotNull Collection<SequentialParser.Node> resultNodes, @NotNull List<Integer> localDelegates, @NotNull TokensCache.Iterator iterator) {
            Intrinsics.checkParameterIsNotNull(resultNodes, (String)"resultNodes");
            Intrinsics.checkParameterIsNotNull(localDelegates, (String)"localDelegates");
            Intrinsics.checkParameterIsNotNull((Object)iterator, (String)"iterator");
            TokensCache.Iterator result = this.parseFullReferenceLink(resultNodes, localDelegates, iterator);
            if (result != null) {
                return result;
            }
            resultNodes.clear();
            localDelegates.clear();
            result = this.parseShortReferenceLink(resultNodes, localDelegates, iterator);
            if (result != null) {
                return result;
            }
            return null;
        }

        private final TokensCache.Iterator parseFullReferenceLink(Collection<SequentialParser.Node> result, List<Integer> delegateIndices, TokensCache.Iterator iterator) {
            TokensCache.Iterator it;
            int startIndex = iterator.getIndex();
            TokensCache.Iterator iterator2 = it = iterator;
            if (iterator2 == null) {
                Intrinsics.throwNpe();
            }
            if ((it = LinkParserUtil.Companion.parseLinkText(result, delegateIndices, iterator2)) == null) {
                return null;
            }
            if (Intrinsics.areEqual((Object)(it = it.advance()).getType(), (Object)MarkdownTokenTypes.EOL)) {
                it = it.advance();
            }
            if ((it = LinkParserUtil.Companion.parseLinkLabel(result, delegateIndices, it)) == null) {
                return null;
            }
            result.add(new SequentialParser.Node(new IntRange(startIndex, it.getIndex() + 1), MarkdownElementTypes.Companion.getFULL_REFERENCE_LINK()));
            return it;
        }

        private final TokensCache.Iterator parseShortReferenceLink(Collection<SequentialParser.Node> result, List<Integer> delegateIndices, TokensCache.Iterator iterator) {
            TokensCache.Iterator it;
            int startIndex = iterator.getIndex();
            TokensCache.Iterator iterator2 = it = iterator;
            if (iterator2 == null) {
                Intrinsics.throwNpe();
            }
            if ((it = LinkParserUtil.Companion.parseLinkLabel(result, delegateIndices, iterator2)) == null) {
                return null;
            }
            TokensCache.Iterator shortcutLinkEnd = it;
            if (Intrinsics.areEqual((Object)(it = it.advance()).getType(), (Object)MarkdownTokenTypes.EOL)) {
                it = it.advance();
            }
            it = Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.LBRACKET) && Intrinsics.areEqual((Object)it.rawLookup(1), (Object)MarkdownTokenTypes.RBRACKET) ? it.advance() : shortcutLinkEnd;
            result.add(new SequentialParser.Node(new IntRange(startIndex, it.getIndex() + 1), MarkdownElementTypes.Companion.getSHORT_REFERENCE_LINK()));
            return it;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

