/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

import java.util.ArrayList;
import java.util.List;
import lombok.ast.AbstractNode;
import lombok.ast.AstException;
import lombok.ast.AstVisitor;
import lombok.ast.Block;
import lombok.ast.Comment;
import lombok.ast.DescribedNode;
import lombok.ast.Identifier;
import lombok.ast.JavadocContainer;
import lombok.ast.ListAccessor;
import lombok.ast.MethodDeclarationTemplate;
import lombok.ast.Modifiers;
import lombok.ast.Node;
import lombok.ast.RawListAccessor;
import lombok.ast.StrictListAccessor;
import lombok.ast.TypeBody;
import lombok.ast.TypeDeclaration;
import lombok.ast.TypeMember;
import lombok.ast.TypeMemberMixin;
import lombok.ast.TypeReference;
import lombok.ast.TypeVariable;
import lombok.ast.VariableDefinition;

public class MethodDeclaration
extends AbstractNode
implements TypeMember,
DescribedNode,
JavadocContainer {
    private AbstractNode javadoc = null;
    private AbstractNode modifiers = this.adopt(new Modifiers());
    ListAccessor<TypeVariable, MethodDeclaration> typeVariables = ListAccessor.of(this, TypeVariable.class, "MethodDeclaration.typeVariables");
    private AbstractNode returnTypeReference = null;
    private AbstractNode methodName = this.adopt(new Identifier());
    ListAccessor<VariableDefinition, MethodDeclaration> parameters = ListAccessor.of(this, VariableDefinition.class, "MethodDeclaration.parameters");
    ListAccessor<TypeReference, MethodDeclaration> thrownTypeReferences = ListAccessor.of(this, TypeReference.class, "MethodDeclaration.thrownTypeReferences");
    private AbstractNode body = null;

    @Override
    public TypeBody upToTypeBody() {
        if (!(this.getParent() instanceof TypeBody)) {
            return null;
        }
        TypeBody out = (TypeBody)this.getParent();
        if (!out.rawMembers().contains(this)) {
            return null;
        }
        return out;
    }

    @Override
    public Comment astJavadoc() {
        if (!(this.javadoc instanceof Comment)) {
            return null;
        }
        return (Comment)this.javadoc;
    }

    @Override
    public MethodDeclaration astJavadoc(Comment javadoc) {
        return this.rawJavadoc(javadoc);
    }

    @Override
    public Node rawJavadoc() {
        return this.javadoc;
    }

    @Override
    public MethodDeclaration rawJavadoc(Node javadoc) {
        if (javadoc == this.javadoc) {
            return this;
        }
        if (javadoc != null) {
            this.adopt((AbstractNode)javadoc);
        }
        if (this.javadoc != null) {
            this.disown(this.javadoc);
        }
        this.javadoc = (AbstractNode)javadoc;
        return this;
    }

    public Modifiers astModifiers() {
        if (!(this.modifiers instanceof Modifiers)) {
            return null;
        }
        return (Modifiers)this.modifiers;
    }

    public MethodDeclaration astModifiers(Modifiers modifiers) {
        return this.rawModifiers(modifiers);
    }

    private MethodDeclaration rawModifiers(Node modifiers) {
        if (modifiers == this.modifiers) {
            return this;
        }
        if (modifiers != null) {
            this.adopt((AbstractNode)modifiers);
        }
        if (this.modifiers != null) {
            this.disown(this.modifiers);
        }
        this.modifiers = (AbstractNode)modifiers;
        return this;
    }

    public RawListAccessor<TypeVariable, MethodDeclaration> rawTypeVariables() {
        return this.typeVariables.asRaw();
    }

    public StrictListAccessor<TypeVariable, MethodDeclaration> astTypeVariables() {
        return this.typeVariables.asStrict();
    }

    public TypeReference astReturnTypeReference() {
        if (!(this.returnTypeReference instanceof TypeReference)) {
            return null;
        }
        return (TypeReference)this.returnTypeReference;
    }

    public MethodDeclaration astReturnTypeReference(TypeReference returnTypeReference) {
        if (returnTypeReference == null) {
            throw new NullPointerException("returnTypeReference is mandatory");
        }
        return this.rawReturnTypeReference(returnTypeReference);
    }

    public Node rawReturnTypeReference() {
        return this.returnTypeReference;
    }

    public MethodDeclaration rawReturnTypeReference(Node returnTypeReference) {
        if (returnTypeReference == this.returnTypeReference) {
            return this;
        }
        if (returnTypeReference != null) {
            this.adopt((AbstractNode)returnTypeReference);
        }
        if (this.returnTypeReference != null) {
            this.disown(this.returnTypeReference);
        }
        this.returnTypeReference = (AbstractNode)returnTypeReference;
        return this;
    }

    public Identifier astMethodName() {
        if (!(this.methodName instanceof Identifier)) {
            return null;
        }
        return (Identifier)this.methodName;
    }

    public MethodDeclaration astMethodName(Identifier methodName) {
        return this.rawMethodName(methodName);
    }

    private MethodDeclaration rawMethodName(Node methodName) {
        if (methodName == this.methodName) {
            return this;
        }
        if (methodName != null) {
            this.adopt((AbstractNode)methodName);
        }
        if (this.methodName != null) {
            this.disown(this.methodName);
        }
        this.methodName = (AbstractNode)methodName;
        return this;
    }

    public RawListAccessor<VariableDefinition, MethodDeclaration> rawParameters() {
        return this.parameters.asRaw();
    }

    public StrictListAccessor<VariableDefinition, MethodDeclaration> astParameters() {
        return this.parameters.asStrict();
    }

    public RawListAccessor<TypeReference, MethodDeclaration> rawThrownTypeReferences() {
        return this.thrownTypeReferences.asRaw();
    }

    public StrictListAccessor<TypeReference, MethodDeclaration> astThrownTypeReferences() {
        return this.thrownTypeReferences.asStrict();
    }

    public Block astBody() {
        if (!(this.body instanceof Block)) {
            return null;
        }
        return (Block)this.body;
    }

    public MethodDeclaration astBody(Block body) {
        return this.rawBody(body);
    }

    public Node rawBody() {
        return this.body;
    }

    public MethodDeclaration rawBody(Node body) {
        if (body == this.body) {
            return this;
        }
        if (body != null) {
            this.adopt((AbstractNode)body);
        }
        if (this.body != null) {
            this.disown(this.body);
        }
        this.body = (AbstractNode)body;
        return this;
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        if (this.javadoc != null) {
            result.add(this.javadoc);
        }
        if (this.modifiers != null) {
            result.add(this.modifiers);
        }
        result.addAll(this.typeVariables.backingList());
        if (this.returnTypeReference != null) {
            result.add(this.returnTypeReference);
        }
        if (this.methodName != null) {
            result.add(this.methodName);
        }
        result.addAll(this.parameters.backingList());
        result.addAll(this.thrownTypeReferences.backingList());
        if (this.body != null) {
            result.add(this.body);
        }
        return result;
    }

    @Override
    public boolean replaceChild(Node original, Node replacement) throws AstException {
        if (this.javadoc == original) {
            this.rawJavadoc(replacement);
            return true;
        }
        if (this.modifiers == original) {
            if (replacement instanceof Modifiers) {
                this.astModifiers((Modifiers)replacement);
                return true;
            }
            throw new AstException(this, String.format("Cannot replace node: replacement must be of type %s but is of type %s", "Modifiers", replacement == null ? "null" : replacement.getClass().getName()));
        }
        if (this.rawTypeVariables().replace(original, replacement)) {
            return true;
        }
        if (this.returnTypeReference == original) {
            this.rawReturnTypeReference(replacement);
            return true;
        }
        if (this.methodName == original) {
            if (replacement instanceof Identifier) {
                this.astMethodName((Identifier)replacement);
                return true;
            }
            throw new AstException(this, String.format("Cannot replace node: replacement must be of type %s but is of type %s", "Identifier", replacement == null ? "null" : replacement.getClass().getName()));
        }
        if (this.rawParameters().replace(original, replacement)) {
            return true;
        }
        if (this.rawThrownTypeReferences().replace(original, replacement)) {
            return true;
        }
        if (this.body == original) {
            this.rawBody(replacement);
            return true;
        }
        return false;
    }

    @Override
    public boolean detach(Node child) {
        if (this.javadoc == child) {
            this.disown((AbstractNode)child);
            this.javadoc = null;
            return true;
        }
        if (this.modifiers == child) {
            this.disown((AbstractNode)child);
            this.modifiers = null;
            return true;
        }
        if (this.rawTypeVariables().remove(child)) {
            return true;
        }
        if (this.returnTypeReference == child) {
            this.disown((AbstractNode)child);
            this.returnTypeReference = null;
            return true;
        }
        if (this.methodName == child) {
            this.disown((AbstractNode)child);
            this.methodName = null;
            return true;
        }
        if (this.rawParameters().remove(child)) {
            return true;
        }
        if (this.rawThrownTypeReferences().remove(child)) {
            return true;
        }
        if (this.body == child) {
            this.disown((AbstractNode)child);
            this.body = null;
            return true;
        }
        return false;
    }

    @Override
    public void accept(AstVisitor visitor) {
        if (visitor.visitMethodDeclaration(this)) {
            return;
        }
        if (this.javadoc != null) {
            this.javadoc.accept(visitor);
        }
        if (this.modifiers != null) {
            this.modifiers.accept(visitor);
        }
        for (AbstractNode child : this.typeVariables.asIterable()) {
            child.accept(visitor);
        }
        if (this.returnTypeReference != null) {
            this.returnTypeReference.accept(visitor);
        }
        if (this.methodName != null) {
            this.methodName.accept(visitor);
        }
        for (AbstractNode child : this.parameters.asIterable()) {
            child.accept(visitor);
        }
        for (AbstractNode child : this.thrownTypeReferences.asIterable()) {
            child.accept(visitor);
        }
        if (this.body != null) {
            this.body.accept(visitor);
        }
        visitor.afterVisitMethodDeclaration(this);
        visitor.endVisit(this);
    }

    @Override
    public MethodDeclaration copy() {
        MethodDeclaration result = new MethodDeclaration();
        if (this.javadoc != null) {
            result.rawJavadoc(this.javadoc.copy());
        }
        if (this.modifiers != null) {
            result.rawModifiers(this.modifiers.copy());
        }
        for (AbstractNode n : this.typeVariables.backingList()) {
            result.rawTypeVariables().addToEnd(n == null ? null : n.copy());
        }
        if (this.returnTypeReference != null) {
            result.rawReturnTypeReference(this.returnTypeReference.copy());
        }
        if (this.methodName != null) {
            result.rawMethodName(this.methodName.copy());
        }
        for (AbstractNode n : this.parameters.backingList()) {
            result.rawParameters().addToEnd(n == null ? null : n.copy());
        }
        for (AbstractNode n : this.thrownTypeReferences.backingList()) {
            result.rawThrownTypeReferences().addToEnd(n == null ? null : n.copy());
        }
        if (this.body != null) {
            result.rawBody(this.body.copy());
        }
        return result;
    }

    @Override
    public String getDescription() {
        return MethodDeclarationTemplate.getDescription(this);
    }

    public TypeDeclaration upUpToTypeDeclaration() {
        return TypeMemberMixin.upUpToTypeDeclaration(this);
    }
}

