/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.integrate.IMerger;
import org.jetbrains.idea.svn.integrate.MergerFactory;
import org.jetbrains.idea.svn.integrate.PointMerger;
import org.jetbrains.idea.svn.update.UpdateEventHandler;
import org.tmatesoft.svn.core.SVNURL;

public class ChangeSetMergerFactory
implements MergerFactory {
    @NotNull
    private final CommittedChangeList myChangeList;
    @NotNull
    private final List<Change> myChanges;

    public ChangeSetMergerFactory(@NotNull CommittedChangeList changeList, @NotNull List<Change> changes) {
        if (changeList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeList", "org/jetbrains/idea/svn/integrate/ChangeSetMergerFactory", "<init>"));
        }
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "org/jetbrains/idea/svn/integrate/ChangeSetMergerFactory", "<init>"));
        }
        this.myChangeList = changeList;
        this.myChanges = ContainerUtil.newArrayList(changes);
    }

    @Override
    public IMerger createMerger(SvnVcs vcs, File target, UpdateEventHandler handler, SVNURL currentBranchUrl, String branchName) {
        return new PointMerger(vcs, this.myChangeList, target, handler, currentBranchUrl, this.myChanges, branchName);
    }
}

