/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.metadata;

import java.util.Date;
import org.gradle.api.Nullable;
import org.gradle.internal.Factory;
import org.gradle.internal.resource.metadata.ExternalResourceMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExternalResourceMetaDataCompare {
    public static boolean isDefinitelyUnchanged(@Nullable ExternalResourceMetaData local, Factory<ExternalResourceMetaData> remoteFactory) {
        if (local == null) {
            return false;
        }
        String localEtag = local.getEtag();
        Date localLastModified = local.getLastModified();
        if (localEtag == null && localLastModified == null) {
            return false;
        }
        long localContentLength = local.getContentLength();
        if (localEtag == null && localContentLength < 1L) {
            return false;
        }
        ExternalResourceMetaData remote = (ExternalResourceMetaData)remoteFactory.create();
        if (remote == null) {
            return false;
        }
        String remoteEtag = remote.getEtag();
        if (localEtag != null && remoteEtag != null) {
            return localEtag.equals(remoteEtag);
        }
        Date remoteLastModified = remote.getLastModified();
        if (remoteLastModified == null) {
            return false;
        }
        long remoteContentLength = remote.getContentLength();
        if (remoteContentLength < 1L) {
            return false;
        }
        return localContentLength == remoteContentLength && remoteLastModified.equals(localLastModified);
    }
}

