/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.ApiDetector;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import lombok.ast.Annotation;
import lombok.ast.AnnotationDeclaration;
import lombok.ast.AnnotationElement;
import lombok.ast.AnnotationValue;
import lombok.ast.ArrayInitializer;
import lombok.ast.AstVisitor;
import lombok.ast.Block;
import lombok.ast.ClassDeclaration;
import lombok.ast.ConstructorDeclaration;
import lombok.ast.Expression;
import lombok.ast.ForwardingAstVisitor;
import lombok.ast.IntegralLiteral;
import lombok.ast.MethodDeclaration;
import lombok.ast.Modifiers;
import lombok.ast.Node;
import lombok.ast.Select;
import lombok.ast.StrictListAccessor;
import lombok.ast.StringLiteral;
import lombok.ast.TypeBody;
import lombok.ast.TypeMember;
import lombok.ast.VariableDeclaration;
import lombok.ast.VariableDefinition;
import lombok.ast.VariableDefinitionEntry;
import lombok.ast.VariableReference;

public class AnnotationDetector
extends Detector
implements Detector.JavaScanner {
    public static final Implementation IMPLEMENTATION = new Implementation(AnnotationDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue INSIDE_METHOD = Issue.create("LocalSuppress", "@SuppressLint on invalid element", "The `@SuppressAnnotation` is used to suppress Lint warnings in Java files. However, while many lint checks analyzes the Java source code, where they can find annotations on (for example) local variables, some checks are analyzing the `.class` files. And in class files, annotations only appear on classes, fields and methods. Annotations placed on local variables disappear. If you attempt to suppress a lint error for a class-file based lint check, the suppress annotation not work. You must move the annotation out to the surrounding method.", Category.CORRECTNESS, 3, Severity.ERROR, IMPLEMENTATION);
    public static final Issue UNIQUE = Issue.create("UniqueConstants", "Overlapping Enumeration Constants", "The `@IntDef` annotation allows you to create a light-weight \"enum\" or type definition. However, it's possible to accidentally specify the same value for two or more of the values, which can lead to hard-to-detect bugs. This check looks for this scenario and flags any repeated constants.\n\nIn some cases, the repeated constant is intentional (for example, renaming a constant to a more intuitive name, and leaving the old name in place for compatibility purposes.)  In that case, simply suppress this check by adding a `@SuppressLint(\"UniqueConstants\")` annotation.", Category.CORRECTNESS, 3, Severity.ERROR, IMPLEMENTATION);
    public static final Issue FLAG_STYLE = Issue.create("ShiftFlags", "Dangerous Flag Constant Declaration", "When defining multiple constants for use in flags, the recommended style is to use the form `1 << 2`, `1 << 3`, `1 << 4` and so on to ensure that the constants are unique and non-overlapping.", Category.CORRECTNESS, 3, Severity.WARNING, IMPLEMENTATION);

    @Override
    public boolean appliesTo(Context context, File file) {
        return true;
    }

    @Override
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    public List<Class<? extends Node>> getApplicableNodeTypes() {
        return Collections.singletonList(Annotation.class);
    }

    @Override
    public AstVisitor createJavaVisitor(JavaContext context) {
        return new AnnotationChecker(context);
    }

    private static Node getAnnotationScope(Annotation node) {
        AnnotationDeclaration scope = JavaContext.getParentOfType((Node)node, AnnotationDeclaration.class, true);
        if (scope == null) {
            scope = node;
        }
        return scope;
    }

    private static class AnnotationChecker
    extends ForwardingAstVisitor {
        private final JavaContext mContext;

        public AnnotationChecker(JavaContext context) {
            this.mContext = context;
        }

        public boolean visitAnnotation(Annotation node) {
            JavaParser.ResolvedNode resolved;
            String type = node.astAnnotationTypeReference().getTypeName();
            if ("SuppressLint".equals(type) || "android.annotation.SuppressLint".equals(type)) {
                Node parent = node.getParent();
                if (parent instanceof Modifiers && (parent = parent.getParent()) instanceof VariableDefinition) {
                    for (AnnotationElement element : node.astElements()) {
                        ArrayInitializer array;
                        StrictListAccessor expressions;
                        AnnotationValue valueNode = element.astValue();
                        if (valueNode == null) continue;
                        if (valueNode instanceof StringLiteral) {
                            StringLiteral literal = (StringLiteral)valueNode;
                            String id = literal.astValue();
                            if (this.checkId(node, id)) continue;
                            return super.visitAnnotation(node);
                        }
                        if (!(valueNode instanceof ArrayInitializer) || (expressions = (array = (ArrayInitializer)valueNode).astExpressions()) == null) continue;
                        for (Expression arrayElement : expressions) {
                            String id;
                            if (!(arrayElement instanceof StringLiteral) || this.checkId(node, id = ((StringLiteral)arrayElement).astValue())) continue;
                            return super.visitAnnotation(node);
                        }
                    }
                }
            } else if (("android.support.annotation.IntDef".equals(type) || "IntDef".equals(type)) && (resolved = this.mContext.resolve((Node)node)) instanceof JavaParser.ResolvedAnnotation) {
                this.ensureUniqueValues((JavaParser.ResolvedAnnotation)resolved, node);
            }
            return super.visitAnnotation(node);
        }

        private void ensureUniqueValues(JavaParser.ResolvedAnnotation annotation, Annotation node) {
            Object allowed = annotation.getValue();
            if (allowed instanceof Object[]) {
                Object[] allowedValues = (Object[])allowed;
                HashMap valueToIndex = Maps.newHashMapWithExpectedSize((int)allowedValues.length);
                List constants = null;
                for (AnnotationElement element : node.astElements()) {
                    if (element.astName() != null && !"value".equals(element.astName().astValue())) continue;
                    AnnotationValue value = element.astValue();
                    if (!(value instanceof ArrayInitializer)) break;
                    ArrayInitializer initializer = (ArrayInitializer)value;
                    constants = Lists.newArrayListWithExpectedSize((int)allowedValues.length);
                    for (Expression expression : initializer.astExpressions()) {
                        constants.add(expression);
                    }
                }
                if (constants != null) {
                    if (constants.size() != allowedValues.length) {
                        constants = null;
                    } else {
                        boolean flag;
                        boolean bl = flag = annotation.getValue("flag") == Boolean.TRUE;
                        if (flag) {
                            this.ensureUsingFlagStyle(constants);
                        }
                    }
                }
                for (int index = 0; index < allowedValues.length; ++index) {
                    Object o = allowedValues[index];
                    if (!(o instanceof Number)) continue;
                    Number number = (Number)o;
                    if (valueToIndex.containsKey(number)) {
                        Location location;
                        String message;
                        Number repeatedValue = number;
                        if (constants != null) {
                            Node constant = (Node)constants.get(index);
                            int prevIndex = (Integer)valueToIndex.get(number);
                            Node prevConstant = (Node)constants.get(prevIndex);
                            message = String.format("Constants `%1$s` and `%2$s` specify the same exact value (%3$s); this is usually a cut & paste or merge error", constant.toString(), prevConstant.toString(), repeatedValue.toString());
                            location = this.mContext.getLocation(constant);
                            Location secondary = this.mContext.getLocation(prevConstant);
                            secondary.setMessage("Previous same value");
                            location.setSecondary(secondary);
                        } else {
                            message = String.format("More than one constant specifies the same exact value (%1$s); this is usually a cut & paste ormerge error", repeatedValue.toString());
                            location = this.mContext.getLocation((Node)node);
                        }
                        Node scope = AnnotationDetector.getAnnotationScope(node);
                        this.mContext.report(UNIQUE, scope, location, message);
                        break;
                    }
                    valueToIndex.put(number, index);
                }
            }
        }

        private static List<VariableDefinitionEntry> findDeclarations(ClassDeclaration cls, List<VariableReference> references) {
            if (cls == null) {
                return Collections.emptyList();
            }
            HashMap referenceMap = Maps.newHashMap();
            for (VariableReference reference : references) {
                String name = reference.astIdentifier().astValue();
                referenceMap.put(name, reference);
            }
            ArrayList declarations = Lists.newArrayList();
            for (TypeMember member : cls.astBody().astMembers()) {
                VariableDeclaration declaration;
                VariableDefinitionEntry field;
                String name;
                if (!(member instanceof VariableDeclaration) || !referenceMap.containsKey(name = (field = (VariableDefinitionEntry)(declaration = (VariableDeclaration)member).astDefinition().astVariables().first()).astName().astValue())) continue;
                declarations.add(field);
            }
            return declarations;
        }

        private void ensureUsingFlagStyle(List<Node> constants) {
            if (constants.size() < 3) {
                return;
            }
            ArrayList references = Lists.newArrayListWithExpectedSize((int)constants.size());
            for (Node constant : constants) {
                if (!(constant instanceof VariableReference)) continue;
                references.add((VariableReference)constant);
            }
            List<VariableDefinitionEntry> entries = AnnotationChecker.findDeclarations(JavaContext.findSurroundingClass(constants.get(0)), references);
            for (VariableDefinitionEntry entry : entries) {
                IntegralLiteral literal;
                long value;
                Expression declaration = entry.astInitializer();
                if (declaration == null || !(declaration instanceof IntegralLiteral) || Math.abs(value = (literal = (IntegralLiteral)declaration).astLongValue()) <= 1L || Long.bitCount(value) != 1) continue;
                int shift = Long.numberOfTrailingZeros(value);
                String message = String.format("Consider declaring this constant using 1 << %1$d instead", shift);
                this.mContext.report(FLAG_STYLE, (Node)declaration, this.mContext.getLocation((Node)declaration), message);
            }
        }

        private boolean checkId(Annotation node, String id) {
            IssueRegistry registry = this.mContext.getDriver().getRegistry();
            Issue issue = registry.getIssue(id);
            if (issue != null && !issue.getImplementation().getScope().contains((Object)Scope.JAVA_FILE) || issue == ApiDetector.UNSUPPORTED) {
                Node parent = node.getParent();
                while (!(parent == null || parent instanceof MethodDeclaration || parent instanceof ConstructorDeclaration || parent instanceof Block)) {
                    if (parent instanceof TypeBody) {
                        return true;
                    }
                    if (issue == ApiDetector.UNSUPPORTED && parent instanceof VariableDefinition) {
                        VariableDefinition definition = (VariableDefinition)parent;
                        for (VariableDefinitionEntry entry : definition.astVariables()) {
                            Expression initializer = entry.astInitializer();
                            if (!(initializer instanceof Select)) continue;
                            return true;
                        }
                    }
                    if ((parent = parent.getParent()) != null) continue;
                    return true;
                }
                Node scope = AnnotationDetector.getAnnotationScope(node);
                this.mContext.report(INSIDE_METHOD, scope, this.mContext.getLocation((Node)node), String.format("The `@SuppressLint` annotation cannot be used on a local variable with the lint check '%1$s': move out to the surrounding method", id));
                return false;
            }
            return true;
        }
    }
}

