/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.res2.AbstractResourceRepository;
import com.android.ide.common.res2.ResourceItem;
import com.android.ide.common.resources.ResourceUrl;
import com.android.resources.ResourceType;
import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.XmlParser;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.ast.AstVisitor;
import lombok.ast.ClassDeclaration;
import lombok.ast.Expression;
import lombok.ast.ForwardingAstVisitor;
import lombok.ast.MethodInvocation;
import lombok.ast.Node;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class AppIndexingApiDetector
extends Detector
implements Detector.XmlScanner,
Detector.JavaScanner {
    private static final Implementation DEEP_LINK_IMPLEMENTATION = new Implementation(AppIndexingApiDetector.class, Scope.MANIFEST_SCOPE);
    private static final Implementation APP_INDEXING_API_IMPLEMENTATION = new Implementation(AppIndexingApiDetector.class, EnumSet.of(Scope.JAVA_FILE, Scope.MANIFEST), Scope.JAVA_FILE_SCOPE, Scope.MANIFEST_SCOPE);
    public static final Issue ISSUE_DEEP_LINK_ERROR = Issue.create("GoogleAppIndexingDeepLinkError", "Deep link not supported by app for Google App Indexing", "Ensure the deep link is supported by your app, to get installs and traffic to yourapp from Google Search.", Category.USABILITY, 5, Severity.ERROR, DEEP_LINK_IMPLEMENTATION).addMoreInfo("https://g.co/AppIndexing/AndroidStudio");
    public static final Issue ISSUE_APP_INDEXING = Issue.create("GoogleAppIndexingWarning", "Missing support for Google App Indexing", "Adds deep links to get your app into the Google index, to get installs and traffic to your app from Google Search.", Category.USABILITY, 5, Severity.WARNING, DEEP_LINK_IMPLEMENTATION).addMoreInfo("https://g.co/AppIndexing/AndroidStudio");
    public static final Issue ISSUE_APP_INDEXING_API = Issue.create("GoogleAppIndexingApiWarning", "Missing support for Google App Indexing Api", "Adds deep links to get your app into the Google index, to get installs and traffic to your app from Google Search.", Category.USABILITY, 5, Severity.WARNING, APP_INDEXING_API_IMPLEMENTATION).addMoreInfo("https://g.co/AppIndexing/AndroidStudio").setEnabledByDefault(false);
    private static final String[] PATH_ATTR_LIST = new String[]{"pathPrefix", "path"};
    private static final String SCHEME_MISSING = "android:scheme is missing";
    private static final String HOST_MISSING = "android:host is missing";
    private static final String DATA_MISSING = "Missing data element";
    private static final String URL_MISSING = "Missing URL for the intent filter";
    private static final String NOT_BROWSABLE = "Activity supporting ACTION_VIEW is not set as BROWSABLE";
    private static final String ILLEGAL_NUMBER = "android:port is not a legal number";
    private static final String APP_INDEX_START = "start";
    private static final String APP_INDEX_END = "end";
    private static final String APP_INDEX_VIEW = "view";
    private static final String APP_INDEX_VIEW_END = "viewEnd";
    private static final String CLIENT_CONNECT = "connect";
    private static final String CLIENT_DISCONNECT = "disconnect";
    private static final String ADD_API = "addApi";
    private static final String APP_INDEXING_API_CLASS = "com.google.android.gms.appindexing.AppIndexApi";
    private static final String GOOGLE_API_CLIENT_CLASS = "com.google.android.gms.common.api.GoogleApiClient";
    private static final String GOOGLE_API_CLIENT_BUILDER_CLASS = "com.google.android.gms.common.api.GoogleApiClient.Builder";
    private static final String API_CLASS = "com.google.android.gms.appindexing.AppIndex";

    @Override
    public Collection<String> getApplicableElements() {
        return Collections.singletonList("application");
    }

    @Override
    public void visitElement(XmlContext context, Element application) {
        List<Element> activities = AppIndexingApiDetector.extractChildrenByName(application, "activity");
        boolean applicationHasActionView = false;
        for (Element activity : activities) {
            Attr exported;
            List<Element> intents = AppIndexingApiDetector.extractChildrenByName(activity, "intent-filter");
            boolean activityHasActionView = false;
            for (Element intent : intents) {
                boolean actionView = AppIndexingApiDetector.hasActionView(intent);
                if (actionView) {
                    activityHasActionView = true;
                }
                AppIndexingApiDetector.visitIntent(context, intent);
            }
            if (!activityHasActionView) continue;
            applicationHasActionView = true;
            if (!activity.hasAttributeNS("http://schemas.android.com/apk/res/android", "exported") || (exported = activity.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "exported")).getValue().equals("true")) continue;
            context.report(ISSUE_DEEP_LINK_ERROR, activity, context.getLocation(activity), "Activity supporting ACTION_VIEW is not exported");
        }
        if (!applicationHasActionView) {
            context.report(ISSUE_APP_INDEXING, application, context.getLocation(application), "App is not indexable by Google Search; consider adding at least one Activity with an ACTION-VIEW intent-filler. See issue explanation for more details.");
        }
    }

    @Override
    public List<String> applicableSuperClasses() {
        return Collections.singletonList("android.app.Activity");
    }

    @Override
    public void checkClass(JavaContext javaContext, ClassDeclaration node, Node declarationOrAnonymous, JavaParser.ResolvedClass cls) {
        if (node == null) {
            return;
        }
        if (!cls.isInheritingFrom("android.app.Activity", true)) {
            return;
        }
        node.accept((AstVisitor)new MethodVisitor(javaContext));
    }

    private static Set<String> getActivitiesToCheck(Context context) {
        HashSet activitiesToCheck = Sets.newHashSet();
        List<File> manifestFiles = context.getProject().getManifestFiles();
        XmlParser xmlParser = context.getDriver().getClient().getXmlParser();
        if (xmlParser != null) {
            for (File manifest : manifestFiles) {
                XmlContext xmlContext = new XmlContext(context.getDriver(), context.getProject(), null, manifest, null, xmlParser);
                Document doc = xmlParser.parseXml(xmlContext);
                if (doc == null) continue;
                List<Element> children = LintUtils.getChildren(doc);
                for (Element child : children) {
                    if (!child.getNodeName().equals("manifest")) continue;
                    List<Element> apps = AppIndexingApiDetector.extractChildrenByName(child, "application");
                    for (Element app : apps) {
                        List<Element> acts = AppIndexingApiDetector.extractChildrenByName(app, "activity");
                        for (Element act : acts) {
                            List<Element> intents = AppIndexingApiDetector.extractChildrenByName(act, "intent-filter");
                            for (Element intent : intents) {
                                String pkg;
                                List<Element> data = AppIndexingApiDetector.extractChildrenByName(intent, "data");
                                if (data.isEmpty() || !act.hasAttributeNS("http://schemas.android.com/apk/res/android", "name")) continue;
                                Attr attr = act.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
                                String activityName = attr.getValue();
                                int dotIndex = activityName.indexOf(46);
                                if (dotIndex <= 0 && (pkg = context.getMainProject().getPackage()) != null) {
                                    activityName = dotIndex == 0 ? pkg + activityName : pkg + '.' + activityName;
                                }
                                activitiesToCheck.add(activityName);
                            }
                        }
                    }
                }
            }
        }
        return activitiesToCheck;
    }

    private static void visitIntent(XmlContext context, Element intent) {
        boolean actionView = AppIndexingApiDetector.hasActionView(intent);
        boolean browsable = AppIndexingApiDetector.isBrowsable(intent);
        boolean isHttp = false;
        boolean hasScheme = false;
        boolean hasHost = false;
        boolean hasPort = false;
        boolean hasPath = false;
        boolean hasMimeType = false;
        Element firstData = null;
        List<Element> children = AppIndexingApiDetector.extractChildrenByName(intent, "data");
        for (Element data : children) {
            if (firstData == null) {
                firstData = data;
            }
            if (AppIndexingApiDetector.isHttpSchema(data)) {
                isHttp = true;
            }
            AppIndexingApiDetector.checkSingleData(context, data);
            for (String name : PATH_ATTR_LIST) {
                if (!data.hasAttributeNS("http://schemas.android.com/apk/res/android", name)) continue;
                hasPath = true;
            }
            if (data.hasAttributeNS("http://schemas.android.com/apk/res/android", "scheme")) {
                hasScheme = true;
            }
            if (data.hasAttributeNS("http://schemas.android.com/apk/res/android", "host")) {
                hasHost = true;
            }
            if (data.hasAttributeNS("http://schemas.android.com/apk/res/android", "port")) {
                hasPort = true;
            }
            if (!data.hasAttributeNS("http://schemas.android.com/apk/res/android", "mimeType")) continue;
            hasMimeType = true;
        }
        if ((hasPath || hasHost || hasPort) && !hasScheme) {
            context.report(ISSUE_DEEP_LINK_ERROR, firstData, context.getLocation(firstData), SCHEME_MISSING);
        }
        if ((hasPath || hasPort) && !hasHost) {
            context.report(ISSUE_DEEP_LINK_ERROR, firstData, context.getLocation(firstData), HOST_MISSING);
        }
        if (actionView && browsable) {
            if (firstData == null) {
                context.report(ISSUE_DEEP_LINK_ERROR, intent, context.getLocation(intent), DATA_MISSING);
            } else if (!hasScheme && !hasMimeType) {
                context.report(ISSUE_DEEP_LINK_ERROR, firstData, context.getLocation(firstData), URL_MISSING);
            }
        }
        if (actionView && isHttp && !browsable) {
            context.report(ISSUE_APP_INDEXING, intent, context.getLocation(intent), NOT_BROWSABLE);
        }
        if (actionView && !hasScheme) {
            context.report(ISSUE_APP_INDEXING, intent, context.getLocation(intent), "Missing deep link");
        }
    }

    private static boolean hasActionView(Element intent) {
        List<Element> children = AppIndexingApiDetector.extractChildrenByName(intent, "action");
        for (Element action : children) {
            Attr attr;
            if (!action.hasAttributeNS("http://schemas.android.com/apk/res/android", "name") || !(attr = action.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name")).getValue().equals("android.intent.action.VIEW")) continue;
            return true;
        }
        return false;
    }

    private static boolean isBrowsable(Element intent) {
        List<Element> children = AppIndexingApiDetector.extractChildrenByName(intent, "category");
        for (Element e : children) {
            Attr attr;
            if (!e.hasAttributeNS("http://schemas.android.com/apk/res/android", "name") || !(attr = e.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name")).getNodeValue().equals("android.intent.category.BROWSABLE")) continue;
            return true;
        }
        return false;
    }

    private static boolean isHttpSchema(Element data) {
        String value;
        return data.hasAttributeNS("http://schemas.android.com/apk/res/android", "scheme") && ((value = data.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "scheme").getValue()).equalsIgnoreCase("http") || value.equalsIgnoreCase("https"));
    }

    private static void checkSingleData(XmlContext context, Element data) {
        for (String name : PATH_ATTR_LIST) {
            Attr attr;
            String path;
            if (!data.hasAttributeNS("http://schemas.android.com/apk/res/android", name) || (path = AppIndexingApiDetector.replaceUrlWithValue(context, (attr = data.getAttributeNodeNS("http://schemas.android.com/apk/res/android", name)).getValue())).startsWith("/") || path.startsWith("@")) continue;
            context.report(ISSUE_DEEP_LINK_ERROR, attr, context.getLocation(attr), "android:" + name + " attribute should start with '/', but it is : " + path);
        }
        if (data.hasAttributeNS("http://schemas.android.com/apk/res/android", "port")) {
            Attr attr = data.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "port");
            try {
                String port = AppIndexingApiDetector.replaceUrlWithValue(context, attr.getValue());
                Integer.parseInt(port);
            }
            catch (NumberFormatException e) {
                context.report(ISSUE_DEEP_LINK_ERROR, attr, context.getLocation(attr), ILLEGAL_NUMBER);
            }
        }
        NamedNodeMap attrs = data.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr;
            org.w3c.dom.Node item = attrs.item(i);
            if (item.getNodeType() != 2 || !(attr = (Attr)attrs.item(i)).getValue().isEmpty()) continue;
            context.report(ISSUE_DEEP_LINK_ERROR, attr, context.getLocation(attr), attr.getName() + " cannot be empty");
        }
    }

    private static String replaceUrlWithValue(XmlContext context, String str) {
        Project project = context.getProject();
        LintClient client = context.getClient();
        if (!client.supportsProjectResources()) {
            return str;
        }
        ResourceUrl style = ResourceUrl.parse((String)str);
        if (style == null || style.type != ResourceType.STRING || style.framework) {
            return str;
        }
        AbstractResourceRepository resources = client.getProjectResources(project, true);
        if (resources == null) {
            return str;
        }
        List items = resources.getResourceItem(ResourceType.STRING, style.name);
        if (items == null || items.isEmpty()) {
            return str;
        }
        ResourceValue resourceValue = ((ResourceItem)items.get(0)).getResourceValue(false);
        if (resourceValue == null) {
            return str;
        }
        return resourceValue.getValue() == null ? str : resourceValue.getValue();
    }

    private static boolean hasFirstArgument(Expression argument, List<MethodInvocation> list) {
        for (MethodInvocation method : list) {
            Expression argument1 = (Expression)method.astArguments().first();
            if (!argument.toString().equals(argument1.toString())) continue;
            return true;
        }
        return false;
    }

    private static boolean hasOperand(Expression operand, List<MethodInvocation> list) {
        for (MethodInvocation method : list) {
            Expression operand1 = method.astOperand();
            if (!operand.toString().equals(operand1.toString())) continue;
            return true;
        }
        return false;
    }

    private static List<Element> extractChildrenByName(Element node, String name) {
        ArrayList result = Lists.newArrayList();
        List<Element> children = LintUtils.getChildren(node);
        for (Element child : children) {
            if (!child.getNodeName().equals(name)) continue;
            result.add(child);
        }
        return result;
    }

    static class MethodVisitor
    extends ForwardingAstVisitor {
        private final JavaContext mJavaContext;
        private List<MethodInvocation> mStartMethods;
        private List<MethodInvocation> mEndMethods;
        private List<MethodInvocation> mConnectMethods;
        private List<MethodInvocation> mDisconnectMethods;
        private boolean mHasAddAppIndexApi;

        MethodVisitor(JavaContext javaContext) {
            this.mJavaContext = javaContext;
            this.mStartMethods = Lists.newArrayListWithExpectedSize((int)2);
            this.mEndMethods = Lists.newArrayListWithExpectedSize((int)2);
            this.mConnectMethods = Lists.newArrayListWithExpectedSize((int)2);
            this.mDisconnectMethods = Lists.newArrayListWithExpectedSize((int)2);
        }

        public boolean visitMethodInvocation(MethodInvocation node) {
            JavaParser.ResolvedField resolvedArg0;
            JavaParser.ResolvedNode arg0;
            JavaParser.ResolvedNode resolved = this.mJavaContext.resolve((Node)node);
            if (!(resolved instanceof JavaParser.ResolvedMethod)) {
                return super.visitMethodInvocation(node);
            }
            JavaParser.ResolvedMethod method = (JavaParser.ResolvedMethod)resolved;
            String methodName = node.astName().astValue();
            if (methodName.equals(AppIndexingApiDetector.APP_INDEX_START)) {
                if (method.getContainingClass().getName().equals(AppIndexingApiDetector.APP_INDEXING_API_CLASS)) {
                    this.mStartMethods.add(node);
                }
            } else if (methodName.equals(AppIndexingApiDetector.APP_INDEX_END)) {
                if (method.getContainingClass().getName().equals(AppIndexingApiDetector.APP_INDEXING_API_CLASS)) {
                    this.mEndMethods.add(node);
                }
            } else if (methodName.equals(AppIndexingApiDetector.APP_INDEX_VIEW)) {
                if (method.getContainingClass().getName().equals(AppIndexingApiDetector.APP_INDEXING_API_CLASS)) {
                    this.mStartMethods.add(node);
                }
            } else if (methodName.equals(AppIndexingApiDetector.APP_INDEX_VIEW_END)) {
                if (method.getContainingClass().getName().equals(AppIndexingApiDetector.APP_INDEXING_API_CLASS)) {
                    this.mEndMethods.add(node);
                }
            } else if (methodName.equals(AppIndexingApiDetector.CLIENT_CONNECT)) {
                if (method.getContainingClass().getName().equals(AppIndexingApiDetector.GOOGLE_API_CLIENT_CLASS)) {
                    this.mConnectMethods.add(node);
                }
            } else if (methodName.equals(AppIndexingApiDetector.CLIENT_DISCONNECT)) {
                if (method.getContainingClass().getName().equals(AppIndexingApiDetector.GOOGLE_API_CLIENT_CLASS)) {
                    this.mDisconnectMethods.add(node);
                }
            } else if (methodName.equals(AppIndexingApiDetector.ADD_API) && method.getContainingClass().getName().equals(AppIndexingApiDetector.GOOGLE_API_CLIENT_BUILDER_CLASS) && (arg0 = this.mJavaContext.resolve(node.astArguments().first())) instanceof JavaParser.ResolvedField && (resolvedArg0 = (JavaParser.ResolvedField)arg0).getContainingClass().getName().equals(AppIndexingApiDetector.API_CLASS)) {
                this.mHasAddAppIndexApi = true;
            }
            return super.visitMethodInvocation(node);
        }

        public void endVisit(Node root) {
            String message;
            if (!(root instanceof ClassDeclaration)) {
                return;
            }
            ClassDeclaration node = (ClassDeclaration)root;
            JavaParser.ResolvedNode resolvedNode = this.mJavaContext.resolve((Node)node);
            if (resolvedNode == null || !(resolvedNode instanceof JavaParser.ResolvedClass)) {
                return;
            }
            if (!((JavaParser.ResolvedClass)resolvedNode).isInheritingFrom("android.app.Activity", true)) {
                return;
            }
            Set activitiesToCheck = AppIndexingApiDetector.getActivitiesToCheck(this.mJavaContext);
            boolean hasIntent = activitiesToCheck.contains(resolvedNode.getName());
            if (!hasIntent) {
                for (MethodInvocation method : this.mStartMethods) {
                    this.mJavaContext.report(ISSUE_APP_INDEXING_API, (Node)method, this.mJavaContext.getLocation((Node)method.astName()), "Missing support for Google App Indexing in the manifest");
                }
                for (MethodInvocation method : this.mEndMethods) {
                    this.mJavaContext.report(ISSUE_APP_INDEXING_API, (Node)method, this.mJavaContext.getLocation((Node)method.astName()), "Missing support for Google App Indexing in the manifest");
                }
                return;
            }
            if (this.mStartMethods.isEmpty() && this.mEndMethods.isEmpty()) {
                this.mJavaContext.report(ISSUE_APP_INDEXING_API, (Node)node, this.mJavaContext.getLocation((Node)node.astName()), "Missing support for Google App Indexing API");
                return;
            }
            for (MethodInvocation startNode : this.mStartMethods) {
                Expression startClient = (Expression)startNode.astArguments().first();
                if (!this.mHasAddAppIndexApi) {
                    message = String.format("GoogleApiClient `%1$s` has not added support for App Indexing API", startClient.toString());
                    this.mJavaContext.report(ISSUE_APP_INDEXING_API, (Node)startClient, this.mJavaContext.getLocation((Node)startClient), message);
                }
                if (!AppIndexingApiDetector.hasOperand(startClient, this.mConnectMethods)) {
                    message = String.format("GoogleApiClient `%1$s` is not connected", startClient.toString());
                    this.mJavaContext.report(ISSUE_APP_INDEXING_API, (Node)startClient, this.mJavaContext.getLocation((Node)startClient), message);
                }
                if (AppIndexingApiDetector.hasFirstArgument(startClient, this.mEndMethods)) continue;
                this.mJavaContext.report(ISSUE_APP_INDEXING_API, (Node)startNode, this.mJavaContext.getLocation((Node)startNode.astName()), "Missing corresponding `AppIndex.AppIndexApi.end` method");
            }
            for (MethodInvocation endNode : this.mEndMethods) {
                Expression endClient = (Expression)endNode.astArguments().first();
                if (!this.mHasAddAppIndexApi) {
                    message = String.format("GoogleApiClient `%1$s` has not added support for App Indexing API", endClient.toString());
                    this.mJavaContext.report(ISSUE_APP_INDEXING_API, (Node)endClient, this.mJavaContext.getLocation((Node)endClient), message);
                }
                if (!AppIndexingApiDetector.hasOperand(endClient, this.mDisconnectMethods)) {
                    message = String.format("GoogleApiClient `%1$s` is not disconnected", endClient.toString());
                    this.mJavaContext.report(ISSUE_APP_INDEXING_API, (Node)endClient, this.mJavaContext.getLocation((Node)endClient), message);
                }
                if (AppIndexingApiDetector.hasFirstArgument(endClient, this.mStartMethods)) continue;
                this.mJavaContext.report(ISSUE_APP_INDEXING_API, (Node)endNode, this.mJavaContext.getLocation((Node)endNode.astName()), "Missing corresponding `AppIndex.AppIndexApi.start` method");
            }
        }
    }

    public static enum IssueType {
        SCHEME_MISSING("android:scheme is missing"),
        HOST_MISSING("android:host is missing"),
        DATA_MISSING("Missing data element"),
        URL_MISSING("Missing URL for the intent filter"),
        NOT_BROWSABLE("Activity supporting ACTION_VIEW is not set as BROWSABLE"),
        ILLEGAL_NUMBER("android:port is not a legal number"),
        EMPTY_FIELD("cannot be empty"),
        MISSING_SLASH("attribute should start with '/'"),
        UNKNOWN("unknown error type");

        private String message;

        private IssueType(String str) {
            this.message = str;
        }

        public static IssueType parse(String str) {
            for (IssueType type : IssueType.values()) {
                if (!str.contains(type.message)) continue;
                return type;
            }
            return UNKNOWN;
        }
    }
}

