/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.struct.consts;

import java.io.DataOutputStream;
import java.io.IOException;
import org.jetbrains.java.decompiler.struct.consts.ConstantPool;
import org.jetbrains.java.decompiler.struct.consts.PooledConstant;

public class LinkConstant
extends PooledConstant {
    public int index1;
    public int index2;
    public String classname;
    public String elementname;
    public String descriptor;
    public int paramCount = 0;
    public boolean isVoid = false;
    public boolean returnCategory2 = false;

    public LinkConstant(int type, String classname, String elementname, String descriptor) {
        this.type = type;
        this.classname = classname;
        this.elementname = elementname;
        this.descriptor = descriptor;
        this.initConstant();
    }

    public LinkConstant(int type, int index1, int index2) {
        this.type = type;
        this.index1 = index1;
        this.index2 = index2;
    }

    @Override
    public void resolveConstant(ConstantPool pool) {
        if (this.type == 12) {
            this.elementname = pool.getPrimitiveConstant(this.index1).getString();
            this.descriptor = pool.getPrimitiveConstant(this.index2).getString();
        } else if (this.type == 15) {
            LinkConstant ref_info = pool.getLinkConstant(this.index2);
            this.classname = ref_info.classname;
            this.elementname = ref_info.elementname;
            this.descriptor = ref_info.descriptor;
        } else {
            if (this.type != 18) {
                this.classname = pool.getPrimitiveConstant(this.index1).getString();
            }
            LinkConstant nametype = pool.getLinkConstant(this.index2);
            this.elementname = nametype.elementname;
            this.descriptor = nametype.descriptor;
        }
        this.initConstant();
    }

    @Override
    public void writeToStream(DataOutputStream out) throws IOException {
        out.writeByte(this.type);
        if (this.type == 15) {
            out.writeByte(this.index1);
        } else {
            out.writeShort(this.index1);
        }
        out.writeShort(this.index2);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof LinkConstant)) {
            return false;
        }
        LinkConstant cn = (LinkConstant)o;
        return this.type == cn.type && this.elementname.equals(cn.elementname) && this.descriptor.equals(cn.descriptor) && (this.type != 12 || this.classname.equals(cn.classname));
    }

    private void initConstant() {
        if (this.type == 10 || this.type == 11 || this.type == 18 || this.type == 15) {
            this.resolveDescriptor(this.descriptor);
        } else if (this.type == 9) {
            this.returnCategory2 = "D".equals(this.descriptor) || "J".equals(this.descriptor);
        }
    }

    private void resolveDescriptor(String descr) {
        String[] arr = descr.split("[()]");
        String par = arr[1];
        int index = 0;
        int counter = 0;
        int len = par.length();
        while (index < len) {
            char c = par.charAt(index);
            if (c == 'L') {
                index = par.indexOf(";", index);
            } else if (c == '[') {
                ++index;
                continue;
            }
            ++counter;
            ++index;
        }
        this.paramCount = counter;
        this.isVoid = "V".equals(arr[2]);
        this.returnCategory2 = "D".equals(arr[2]) || "J".equals(arr[2]);
    }
}

