/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.backend.js.ast;

import com.google.dart.compiler.backend.js.ast.JsContext;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsVisitor;
import com.google.dart.compiler.backend.js.ast.JsVisitorWithContext;
import com.google.dart.compiler.util.AstUtil;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class JsArrayLiteral
extends JsLiteral {
    private final List<JsExpression> expressions;

    public JsArrayLiteral() {
        this.expressions = new SmartList<JsExpression>();
    }

    public JsArrayLiteral(List<JsExpression> expressions) {
        this.expressions = expressions;
    }

    public List<JsExpression> getExpressions() {
        return this.expressions;
    }

    @Override
    public void accept(JsVisitor v) {
        v.visitArray(this);
    }

    @Override
    public void acceptChildren(JsVisitor visitor2) {
        visitor2.acceptWithInsertRemove(this.expressions);
    }

    @Override
    public void traverse(JsVisitorWithContext v, JsContext ctx) {
        if (v.visit(this, ctx)) {
            v.acceptList(this.expressions);
        }
        v.endVisit(this, ctx);
    }

    @Override
    @NotNull
    public JsArrayLiteral deepCopy() {
        JsArrayLiteral jsArrayLiteral = new JsArrayLiteral(AstUtil.deepCopy(this.expressions)).withMetadataFrom(this);
        if (jsArrayLiteral == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/dart/compiler/backend/js/ast/JsArrayLiteral", "deepCopy"));
        }
        return jsArrayLiteral;
    }
}

