/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler;

import com.google.common.collect.Sets;
import com.intellij.codeInsight.ContainerProvider;
import com.intellij.codeInsight.runner.JavaMainMethodProvider;
import com.intellij.core.CoreApplicationEnvironment;
import com.intellij.core.CoreJavaFileManager;
import com.intellij.core.JavaCoreApplicationEnvironment;
import com.intellij.core.JavaCoreProjectEnvironment;
import com.intellij.lang.java.JavaParserDefinition;
import com.intellij.mock.MockApplication;
import com.intellij.mock.MockProject;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.fileTypes.FileTypeExtensionPoint;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.PersistentFSConstants;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.ZipHandler;
import com.intellij.psi.FileContextProvider;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.augment.PsiAugmentProvider;
import com.intellij.psi.compiled.ClassFileDecompilers;
import com.intellij.psi.impl.JavaClassSupersImpl;
import com.intellij.psi.impl.PsiElementFinderImpl;
import com.intellij.psi.impl.PsiTreeChangePreprocessor;
import com.intellij.psi.impl.compiled.ClsCustomNavigationPolicy;
import com.intellij.psi.impl.file.impl.JavaFileManager;
import com.intellij.psi.meta.MetaDataContributor;
import com.intellij.psi.util.JavaClassSupers;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.JavaElementFinder;
import org.jetbrains.kotlin.asJava.KtLightClassForFacade;
import org.jetbrains.kotlin.asJava.LightClassGenerationSupport;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.CliModuleVisibilityManagerImpl;
import org.jetbrains.kotlin.cli.common.PropertiesKt;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.jvm.compiler.CliLightClassGenerationSupport;
import org.jetbrains.kotlin.cli.jvm.compiler.CompileEnvironmentException;
import org.jetbrains.kotlin.cli.jvm.compiler.CompileEnvironmentUtil;
import org.jetbrains.kotlin.cli.jvm.compiler.CompilerJarLocator;
import org.jetbrains.kotlin.cli.jvm.compiler.JavaRoot;
import org.jetbrains.kotlin.cli.jvm.compiler.JvmCliVirtualFileFinderFactory;
import org.jetbrains.kotlin.cli.jvm.compiler.JvmDependenciesIndex;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCliJavaFileManagerImpl;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreProjectEnvironment;
import org.jetbrains.kotlin.cli.jvm.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.cli.jvm.config.JavaSourceRoot;
import org.jetbrains.kotlin.cli.jvm.config.JvmClasspathRoot;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRoot;
import org.jetbrains.kotlin.codegen.extensions.ClassBuilderInterceptorExtension;
import org.jetbrains.kotlin.codegen.extensions.ExpressionCodegenExtension;
import org.jetbrains.kotlin.compiler.plugin.ComponentRegistrar;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.ContentRoot;
import org.jetbrains.kotlin.config.ContentRootsKt;
import org.jetbrains.kotlin.extensions.ExternalDeclarationsProvider;
import org.jetbrains.kotlin.extensions.StorageComponentContainerContributor;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.load.kotlin.JvmVirtualFileFinderFactory;
import org.jetbrains.kotlin.load.kotlin.KotlinBinaryClassCache;
import org.jetbrains.kotlin.load.kotlin.ModuleVisibilityManager;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.parsing.KotlinParserDefinition;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.CodeAnalyzerInitializer;
import org.jetbrains.kotlin.resolve.jvm.KotlinJavaPsiFacade;
import org.jetbrains.kotlin.resolve.jvm.extensions.AnalysisCompletedHandlerExtension;
import org.jetbrains.kotlin.resolve.jvm.extensions.PackageFragmentProviderExtension;
import org.jetbrains.kotlin.resolve.lazy.declarations.CliDeclarationProviderFactoryService;
import org.jetbrains.kotlin.resolve.lazy.declarations.DeclarationProviderFactoryService;
import org.jetbrains.kotlin.script.KotlinScriptDefinitionProvider;
import org.jetbrains.kotlin.utils.PathUtil;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 62\u00020\u0001:\u00016B\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020&J\u0014\u0010'\u001a\u00020\u001e2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0(J\u0010\u0010)\u001a\u00020*2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0012\u0010+\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020,H\u0002J\u0012\u0010-\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020&H\u0002J\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u001c0(J\u000e\u0010/\u001a\b\u0012\u0004\u0012\u00020100H\u0002J\u0018\u00102\u001a\u00020*2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u000201H\u0002R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001d\u001a\u00020\u001e8F\u00a2\u0006\f\n\u0004\b!\u0010\"\u001a\u0004\b\u001f\u0010 \u00a8\u00067"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "applicationEnvironment", "Lcom/intellij/core/JavaCoreApplicationEnvironment;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "(Lcom/intellij/openapi/Disposable;Lcom/intellij/core/JavaCoreApplicationEnvironment;Lorg/jetbrains/kotlin/config/CompilerConfiguration;)V", "application", "Lcom/intellij/mock/MockApplication;", "getApplication", "()Lcom/intellij/mock/MockApplication;", "Lcom/intellij/core/CoreApplicationEnvironment;", "getApplicationEnvironment", "()Lcom/intellij/core/CoreApplicationEnvironment;", "getConfiguration", "()Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "javaRoots", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/cli/jvm/compiler/JavaRoot;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "projectEnvironment", "Lcom/intellij/core/JavaCoreProjectEnvironment;", "sourceFiles", "Lorg/jetbrains/kotlin/psi/KtFile;", "sourceLinesOfCode", "", "getSourceLinesOfCode", "()I", "sourceLinesOfCode$delegate", "Lkotlin/Lazy;", "contentRootToVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "root", "Lorg/jetbrains/kotlin/cli/jvm/config/JvmContentRoot;", "countLinesOfCode", "", "fillClasspath", "", "findJarRoot", "Lorg/jetbrains/kotlin/cli/jvm/config/JvmClasspathRoot;", "findLocalDirectory", "getSourceFiles", "getSourceRootsCheckingForDuplicates", "", "", "report", "severity", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;", "message", "Companion", "kotlin-compiler"})
public final class KotlinCoreEnvironment {
    private final JavaCoreProjectEnvironment projectEnvironment;
    private final ArrayList<KtFile> sourceFiles;
    private final ArrayList<JavaRoot> javaRoots;
    @NotNull
    private final CompilerConfiguration configuration;
    @NotNull
    private final Lazy<Integer> sourceLinesOfCode$delegate;
    private static final Object APPLICATION_LOCK;
    private static JavaCoreApplicationEnvironment ourApplicationEnvironment;
    private static int ourProjectCount;
    private static final /* synthetic */ KProperty[] $$delegatedProperties;
    public static final Companion Companion;

    @NotNull
    public final CompilerConfiguration getConfiguration() {
        return this.configuration;
    }

    private final CoreApplicationEnvironment getApplicationEnvironment() {
        CoreApplicationEnvironment coreApplicationEnvironment = this.projectEnvironment.getEnvironment();
        Intrinsics.checkExpressionValueIsNotNull(coreApplicationEnvironment, "projectEnvironment.environment");
        return coreApplicationEnvironment;
    }

    @NotNull
    public final MockApplication getApplication() {
        MockApplication mockApplication = this.getApplicationEnvironment().getApplication();
        Intrinsics.checkExpressionValueIsNotNull(mockApplication, "applicationEnvironment.application");
        return mockApplication;
    }

    @NotNull
    public final Project getProject() {
        Project project = this.projectEnvironment.getProject();
        Intrinsics.checkExpressionValueIsNotNull(project, "projectEnvironment.project");
        return project;
    }

    /*
     * WARNING - void declaration
     */
    public final int getSourceLinesOfCode() {
        void $receiver$iv;
        Lazy<Integer> lazy = this.sourceLinesOfCode$delegate;
        KotlinCoreEnvironment kotlinCoreEnvironment = this;
        KProperty property$iv = $$delegatedProperties[0];
        return ((Number)$receiver$iv.getValue()).intValue();
    }

    /*
     * WARNING - void declaration
     */
    public final int countLinesOfCode(@NotNull List<? extends KtFile> sourceFiles) {
        void var3_3;
        Intrinsics.checkParameterIsNotNull(sourceFiles, "sourceFiles");
        Iterable $receiver$iv = sourceFiles;
        int sum$iv = 0;
        for (Object element$iv : $receiver$iv) {
            void it;
            KtFile ktFile = (KtFile)element$iv;
            int n = sum$iv;
            String text = it.getText();
            Integer n2 = StringUtil.getLineBreakCount(it.getText()) + (StringUtil.endsWithLineBreak(text) ? 0 : 1);
            sum$iv = n + ((Number)n2).intValue();
        }
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private final void fillClasspath(CompilerConfiguration configuration) {
        for (ContentRoot root : configuration.getList(CommonConfigurationKeys.CONTENT_ROOTS)) {
            JavaRoot.RootType rootType;
            FqName fqName2;
            Object object;
            VirtualFile virtualFile;
            JvmContentRoot javaRoot;
            ContentRoot contentRoot = root;
            if (!(contentRoot instanceof JvmContentRoot)) {
                contentRoot = null;
            }
            if ((JvmContentRoot)contentRoot == null) {
                continue;
            }
            if (this.contentRootToVirtualFile(javaRoot) == null) {
                continue;
            }
            this.projectEnvironment.addSourcesToClasspath(virtualFile);
            JvmContentRoot jvmContentRoot = javaRoot;
            if (!(jvmContentRoot instanceof JavaSourceRoot)) {
                jvmContentRoot = null;
            }
            if ((object = (JavaSourceRoot)jvmContentRoot) != null && (object = ((JavaSourceRoot)object).getPackagePrefix()) != null) {
                FqName fqName3;
                void $receiver$iv;
                Object object2 = object;
                String it = (String)$receiver$iv;
                if (FqNamesUtilKt.isValidJavaFqName(it)) {
                    fqName3 = new FqName(it);
                } else {
                    this.report(CompilerMessageSeverity.WARNING, "Invalid package prefix name is ignored: " + it);
                    fqName3 = null;
                }
                fqName2 = fqName3;
            } else {
                fqName2 = null;
            }
            FqName prefixPackageFqName = fqName2;
            JvmContentRoot jvmContentRoot2 = javaRoot;
            if (jvmContentRoot2 instanceof JavaSourceRoot) {
                rootType = JavaRoot.RootType.SOURCE;
            } else if (jvmContentRoot2 instanceof JvmClasspathRoot) {
                rootType = JavaRoot.RootType.BINARY;
            } else {
                throw (Throwable)new IllegalStateException();
            }
            JavaRoot.RootType rootType2 = rootType;
            this.javaRoots.add(new JavaRoot(virtualFile, rootType2, prefixPackageFqName));
        }
    }

    @Nullable
    public final VirtualFile contentRootToVirtualFile(@NotNull JvmContentRoot root) {
        Intrinsics.checkParameterIsNotNull(root, "root");
        JvmContentRoot jvmContentRoot = root;
        if (jvmContentRoot instanceof JvmClasspathRoot) {
            return root.getFile().isFile() ? this.findJarRoot((JvmClasspathRoot)root) : this.findLocalDirectory(root);
        }
        if (jvmContentRoot instanceof JavaSourceRoot) {
            return root.getFile().isDirectory() ? this.findLocalDirectory(root) : (VirtualFile)null;
        }
        throw (Throwable)new IllegalStateException("Unexpected root: " + root);
    }

    private final VirtualFile findLocalDirectory(JvmContentRoot root) {
        File path = root.getFile();
        VirtualFile localFile = this.getApplicationEnvironment().getLocalFileSystem().findFileByPath(path.getAbsolutePath());
        if (localFile == null) {
            this.report(CompilerMessageSeverity.WARNING, "Classpath entry points to a non-existent location: " + path);
            return null;
        }
        return localFile;
    }

    private final VirtualFile findJarRoot(JvmClasspathRoot root) {
        File path = root.getFile();
        VirtualFile jarFile = this.getApplicationEnvironment().getJarFileSystem().findFileByPath(path + "!/");
        if (jarFile == null) {
            this.report(CompilerMessageSeverity.WARNING, "Classpath entry points to a file that is not a JAR archive: " + path);
            return null;
        }
        return jarFile;
    }

    private final Collection<String> getSourceRootsCheckingForDuplicates() {
        LinkedHashSet<String> uniqueSourceRoots = Sets.newLinkedHashSet();
        Iterable $receiver$iv = ContentRootsKt.getKotlinSourceRoots(this.configuration);
        for (Object element$iv : $receiver$iv) {
            String path = (String)element$iv;
            if (uniqueSourceRoots.add(path)) continue;
            this.report(CompilerMessageSeverity.WARNING, "Duplicate source root: " + path);
        }
        Collection collection = uniqueSourceRoots;
        Intrinsics.checkExpressionValueIsNotNull(collection, "uniqueSourceRoots");
        return collection;
    }

    @NotNull
    public final List<KtFile> getSourceFiles() {
        return this.sourceFiles;
    }

    private final void report(CompilerMessageSeverity severity, String message) {
        MessageCollector messageCollector = this.configuration.get(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        if (messageCollector == null) {
            throw (Throwable)new CompileEnvironmentException(message);
        }
        MessageCollector messageCollector2 = messageCollector;
        messageCollector2.report(severity, message, CompilerMessageLocation.NO_LOCATION);
    }

    /*
     * WARNING - void declaration
     */
    private KotlinCoreEnvironment(Disposable parentDisposable, JavaCoreApplicationEnvironment applicationEnvironment, CompilerConfiguration configuration) {
        CompilerConfiguration compilerConfiguration;
        void $receiver$iv;
        this.projectEnvironment = new KotlinCoreProjectEnvironment(parentDisposable, applicationEnvironment){

            protected void preregisterServices() {
                ExtensionsArea extensionsArea = Extensions.getArea(this.getProject());
                Intrinsics.checkExpressionValueIsNotNull(extensionsArea, "Extensions.getArea(getProject())");
                org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment$Companion.access$registerProjectExtensionPoints(KotlinCoreEnvironment.Companion, extensionsArea);
            }
        };
        this.sourceFiles = new ArrayList();
        this.javaRoots = new ArrayList();
        CompilerConfiguration compilerConfiguration2 = configuration.copy();
        KotlinCoreEnvironment kotlinCoreEnvironment = this;
        CompilerConfiguration it = (CompilerConfiguration)$receiver$iv;
        it.setReadOnly(true);
        CompilerConfiguration compilerConfiguration3 = it;
        Intrinsics.checkExpressionValueIsNotNull(compilerConfiguration3, "it");
        CompilerConfiguration compilerConfiguration4 = compilerConfiguration = compilerConfiguration3;
        Intrinsics.checkExpressionValueIsNotNull(compilerConfiguration4, "configuration.copy().let\u2026ly(true)\n        it\n    }");
        kotlinCoreEnvironment.configuration = compilerConfiguration4;
        PersistentFSConstants.setMaxIntellisenseFileSize(FileUtilRt.LARGE_FOR_CONTENT_LOADING);
        MockProject project = this.projectEnvironment.getProject();
        project.registerService(DeclarationProviderFactoryService.class, new CliDeclarationProviderFactoryService((Collection<? extends KtFile>)this.sourceFiles));
        project.registerService(ModuleVisibilityManager.class, new CliModuleVisibilityManagerImpl());
        KotlinCoreEnvironment.Companion.registerProjectServicesForCLI(this.projectEnvironment);
        Companion.registerProjectServices(this.projectEnvironment);
        this.fillClasspath(configuration);
        CoreJavaFileManager fileManager = ServiceManager.getService(project, CoreJavaFileManager.class);
        JvmDependenciesIndex index2 = new JvmDependenciesIndex((List<JavaRoot>)this.javaRoots);
        CoreJavaFileManager coreJavaFileManager = fileManager;
        if (coreJavaFileManager == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.cli.jvm.compiler.KotlinCliJavaFileManagerImpl");
        }
        ((KotlinCliJavaFileManagerImpl)coreJavaFileManager).initIndex(index2);
        this.sourceFiles.addAll((Collection<KtFile>)CompileEnvironmentUtil.getKtFiles(project, this.getSourceRootsCheckingForDuplicates(), this.configuration, new Function1<String, Unit>(){

            @Override
            public final void invoke(String message) {
                String string = message;
                Intrinsics.checkExpressionValueIsNotNull(string, "message");
                this.report(CompilerMessageSeverity.ERROR, string);
            }
        }));
        CollectionsKt.sortedWith((Iterable)this.sourceFiles, (Comparator)new Comparator<KtFile>(){

            @Override
            public int compare(@NotNull KtFile o1, @NotNull KtFile o2) {
                Intrinsics.checkParameterIsNotNull(o1, "o1");
                Intrinsics.checkParameterIsNotNull(o2, "o2");
                String string = o1.getVirtualFile().getPath();
                String string2 = o2.getVirtualFile().getPath();
                Intrinsics.checkExpressionValueIsNotNull(string2, "o2.virtualFile.path");
                return StringsKt.compareTo(string, string2, true);
            }
        });
        KotlinScriptDefinitionProvider.getInstance(project).setScriptDefinitions(configuration.getList(CommonConfigurationKeys.SCRIPT_DEFINITIONS_KEY));
        project.registerService(JvmVirtualFileFinderFactory.class, new JvmCliVirtualFileFinderFactory(index2));
        Project project2 = project;
        Intrinsics.checkExpressionValueIsNotNull(project2, "project");
        ExternalDeclarationsProvider.Companion.registerExtensionPoint(project2);
        Project project3 = project;
        Intrinsics.checkExpressionValueIsNotNull(project3, "project");
        ExpressionCodegenExtension.Companion.registerExtensionPoint(project3);
        Project project4 = project;
        Intrinsics.checkExpressionValueIsNotNull(project4, "project");
        ClassBuilderInterceptorExtension.Companion.registerExtensionPoint(project4);
        Project project5 = project;
        Intrinsics.checkExpressionValueIsNotNull(project5, "project");
        AnalysisCompletedHandlerExtension.Companion.registerExtensionPoint(project5);
        Project project6 = project;
        Intrinsics.checkExpressionValueIsNotNull(project6, "project");
        PackageFragmentProviderExtension.Companion.registerExtensionPoint(project6);
        Project project7 = project;
        Intrinsics.checkExpressionValueIsNotNull(project7, "project");
        StorageComponentContainerContributor.Companion.registerExtensionPoint(project7);
        for (ComponentRegistrar registrar : configuration.getList(ComponentRegistrar.Companion.getPLUGIN_COMPONENT_REGISTRARS())) {
            MockProject mockProject = project;
            Intrinsics.checkExpressionValueIsNotNull(mockProject, "project");
            registrar.registerProjectComponents(mockProject, configuration);
        }
        this.sourceLinesOfCode$delegate = LazyKt.lazy((Function0)new Function0<Integer>(this){
            final /* synthetic */ KotlinCoreEnvironment this$0;

            public final int invoke() {
                return this.this$0.countLinesOfCode(KotlinCoreEnvironment.access$getSourceFiles$p(this.this$0));
            }
            {
                this.this$0 = kotlinCoreEnvironment;
                super(0);
            }
        });
    }

    static {
        Companion = new Companion(null);
        APPLICATION_LOCK = new Object();
        $$delegatedProperties = new KProperty[]{Reflection.property1(new PropertyReference1Impl(Reflection.getOrCreateKotlinClass(KotlinCoreEnvironment.class), "sourceLinesOfCode", "getSourceLinesOfCode()I"))};
    }

    @NotNull
    public static final /* synthetic */ ArrayList access$getSourceFiles$p(KotlinCoreEnvironment $this) {
        return $this.sourceFiles;
    }

    public /* synthetic */ KotlinCoreEnvironment(@NotNull Disposable parentDisposable, @NotNull JavaCoreApplicationEnvironment applicationEnvironment, @NotNull CompilerConfiguration configuration, DefaultConstructorMarker $constructor_marker) {
        this(parentDisposable, applicationEnvironment, configuration);
    }

    @JvmStatic
    @NotNull
    public static final KotlinCoreEnvironment createForProduction(@NotNull Disposable parentDisposable, @NotNull CompilerConfiguration configuration, @NotNull List<String> configFilePaths) {
        Intrinsics.checkParameterIsNotNull(parentDisposable, "parentDisposable");
        Intrinsics.checkParameterIsNotNull(configuration, "configuration");
        Intrinsics.checkParameterIsNotNull(configFilePaths, "configFilePaths");
        return Companion.createForProduction(parentDisposable, configuration, configFilePaths);
    }

    @JvmStatic
    @NotNull
    public static final KotlinCoreEnvironment createForTests(@NotNull Disposable parentDisposable, @NotNull CompilerConfiguration configuration, @NotNull List<String> extensionConfigs) {
        Intrinsics.checkParameterIsNotNull(parentDisposable, "parentDisposable");
        Intrinsics.checkParameterIsNotNull(configuration, "configuration");
        Intrinsics.checkParameterIsNotNull(extensionConfigs, "extensionConfigs");
        return Companion.createForTests(parentDisposable, configuration, extensionConfigs);
    }

    @JvmStatic
    public static final void registerApplicationServices(@NotNull JavaCoreApplicationEnvironment applicationEnvironment) {
        Intrinsics.checkParameterIsNotNull(applicationEnvironment, "applicationEnvironment");
        Companion.registerApplicationServices(applicationEnvironment);
    }

    @JvmStatic
    public static final void registerProjectServices(@NotNull JavaCoreProjectEnvironment projectEnvironment2) {
        Intrinsics.checkParameterIsNotNull(projectEnvironment2, "projectEnvironment");
        Companion.registerProjectServices(projectEnvironment2);
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002J&\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0007J&\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0007J\u0006\u0010!\u001a\u00020\"J\u001e\u0010#\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002J\b\u0010$\u001a\u00020\"H\u0002J\u0018\u0010%\u001a\u00020\"2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u001cH\u0002J\u0010\u0010'\u001a\u00020\"2\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010(\u001a\u00020\"2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010)\u001a\u00020\"2\u0006\u0010*\u001a\u00020+H\u0002J\u0010\u0010,\u001a\u00020\"2\u0006\u0010-\u001a\u00020.H\u0007J\u0010\u0010/\u001a\u00020\"2\u0006\u0010-\u001a\u00020.H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\n\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment$Companion;", "", "()V", "APPLICATION_LOCK", "Ljava/lang/Object;", "getAPPLICATION_LOCK", "()Ljava/lang/Object;", "applicationEnvironment", "Lcom/intellij/core/JavaCoreApplicationEnvironment;", "getApplicationEnvironment", "()Lcom/intellij/core/JavaCoreApplicationEnvironment;", "ourApplicationEnvironment", "getOurApplicationEnvironment", "setOurApplicationEnvironment", "(Lcom/intellij/core/JavaCoreApplicationEnvironment;)V", "ourProjectCount", "", "getOurProjectCount", "()I", "setOurProjectCount", "(I)V", "createApplicationEnvironment", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "configFilePaths", "", "", "createForProduction", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "createForTests", "extensionConfigs", "disposeApplicationEnvironment", "", "getOrCreateApplicationEnvironmentForProduction", "registerAppExtensionPoints", "registerApplicationExtensionPointsAndExtensionsFrom", "configFilePath", "registerApplicationServices", "registerApplicationServicesForCLI", "registerProjectExtensionPoints", "area", "Lcom/intellij/openapi/extensions/ExtensionsArea;", "registerProjectServices", "projectEnvironment", "Lcom/intellij/core/JavaCoreProjectEnvironment;", "registerProjectServicesForCLI", "kotlin-compiler"})
    public static final class Companion {
        private final Object getAPPLICATION_LOCK() {
            return APPLICATION_LOCK;
        }

        private final JavaCoreApplicationEnvironment getOurApplicationEnvironment() {
            return ourApplicationEnvironment;
        }

        private final void setOurApplicationEnvironment(JavaCoreApplicationEnvironment javaCoreApplicationEnvironment) {
            ourApplicationEnvironment = javaCoreApplicationEnvironment;
        }

        private final int getOurProjectCount() {
            return ourProjectCount;
        }

        private final void setOurProjectCount(int n) {
            ourProjectCount = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final KotlinCoreEnvironment createForProduction(@NotNull Disposable parentDisposable, @NotNull CompilerConfiguration configuration, @NotNull List<String> configFilePaths) {
            void lock$iv;
            Intrinsics.checkParameterIsNotNull(parentDisposable, "parentDisposable");
            Intrinsics.checkParameterIsNotNull(configuration, "configuration");
            Intrinsics.checkParameterIsNotNull(configFilePaths, "configFilePaths");
            JavaCoreApplicationEnvironment appEnv = this.getOrCreateApplicationEnvironmentForProduction(configuration, configFilePaths);
            Boolean bl = PropertiesKt.toBooleanLenient(System.getProperty(PropertiesKt.getKOTLIN_COMPILER_ENVIRONMENT_KEEPALIVE_PROPERTY()));
            if (!(bl != null ? bl : false)) {
                Disposer.register(parentDisposable, new Disposable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void dispose() {
                        Object lock$iv = org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment$Companion.access$getAPPLICATION_LOCK$p(KotlinCoreEnvironment.Companion);
                        synchronized (lock$iv) {
                            Companion companion = KotlinCoreEnvironment.Companion;
                            org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment$Companion.access$setOurProjectCount$p(companion, org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment$Companion.access$getOurProjectCount$p(companion) + -1);
                            if (org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment$Companion.access$getOurProjectCount$p(companion) <= 0) {
                                KotlinCoreEnvironment.Companion.disposeApplicationEnvironment();
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                    }
                });
            }
            KotlinCoreEnvironment environment2 = new KotlinCoreEnvironment(parentDisposable, appEnv, configuration, null);
            Object object = this.getAPPLICATION_LOCK();
            synchronized (lock$iv) {
                Companion companion = Companion;
                int n = companion.getOurProjectCount();
                companion.setOurProjectCount(n + 1);
            }
            return environment2;
        }

        @JvmStatic
        @NotNull
        public final KotlinCoreEnvironment createForTests(@NotNull Disposable parentDisposable, @NotNull CompilerConfiguration configuration, @NotNull List<String> extensionConfigs) {
            Intrinsics.checkParameterIsNotNull(parentDisposable, "parentDisposable");
            Intrinsics.checkParameterIsNotNull(configuration, "configuration");
            Intrinsics.checkParameterIsNotNull(extensionConfigs, "extensionConfigs");
            return new KotlinCoreEnvironment(parentDisposable, this.createApplicationEnvironment(parentDisposable, configuration, extensionConfigs), configuration, null);
        }

        @Nullable
        public final JavaCoreApplicationEnvironment getApplicationEnvironment() {
            return Companion.getOurApplicationEnvironment();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final JavaCoreApplicationEnvironment getOrCreateApplicationEnvironmentForProduction(CompilerConfiguration configuration, List<String> configFilePaths) {
            Object lock$iv = this.getAPPLICATION_LOCK();
            synchronized (lock$iv) {
                Disposable parentDisposable;
                block6: {
                    if (Companion.getOurApplicationEnvironment() == null) break block6;
                    JavaCoreApplicationEnvironment javaCoreApplicationEnvironment = Companion.getOurApplicationEnvironment();
                    if (javaCoreApplicationEnvironment == null) {
                        Intrinsics.throwNpe();
                    }
                    JavaCoreApplicationEnvironment javaCoreApplicationEnvironment2 = javaCoreApplicationEnvironment;
                    return javaCoreApplicationEnvironment2;
                }
                Disposable disposable = parentDisposable = Disposer.newDisposable();
                Intrinsics.checkExpressionValueIsNotNull(disposable, "parentDisposable");
                Companion.setOurApplicationEnvironment(Companion.createApplicationEnvironment(disposable, configuration, configFilePaths));
                Companion.setOurProjectCount(0);
                Disposer.register(parentDisposable, new Disposable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void dispose() {
                        Object lock$iv = org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment$Companion.access$getAPPLICATION_LOCK$p(KotlinCoreEnvironment.Companion);
                        synchronized (lock$iv) {
                            org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment$Companion.access$setOurApplicationEnvironment$p(KotlinCoreEnvironment.Companion, null);
                            Unit unit = Unit.INSTANCE;
                        }
                    }
                });
                JavaCoreApplicationEnvironment javaCoreApplicationEnvironment = Companion.getOurApplicationEnvironment();
                if (javaCoreApplicationEnvironment == null) {
                    Intrinsics.throwNpe();
                }
                JavaCoreApplicationEnvironment javaCoreApplicationEnvironment3 = javaCoreApplicationEnvironment;
                return javaCoreApplicationEnvironment3;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void disposeApplicationEnvironment() {
            Object lock$iv = this.getAPPLICATION_LOCK();
            synchronized (lock$iv) {
                JavaCoreApplicationEnvironment javaCoreApplicationEnvironment = Companion.getOurApplicationEnvironment();
                if (javaCoreApplicationEnvironment == null) {
                    return;
                }
                JavaCoreApplicationEnvironment environment2 = javaCoreApplicationEnvironment;
                Companion.setOurApplicationEnvironment(null);
                Disposer.dispose(environment2.getParentDisposable());
                ZipHandler.clearFileAccessorCache();
                Unit unit = Unit.INSTANCE;
            }
        }

        private final JavaCoreApplicationEnvironment createApplicationEnvironment(Disposable parentDisposable, CompilerConfiguration configuration, List<String> configFilePaths) {
            Extensions.cleanRootArea(parentDisposable);
            this.registerAppExtensionPoints();
            JavaCoreApplicationEnvironment applicationEnvironment = new JavaCoreApplicationEnvironment(parentDisposable);
            for (String configPath : configFilePaths) {
                this.registerApplicationExtensionPointsAndExtensionsFrom(configuration, configPath);
            }
            this.registerApplicationServicesForCLI(applicationEnvironment);
            this.registerApplicationServices(applicationEnvironment);
            return applicationEnvironment;
        }

        private final void registerAppExtensionPoints() {
            CoreApplicationEnvironment.registerExtensionPoint(Extensions.getRootArea(), "com.intellij.filetype.stubBuilder", FileTypeExtensionPoint.class);
            CoreApplicationEnvironment.registerExtensionPoint(Extensions.getRootArea(), FileContextProvider.EP_NAME, FileContextProvider.class);
            CoreApplicationEnvironment.registerExtensionPoint(Extensions.getRootArea(), MetaDataContributor.EP_NAME, MetaDataContributor.class);
            CoreApplicationEnvironment.registerExtensionPoint(Extensions.getRootArea(), PsiAugmentProvider.EP_NAME, PsiAugmentProvider.class);
            CoreApplicationEnvironment.registerExtensionPoint(Extensions.getRootArea(), JavaMainMethodProvider.EP_NAME, JavaMainMethodProvider.class);
            CoreApplicationEnvironment.registerExtensionPoint(Extensions.getRootArea(), ContainerProvider.EP_NAME, ContainerProvider.class);
            CoreApplicationEnvironment.registerExtensionPoint(Extensions.getRootArea(), ClsCustomNavigationPolicy.EP_NAME, ClsCustomNavigationPolicy.class);
            CoreApplicationEnvironment.registerExtensionPoint(Extensions.getRootArea(), ClassFileDecompilers.EP_NAME, ClassFileDecompilers.Decompiler.class);
        }

        private final void registerApplicationExtensionPointsAndExtensionsFrom(CompilerConfiguration configuration, String configFilePath) {
            CompilerJarLocator locator = configuration.get(JVMConfigurationKeys.COMPILER_JAR_LOCATOR);
            File pluginRoot = locator == null ? PathUtil.getPathUtilJar() : locator.getCompilerJar();
            Application app = ApplicationManager.getApplication();
            File parentFile = pluginRoot.getParentFile();
            if (pluginRoot.isDirectory() && app != null && app.isUnitTestMode() && StringsKt.endsWith$default(FileUtil.toCanonicalPath(parentFile.getPath()), "out/production", false, 2, null)) {
                File srcDir = parentFile.getParentFile().getParentFile();
                pluginRoot = new File(srcDir, "idea/src");
            }
            CoreApplicationEnvironment.registerExtensionPointAndExtensions(pluginRoot, configFilePath, Extensions.getRootArea());
        }

        private final void registerApplicationServicesForCLI(JavaCoreApplicationEnvironment applicationEnvironment) {
            applicationEnvironment.registerFileType(PlainTextFileType.INSTANCE, "xml");
            applicationEnvironment.registerParserDefinition(new JavaParserDefinition());
        }

        @JvmStatic
        public final void registerApplicationServices(@NotNull JavaCoreApplicationEnvironment applicationEnvironment) {
            Intrinsics.checkParameterIsNotNull(applicationEnvironment, "applicationEnvironment");
            JavaCoreApplicationEnvironment $receiver = applicationEnvironment;
            $receiver.registerFileType(KotlinFileType.INSTANCE, "kt");
            $receiver.registerFileType(KotlinFileType.INSTANCE, KotlinParserDefinition.STD_SCRIPT_SUFFIX);
            $receiver.registerParserDefinition(new KotlinParserDefinition());
            $receiver.getApplication().registerService(KotlinBinaryClassCache.class, new KotlinBinaryClassCache());
            $receiver.getApplication().registerService(JavaClassSupers.class, JavaClassSupersImpl.class);
        }

        private final void registerProjectExtensionPoints(ExtensionsArea area) {
            CoreApplicationEnvironment.registerExtensionPoint(area, PsiTreeChangePreprocessor.EP_NAME, PsiTreeChangePreprocessor.class);
            CoreApplicationEnvironment.registerExtensionPoint(area, PsiElementFinder.EP_NAME, PsiElementFinder.class);
        }

        @JvmStatic
        public final void registerProjectServices(@NotNull JavaCoreProjectEnvironment projectEnvironment2) {
            Intrinsics.checkParameterIsNotNull(projectEnvironment2, "projectEnvironment");
            MockProject receiver$iv = projectEnvironment2.getProject();
            MockProject $receiver = receiver$iv;
            $receiver.registerService(KotlinScriptDefinitionProvider.class, new KotlinScriptDefinitionProvider());
            $receiver.registerService(KotlinJavaPsiFacade.class, new KotlinJavaPsiFacade($receiver));
            Project project = $receiver;
            Intrinsics.checkExpressionValueIsNotNull(project, "this");
            $receiver.registerService(KtLightClassForFacade.FacadeStubCache.class, new KtLightClassForFacade.FacadeStubCache(project));
        }

        private final void registerProjectServicesForCLI(JavaCoreProjectEnvironment projectEnvironment2) {
            MockProject receiver$iv = projectEnvironment2.getProject();
            MockProject $receiver = receiver$iv;
            JavaFileManager javaFileManager = ServiceManager.getService($receiver, JavaFileManager.class);
            if (javaFileManager == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.core.CoreJavaFileManager");
            }
            $receiver.registerService(CoreJavaFileManager.class, (CoreJavaFileManager)javaFileManager);
            Project project = $receiver;
            Intrinsics.checkExpressionValueIsNotNull(project, "this");
            CliLightClassGenerationSupport cliLightClassGenerationSupport = new CliLightClassGenerationSupport(project);
            $receiver.registerService(LightClassGenerationSupport.class, cliLightClassGenerationSupport);
            $receiver.registerService(CliLightClassGenerationSupport.class, cliLightClassGenerationSupport);
            $receiver.registerService(CodeAnalyzerInitializer.class, cliLightClassGenerationSupport);
            ExtensionsArea area = Extensions.getArea($receiver);
            area.getExtensionPoint(PsiElementFinder.EP_NAME).registerExtension(new JavaElementFinder($receiver, cliLightClassGenerationSupport));
            area.getExtensionPoint(PsiElementFinder.EP_NAME).registerExtension(new PsiElementFinderImpl($receiver, ServiceManager.getService($receiver, JavaFileManager.class)));
        }

        private Companion() {
        }

        public static final /* synthetic */ void access$registerProjectExtensionPoints(Companion $this, @NotNull ExtensionsArea area) {
            $this.registerProjectExtensionPoints(area);
        }

        @NotNull
        public static final /* synthetic */ Object access$getAPPLICATION_LOCK$p(Companion $this) {
            return $this.getAPPLICATION_LOCK();
        }

        public static final /* synthetic */ int access$getOurProjectCount$p(Companion $this) {
            return $this.getOurProjectCount();
        }

        public static final /* synthetic */ void access$setOurProjectCount$p(Companion $this, int n) {
            $this.setOurProjectCount(n);
        }

        @Nullable
        public static final /* synthetic */ JavaCoreApplicationEnvironment access$getOurApplicationEnvironment$p(Companion $this) {
            return $this.getOurApplicationEnvironment();
        }

        public static final /* synthetic */ void access$setOurApplicationEnvironment$p(Companion $this, @Nullable JavaCoreApplicationEnvironment javaCoreApplicationEnvironment) {
            $this.setOurApplicationEnvironment(javaCoreApplicationEnvironment);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

