/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.declaration;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsPropertyInitializer;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.declaration.ClassTranslator;
import org.jetbrains.kotlin.js.translate.declaration.propertyTranslator.PropertyTranslatorKt;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.general.TranslatorVisitor;
import org.jetbrains.kotlin.js.translate.initializer.ClassInitializerTranslator;
import org.jetbrains.kotlin.js.translate.initializer.InitializerUtils;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.types.KotlinType;

public class DeclarationBodyVisitor
extends TranslatorVisitor<Void> {
    protected final List<JsPropertyInitializer> result;
    protected final List<JsPropertyInitializer> staticResult;
    protected final List<JsPropertyInitializer> enumEntryList;

    public DeclarationBodyVisitor(@NotNull List<JsPropertyInitializer> result2, @NotNull List<JsPropertyInitializer> staticResult) {
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/kotlin/js/translate/declaration/DeclarationBodyVisitor", "<init>"));
        }
        if (staticResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "staticResult", "org/jetbrains/kotlin/js/translate/declaration/DeclarationBodyVisitor", "<init>"));
        }
        this.enumEntryList = new SmartList<JsPropertyInitializer>();
        this.result = result2;
        this.staticResult = staticResult;
    }

    @NotNull
    public List<JsPropertyInitializer> getResult() {
        List<JsPropertyInitializer> list2 = this.result;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/declaration/DeclarationBodyVisitor", "getResult"));
        }
        return list2;
    }

    public List<JsPropertyInitializer> getEnumEntryList() {
        return this.enumEntryList;
    }

    @Override
    protected Void emptyResult(@NotNull TranslationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/declaration/DeclarationBodyVisitor", "emptyResult"));
        }
        return null;
    }

    @Override
    public Void visitClass(@NotNull KtClass expression, TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/declaration/DeclarationBodyVisitor", "visitClass"));
        }
        return null;
    }

    @Override
    public Void visitEnumEntry(@NotNull KtEnumEntry enumEntry, TranslationContext data) {
        JsExpression jsEnumEntryCreation;
        if (enumEntry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumEntry", "org/jetbrains/kotlin/js/translate/declaration/DeclarationBodyVisitor", "visitEnumEntry"));
        }
        ClassDescriptor descriptor2 = BindingUtils.getClassDescriptor(data.bindingContext(), enumEntry);
        List<KotlinType> supertypes2 = JsDescriptorUtils.getSupertypesWithoutFakes(descriptor2);
        if (enumEntry.getBody() != null || supertypes2.size() > 1) {
            jsEnumEntryCreation = ClassTranslator.generateClassCreation(enumEntry, data);
        } else {
            assert (supertypes2.size() == 1) : "Simple Enum entry must have one supertype";
            jsEnumEntryCreation = new ClassInitializerTranslator(enumEntry, data).generateEnumEntryInstanceCreation(supertypes2.get(0));
        }
        this.enumEntryList.add(new JsPropertyInitializer(data.getNameForDescriptor(descriptor2).makeRef(), jsEnumEntryCreation));
        return null;
    }

    @Override
    public Void visitObjectDeclaration(@NotNull KtObjectDeclaration declaration, TranslationContext context) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/js/translate/declaration/DeclarationBodyVisitor", "visitObjectDeclaration"));
        }
        if (!declaration.isCompanion()) {
            return null;
        }
        JsInvocation value = ClassTranslator.generateClassCreation(declaration, context);
        ClassDescriptor descriptor2 = BindingUtils.getClassDescriptor(context.bindingContext(), declaration);
        JsFunction fun = TranslationUtils.simpleReturnFunction(context.getScopeForDescriptor(descriptor2), value);
        this.staticResult.add(InitializerUtils.createCompanionObjectInitializer(fun, context));
        return null;
    }

    @Override
    public Void visitNamedFunction(@NotNull KtNamedFunction expression, TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/declaration/DeclarationBodyVisitor", "visitNamedFunction"));
        }
        FunctionDescriptor descriptor2 = BindingUtils.getFunctionDescriptor(context.bindingContext(), expression);
        if (descriptor2.getModality() == Modality.ABSTRACT) {
            return null;
        }
        JsPropertyInitializer methodAsPropertyInitializer = Translation.functionTranslator(expression, context).translateAsMethod();
        this.result.add(methodAsPropertyInitializer);
        return null;
    }

    @Override
    public Void visitProperty(@NotNull KtProperty expression, TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/declaration/DeclarationBodyVisitor", "visitProperty"));
        }
        PropertyDescriptor propertyDescriptor = BindingUtils.getPropertyDescriptor(context.bindingContext(), expression);
        PropertyTranslatorKt.translateAccessors(propertyDescriptor, expression, this.result, context);
        return null;
    }

    @Override
    public Void visitAnonymousInitializer(@NotNull KtAnonymousInitializer expression, TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/declaration/DeclarationBodyVisitor", "visitAnonymousInitializer"));
        }
        return null;
    }

    @Override
    public Void visitSecondaryConstructor(@NotNull KtSecondaryConstructor constructor, TranslationContext data) {
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "org/jetbrains/kotlin/js/translate/declaration/DeclarationBodyVisitor", "visitSecondaryConstructor"));
        }
        return null;
    }
}

