/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.declaration;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsPropertyInitializer;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.declaration.ClassTranslator;
import org.jetbrains.kotlin.js.translate.declaration.DeclarationBodyVisitor;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.initializer.InitializerUtils;
import org.jetbrains.kotlin.js.translate.initializer.InitializerVisitor;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0014\u001a\u0004\u0018\u00010\u000bJ\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0016J\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u001a2\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0016J\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0016J\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u001f2\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\r\u001a\u00070\u0003\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R:\u0010\u000e\u001a.\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00100\u0010 \u0011*\u0015\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00100\u00100\u0005\u00a2\u0006\u0002\b\f0\u000f\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/js/translate/declaration/FileDeclarationVisitor;", "Lorg/jetbrains/kotlin/js/translate/declaration/DeclarationBodyVisitor;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "initializers", "", "Lcom/google/dart/compiler/backend/js/ast/JsPropertyInitializer;", "(Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;Ljava/util/List;)V", "getContext", "()Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "initializer", "Lcom/google/dart/compiler/backend/js/ast/JsFunction;", "Lorg/jetbrains/annotations/NotNull;", "initializerContext", "initializerStatements", "", "Lcom/google/dart/compiler/backend/js/ast/JsStatement;", "kotlin.jvm.PlatformType", "initializerVisitor", "Lorg/jetbrains/kotlin/js/translate/initializer/InitializerVisitor;", "computeInitializer", "visitAnonymousInitializer", "Ljava/lang/Void;", "expression", "Lorg/jetbrains/kotlin/psi/KtAnonymousInitializer;", "visitClass", "Lorg/jetbrains/kotlin/psi/KtClass;", "visitObjectDeclaration", "declaration", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "visitProperty", "Lorg/jetbrains/kotlin/psi/KtProperty;", "kotlin-compiler"})
public final class FileDeclarationVisitor
extends DeclarationBodyVisitor {
    private final JsFunction initializer;
    private final TranslationContext initializerContext;
    private final List<JsStatement> initializerStatements;
    private final InitializerVisitor initializerVisitor;
    @NotNull
    private final TranslationContext context;

    @Nullable
    public final JsFunction computeInitializer() {
        if (this.initializerStatements.isEmpty()) {
            return null;
        }
        return this.initializer;
    }

    @Override
    @Nullable
    public Void visitClass(@NotNull KtClass expression, @Nullable TranslationContext context) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        TranslationContext translationContext = context;
        if (translationContext == null) {
            Intrinsics.throwNpe();
        }
        this.result.addAll((Collection)ClassTranslator.Companion.translate(expression, translationContext));
        return null;
    }

    @Override
    @Nullable
    public Void visitObjectDeclaration(@NotNull KtObjectDeclaration declaration, @Nullable TranslationContext context) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        TranslationContext translationContext = context;
        if (translationContext == null) {
            Intrinsics.throwNpe();
        }
        InitializerUtils.generateObjectInitializer(declaration, this.initializerStatements, translationContext);
        return null;
    }

    @Override
    @Nullable
    public Void visitProperty(@NotNull KtProperty expression, @Nullable TranslationContext context) {
        JsStatement delegate2;
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        if (context == null) {
            Intrinsics.throwNpe();
        }
        super.visitProperty(expression, context);
        KtExpression initializer2 = expression.getInitializer();
        if (initializer2 != null) {
            JsExpression value = Translation.translateAsExpression(initializer2, this.initializerContext);
            PropertyDescriptor propertyDescriptor = BindingUtils.getPropertyDescriptor(context.bindingContext(), expression);
            Intrinsics.checkExpressionValueIsNotNull(propertyDescriptor, "getPropertyDescriptor(co\u2026ingContext(), expression)");
            PropertyDescriptor propertyDescriptor2 = propertyDescriptor;
            this.initializerStatements.add(InitializerUtils.generateInitializerForProperty(context, propertyDescriptor2, value));
        }
        if ((delegate2 = InitializerUtils.generateInitializerForDelegate(context, expression)) != null) {
            this.initializerStatements.add(delegate2);
        }
        return null;
    }

    @Override
    @Nullable
    public Void visitAnonymousInitializer(@NotNull KtAnonymousInitializer expression, @Nullable TranslationContext context) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        expression.accept(this.initializerVisitor, this.initializerContext);
        return null;
    }

    @NotNull
    public final TranslationContext getContext() {
        return this.context;
    }

    public FileDeclarationVisitor(@NotNull TranslationContext context, @NotNull List<? extends JsPropertyInitializer> initializers) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(initializers, "initializers");
        super(initializers, new SmartList());
        this.context = context;
        this.initializer = JsAstUtils.createFunctionWithEmptyBody(this.context.scope());
        this.initializerContext = this.context.contextWithScope(this.initializer);
        this.initializerStatements = this.initializer.getBody().getStatements();
        this.initializerVisitor = new InitializerVisitor(this.initializerStatements);
    }

    public /* synthetic */ FileDeclarationVisitor(TranslationContext translationContext, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list2 = new SmartList();
        }
        this(translationContext, list2);
    }
}

