/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstructor;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.AbstractKotlinType;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.Flexibility;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeImpl;
import org.jetbrains.kotlin.types.LazyType;
import org.jetbrains.kotlin.types.NullAwareness;
import org.jetbrains.kotlin.types.StarProjectionImpl;
import org.jetbrains.kotlin.types.TypeCapabilities;
import org.jetbrains.kotlin.types.TypeCapability;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitution;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.utils.CollectionsKt;

public class TypeUtils {
    public static final KotlinType DONT_CARE = ErrorUtils.createErrorTypeWithCustomDebugName("DONT_CARE");
    public static final KotlinType CANT_INFER_FUNCTION_PARAM_TYPE = ErrorUtils.createErrorType("Cannot be inferred");
    @NotNull
    public static final KotlinType NO_EXPECTED_TYPE = new SpecialType("NO_EXPECTED_TYPE");
    public static final KotlinType UNIT_EXPECTED_TYPE = new SpecialType("UNIT_EXPECTED_TYPE");

    public static boolean noExpectedType(@NotNull KotlinType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/types/TypeUtils", "noExpectedType"));
        }
        return type2 == NO_EXPECTED_TYPE || type2 == UNIT_EXPECTED_TYPE;
    }

    public static boolean isDontCarePlaceholder(@Nullable KotlinType type2) {
        return type2 != null && type2.getConstructor() == DONT_CARE.getConstructor();
    }

    @NotNull
    public static KotlinType makeNullable(@NotNull KotlinType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/types/TypeUtils", "makeNullable"));
        }
        KotlinType kotlinType = TypeUtils.makeNullableAsSpecified(type2, true);
        if (kotlinType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/TypeUtils", "makeNullable"));
        }
        return kotlinType;
    }

    @NotNull
    public static KotlinType makeNotNullable(@NotNull KotlinType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/types/TypeUtils", "makeNotNullable"));
        }
        KotlinType kotlinType = TypeUtils.makeNullableAsSpecified(type2, false);
        if (kotlinType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/TypeUtils", "makeNotNullable"));
        }
        return kotlinType;
    }

    @NotNull
    public static KotlinType makeNullableAsSpecified(@NotNull KotlinType type2, boolean nullable2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/types/TypeUtils", "makeNullableAsSpecified"));
        }
        NullAwareness nullAwareness = type2.getCapability(NullAwareness.class);
        if (nullAwareness != null) {
            KotlinType kotlinType = nullAwareness.makeNullableAsSpecified(nullable2);
            if (kotlinType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/TypeUtils", "makeNullableAsSpecified"));
            }
            return kotlinType;
        }
        if (type2 instanceof AbstractTypeWithKnownNullability) {
            KotlinType kotlinType = TypeUtils.makeNullableAsSpecified(((AbstractTypeWithKnownNullability)type2).delegate, nullable2);
            if (kotlinType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/TypeUtils", "makeNullableAsSpecified"));
            }
            return kotlinType;
        }
        if (!(type2 instanceof LazyType) && type2.isMarkedNullable() == nullable2) {
            KotlinType kotlinType = type2;
            if (kotlinType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/TypeUtils", "makeNullableAsSpecified"));
            }
            return kotlinType;
        }
        AbstractTypeWithKnownNullability abstractTypeWithKnownNullability = nullable2 ? new NullableType(type2) : new NotNullType(type2);
        if (abstractTypeWithKnownNullability == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/TypeUtils", "makeNullableAsSpecified"));
        }
        return abstractTypeWithKnownNullability;
    }

    @NotNull
    public static KotlinType makeNullableIfNeeded(@NotNull KotlinType type2, boolean nullable2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/types/TypeUtils", "makeNullableIfNeeded"));
        }
        if (nullable2) {
            KotlinType kotlinType = TypeUtils.makeNullable(type2);
            if (kotlinType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/TypeUtils", "makeNullableIfNeeded"));
            }
            return kotlinType;
        }
        KotlinType kotlinType = type2;
        if (kotlinType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/TypeUtils", "makeNullableIfNeeded"));
        }
        return kotlinType;
    }

    public static boolean canHaveSubtypes(KotlinTypeChecker typeChecker, @NotNull KotlinType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/types/TypeUtils", "canHaveSubtypes"));
        }
        if (type2.isMarkedNullable()) {
            return true;
        }
        if (!type2.getConstructor().isFinal()) {
            return true;
        }
        List<TypeParameterDescriptor> parameters2 = type2.getConstructor().getParameters();
        List<TypeProjection> arguments2 = type2.getArguments();
        int parametersSize = parameters2.size();
        block10: for (int i = 0; i < parametersSize; ++i) {
            TypeParameterDescriptor parameterDescriptor = parameters2.get(i);
            TypeProjection typeProjection = arguments2.get(i);
            if (typeProjection.isStarProjection()) {
                return true;
            }
            Variance projectionKind = typeProjection.getProjectionKind();
            KotlinType argument = typeProjection.getType();
            switch (parameterDescriptor.getVariance()) {
                case INVARIANT: {
                    switch (projectionKind) {
                        case INVARIANT: {
                            if (!TypeUtils.lowerThanBound(typeChecker, argument, parameterDescriptor) && !TypeUtils.canHaveSubtypes(typeChecker, argument)) break;
                            return true;
                        }
                        case IN_VARIANCE: {
                            if (!TypeUtils.lowerThanBound(typeChecker, argument, parameterDescriptor)) break;
                            return true;
                        }
                        case OUT_VARIANCE: {
                            if (!TypeUtils.canHaveSubtypes(typeChecker, argument)) break;
                            return true;
                        }
                    }
                    continue block10;
                }
                case IN_VARIANCE: {
                    if (!(projectionKind != Variance.OUT_VARIANCE ? TypeUtils.lowerThanBound(typeChecker, argument, parameterDescriptor) : TypeUtils.canHaveSubtypes(typeChecker, argument))) continue block10;
                    return true;
                }
                case OUT_VARIANCE: {
                    if (!(projectionKind != Variance.IN_VARIANCE ? TypeUtils.canHaveSubtypes(typeChecker, argument) : TypeUtils.lowerThanBound(typeChecker, argument, parameterDescriptor))) continue block10;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean lowerThanBound(KotlinTypeChecker typeChecker, KotlinType argument, TypeParameterDescriptor parameterDescriptor) {
        for (KotlinType bound : parameterDescriptor.getUpperBounds()) {
            if (!typeChecker.isSubtypeOf(argument, bound) || argument.getConstructor().equals(bound.getConstructor())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static KotlinType makeUnsubstitutedType(ClassDescriptor classDescriptor, MemberScope unsubstitutedMemberScope) {
        if (ErrorUtils.isError(classDescriptor)) {
            KotlinType kotlinType = ErrorUtils.createErrorType("Unsubstituted type for " + classDescriptor);
            if (kotlinType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/TypeUtils", "makeUnsubstitutedType"));
            }
            return kotlinType;
        }
        TypeConstructor typeConstructor2 = classDescriptor.getTypeConstructor();
        List<TypeProjection> arguments2 = TypeUtils.getDefaultTypeProjections(typeConstructor2.getParameters());
        KotlinTypeImpl kotlinTypeImpl = KotlinTypeImpl.create(Annotations.Companion.getEMPTY(), typeConstructor2, false, arguments2, unsubstitutedMemberScope);
        if (kotlinTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/TypeUtils", "makeUnsubstitutedType"));
        }
        return kotlinTypeImpl;
    }

    @NotNull
    public static List<TypeProjection> getDefaultTypeProjections(@NotNull List<TypeParameterDescriptor> parameters2) {
        if (parameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/kotlin/types/TypeUtils", "getDefaultTypeProjections"));
        }
        ArrayList<TypeProjectionImpl> result2 = new ArrayList<TypeProjectionImpl>(parameters2.size());
        for (TypeParameterDescriptor parameterDescriptor : parameters2) {
            result2.add(new TypeProjectionImpl(parameterDescriptor.getDefaultType()));
        }
        List<TypeProjection> list2 = CollectionsKt.toReadOnlyList(result2);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/TypeUtils", "getDefaultTypeProjections"));
        }
        return list2;
    }

    @NotNull
    public static List<KotlinType> getImmediateSupertypes(@NotNull KotlinType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/types/TypeUtils", "getImmediateSupertypes"));
        }
        TypeSubstitutor substitutor2 = TypeSubstitutor.create(type2);
        Collection<KotlinType> originalSupertypes = type2.getConstructor().getSupertypes();
        ArrayList<KotlinType> result2 = new ArrayList<KotlinType>(originalSupertypes.size());
        for (KotlinType supertype : originalSupertypes) {
            KotlinType substitutedType = TypeUtils.createSubstitutedSupertype(type2, supertype, substitutor2);
            if (substitutedType == null) continue;
            result2.add(substitutedType);
        }
        ArrayList<KotlinType> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/TypeUtils", "getImmediateSupertypes"));
        }
        return arrayList;
    }

    @Nullable
    public static KotlinType createSubstitutedSupertype(@NotNull KotlinType subType, @NotNull KotlinType superType, @NotNull TypeSubstitutor substitutor2) {
        if (subType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subType", "org/jetbrains/kotlin/types/TypeUtils", "createSubstitutedSupertype"));
        }
        if (superType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superType", "org/jetbrains/kotlin/types/TypeUtils", "createSubstitutedSupertype"));
        }
        if (substitutor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/kotlin/types/TypeUtils", "createSubstitutedSupertype"));
        }
        KotlinType substitutedType = substitutor2.substitute(superType, Variance.INVARIANT);
        if (substitutedType != null) {
            return TypeUtils.makeNullableIfNeeded(substitutedType, subType.isMarkedNullable());
        }
        return null;
    }

    private static void collectAllSupertypes(@NotNull KotlinType type2, @NotNull Set<KotlinType> result2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/types/TypeUtils", "collectAllSupertypes"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/kotlin/types/TypeUtils", "collectAllSupertypes"));
        }
        List<KotlinType> immediateSupertypes = TypeUtils.getImmediateSupertypes(type2);
        result2.addAll(immediateSupertypes);
        for (KotlinType supertype : immediateSupertypes) {
            TypeUtils.collectAllSupertypes(supertype, result2);
        }
    }

    @NotNull
    public static Set<KotlinType> getAllSupertypes(@NotNull KotlinType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/types/TypeUtils", "getAllSupertypes"));
        }
        LinkedHashSet<KotlinType> result2 = new LinkedHashSet<KotlinType>(15);
        TypeUtils.collectAllSupertypes(type2, result2);
        LinkedHashSet<KotlinType> linkedHashSet = result2;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/TypeUtils", "getAllSupertypes"));
        }
        return linkedHashSet;
    }

    public static boolean isNullableType(@NotNull KotlinType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/types/TypeUtils", "isNullableType"));
        }
        if (type2.isMarkedNullable()) {
            return true;
        }
        if (FlexibleTypesKt.isFlexible(type2) && TypeUtils.isNullableType(FlexibleTypesKt.flexibility(type2).getUpperBound())) {
            return true;
        }
        if (TypeUtils.isTypeParameter(type2)) {
            return TypeUtils.hasNullableSuperType(type2);
        }
        return false;
    }

    public static boolean acceptsNullable(@NotNull KotlinType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/types/TypeUtils", "acceptsNullable"));
        }
        if (type2.isMarkedNullable()) {
            return true;
        }
        return FlexibleTypesKt.isFlexible(type2) && TypeUtils.acceptsNullable(FlexibleTypesKt.flexibility(type2).getUpperBound());
    }

    public static boolean hasNullableSuperType(@NotNull KotlinType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/types/TypeUtils", "hasNullableSuperType"));
        }
        if (type2.getConstructor().getDeclarationDescriptor() instanceof ClassDescriptor) {
            return false;
        }
        for (KotlinType supertype : TypeUtils.getImmediateSupertypes(type2)) {
            if (supertype.isMarkedNullable()) {
                return true;
            }
            if (!TypeUtils.hasNullableSuperType(supertype)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static ClassDescriptor getClassDescriptor(@NotNull KotlinType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/types/TypeUtils", "getClassDescriptor"));
        }
        ClassifierDescriptor declarationDescriptor = type2.getConstructor().getDeclarationDescriptor();
        if (declarationDescriptor instanceof ClassDescriptor) {
            return (ClassDescriptor)declarationDescriptor;
        }
        return null;
    }

    @NotNull
    public static KotlinType substituteParameters(@NotNull ClassDescriptor clazz, @NotNull List<KotlinType> typeArguments) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "org/jetbrains/kotlin/types/TypeUtils", "substituteParameters"));
        }
        if (typeArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeArguments", "org/jetbrains/kotlin/types/TypeUtils", "substituteParameters"));
        }
        List<TypeProjection> projections = kotlin.collections.CollectionsKt.map(typeArguments, new Function1<KotlinType, TypeProjection>(){

            @Override
            public TypeProjection invoke(KotlinType type2) {
                return new TypeProjectionImpl(type2);
            }
        });
        KotlinType kotlinType = TypeUtils.substituteProjectionsForParameters(clazz, projections);
        if (kotlinType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/TypeUtils", "substituteParameters"));
        }
        return kotlinType;
    }

    @NotNull
    public static KotlinType substituteProjectionsForParameters(@NotNull ClassDescriptor clazz, @NotNull List<TypeProjection> projections) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "org/jetbrains/kotlin/types/TypeUtils", "substituteProjectionsForParameters"));
        }
        if (projections == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projections", "org/jetbrains/kotlin/types/TypeUtils", "substituteProjectionsForParameters"));
        }
        List<TypeParameterDescriptor> clazzTypeParameters = clazz.getTypeConstructor().getParameters();
        if (clazzTypeParameters.size() != projections.size()) {
            throw new IllegalArgumentException("type parameter counts do not match: " + clazz + ", " + projections);
        }
        HashMap<TypeConstructor, TypeProjection> substitutions = CollectionsKt.newHashMapWithExpectedSize(clazzTypeParameters.size());
        for (int i = 0; i < clazzTypeParameters.size(); ++i) {
            TypeConstructor typeConstructor2 = clazzTypeParameters.get(i).getTypeConstructor();
            substitutions.put(typeConstructor2, projections.get(i));
        }
        KotlinType kotlinType = TypeSubstitutor.create(substitutions).substitute(clazz.getDefaultType(), Variance.INVARIANT);
        if (kotlinType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/TypeUtils", "substituteProjectionsForParameters"));
        }
        return kotlinType;
    }

    public static boolean equalTypes(@NotNull KotlinType a, @NotNull KotlinType b) {
        if (a == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "org/jetbrains/kotlin/types/TypeUtils", "equalTypes"));
        }
        if (b == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "org/jetbrains/kotlin/types/TypeUtils", "equalTypes"));
        }
        return KotlinTypeChecker.DEFAULT.isSubtypeOf(a, b) && KotlinTypeChecker.DEFAULT.isSubtypeOf(b, a);
    }

    public static boolean dependsOnTypeParameters(@NotNull KotlinType type2, @NotNull Collection<TypeParameterDescriptor> typeParameters) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/types/TypeUtils", "dependsOnTypeParameters"));
        }
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "org/jetbrains/kotlin/types/TypeUtils", "dependsOnTypeParameters"));
        }
        return TypeUtils.dependsOnTypeConstructors(type2, kotlin.collections.CollectionsKt.map(typeParameters, new Function1<TypeParameterDescriptor, TypeConstructor>(){

            @Override
            public TypeConstructor invoke(@NotNull TypeParameterDescriptor typeParameterDescriptor) {
                if (typeParameterDescriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameterDescriptor", "org/jetbrains/kotlin/types/TypeUtils$2", "invoke"));
                }
                return typeParameterDescriptor.getTypeConstructor();
            }
        }));
    }

    public static boolean dependsOnTypeConstructors(@NotNull KotlinType type2, @NotNull Collection<TypeConstructor> typeParameterConstructors) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/types/TypeUtils", "dependsOnTypeConstructors"));
        }
        if (typeParameterConstructors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameterConstructors", "org/jetbrains/kotlin/types/TypeUtils", "dependsOnTypeConstructors"));
        }
        if (typeParameterConstructors.contains(type2.getConstructor())) {
            return true;
        }
        for (TypeProjection typeProjection : type2.getArguments()) {
            if (typeProjection.isStarProjection() || !TypeUtils.dependsOnTypeConstructors(typeProjection.getType(), typeParameterConstructors)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(@Nullable KotlinType type2, final @NotNull KotlinType specialType) {
        if (specialType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specialType", "org/jetbrains/kotlin/types/TypeUtils", "contains"));
        }
        return TypeUtils.contains(type2, new Function1<KotlinType, Boolean>(){

            @Override
            public Boolean invoke(KotlinType type2) {
                return ((Object)specialType).equals(type2);
            }
        });
    }

    public static boolean contains(@Nullable KotlinType type2, @NotNull Function1<KotlinType, Boolean> isSpecialType) {
        if (isSpecialType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isSpecialType", "org/jetbrains/kotlin/types/TypeUtils", "contains"));
        }
        if (type2 == null) {
            return false;
        }
        if (isSpecialType.invoke(type2).booleanValue()) {
            return true;
        }
        Flexibility flexibility = type2.getCapability(Flexibility.class);
        if (flexibility != null && (TypeUtils.contains(flexibility.getLowerBound(), isSpecialType) || TypeUtils.contains(flexibility.getUpperBound(), isSpecialType))) {
            return true;
        }
        for (TypeProjection projection : type2.getArguments()) {
            if (projection.isStarProjection() || !TypeUtils.contains(projection.getType(), isSpecialType)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static TypeProjection makeStarProjection(@NotNull TypeParameterDescriptor parameterDescriptor) {
        if (parameterDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterDescriptor", "org/jetbrains/kotlin/types/TypeUtils", "makeStarProjection"));
        }
        StarProjectionImpl starProjectionImpl = new StarProjectionImpl(parameterDescriptor);
        if (starProjectionImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/TypeUtils", "makeStarProjection"));
        }
        return starProjectionImpl;
    }

    @NotNull
    public static KotlinType getDefaultPrimitiveNumberType(@NotNull IntegerValueTypeConstructor numberValueTypeConstructor) {
        if (numberValueTypeConstructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "numberValueTypeConstructor", "org/jetbrains/kotlin/types/TypeUtils", "getDefaultPrimitiveNumberType"));
        }
        KotlinType type2 = TypeUtils.getDefaultPrimitiveNumberType(numberValueTypeConstructor.getSupertypes());
        assert (type2 != null) : "Strange number value type constructor: " + numberValueTypeConstructor + ". " + "Super types doesn't contain double, int or long: " + numberValueTypeConstructor.getSupertypes();
        KotlinType kotlinType = type2;
        if (kotlinType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/TypeUtils", "getDefaultPrimitiveNumberType"));
        }
        return kotlinType;
    }

    @Nullable
    public static KotlinType getDefaultPrimitiveNumberType(@NotNull Collection<KotlinType> supertypes2) {
        if (supertypes2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supertypes", "org/jetbrains/kotlin/types/TypeUtils", "getDefaultPrimitiveNumberType"));
        }
        if (supertypes2.isEmpty()) {
            return null;
        }
        KotlinBuiltIns builtIns = supertypes2.iterator().next().getConstructor().getBuiltIns();
        KotlinType doubleType = builtIns.getDoubleType();
        if (supertypes2.contains(doubleType)) {
            return doubleType;
        }
        KotlinType intType = builtIns.getIntType();
        if (supertypes2.contains(intType)) {
            return intType;
        }
        KotlinType longType = builtIns.getLongType();
        if (supertypes2.contains(longType)) {
            return longType;
        }
        return null;
    }

    @NotNull
    public static KotlinType getPrimitiveNumberType(@NotNull IntegerValueTypeConstructor numberValueTypeConstructor, @NotNull KotlinType expectedType) {
        if (numberValueTypeConstructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "numberValueTypeConstructor", "org/jetbrains/kotlin/types/TypeUtils", "getPrimitiveNumberType"));
        }
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/kotlin/types/TypeUtils", "getPrimitiveNumberType"));
        }
        if (TypeUtils.noExpectedType(expectedType) || expectedType.isError()) {
            KotlinType kotlinType = TypeUtils.getDefaultPrimitiveNumberType(numberValueTypeConstructor);
            if (kotlinType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/TypeUtils", "getPrimitiveNumberType"));
            }
            return kotlinType;
        }
        for (KotlinType primitiveNumberType : numberValueTypeConstructor.getSupertypes()) {
            if (!KotlinTypeChecker.DEFAULT.isSubtypeOf(primitiveNumberType, expectedType)) continue;
            KotlinType kotlinType = primitiveNumberType;
            if (kotlinType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/TypeUtils", "getPrimitiveNumberType"));
            }
            return kotlinType;
        }
        KotlinType kotlinType = TypeUtils.getDefaultPrimitiveNumberType(numberValueTypeConstructor);
        if (kotlinType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/TypeUtils", "getPrimitiveNumberType"));
        }
        return kotlinType;
    }

    public static boolean isTypeParameter(@NotNull KotlinType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/types/TypeUtils", "isTypeParameter"));
        }
        return TypeUtils.getTypeParameterDescriptorOrNull(type2) != null;
    }

    public static boolean isNonReifiedTypeParemeter(@NotNull KotlinType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/types/TypeUtils", "isNonReifiedTypeParemeter"));
        }
        TypeParameterDescriptor typeParameterDescriptor = TypeUtils.getTypeParameterDescriptorOrNull(type2);
        return typeParameterDescriptor != null && !typeParameterDescriptor.isReified();
    }

    public static boolean isReifiedTypeParameter(@NotNull KotlinType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/types/TypeUtils", "isReifiedTypeParameter"));
        }
        TypeParameterDescriptor typeParameterDescriptor = TypeUtils.getTypeParameterDescriptorOrNull(type2);
        return typeParameterDescriptor != null && typeParameterDescriptor.isReified();
    }

    @Nullable
    public static TypeParameterDescriptor getTypeParameterDescriptorOrNull(@NotNull KotlinType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/types/TypeUtils", "getTypeParameterDescriptorOrNull"));
        }
        if (type2.getConstructor().getDeclarationDescriptor() instanceof TypeParameterDescriptor) {
            return (TypeParameterDescriptor)type2.getConstructor().getDeclarationDescriptor();
        }
        return null;
    }

    private static class NotNullType
    extends AbstractTypeWithKnownNullability {
        private NotNullType(@NotNull KotlinType delegate2) {
            if (delegate2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "org/jetbrains/kotlin/types/TypeUtils$NotNullType", "<init>"));
            }
            super(delegate2);
        }

        @Override
        public boolean isMarkedNullable() {
            return false;
        }
    }

    private static class NullableType
    extends AbstractTypeWithKnownNullability {
        private NullableType(@NotNull KotlinType delegate2) {
            if (delegate2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "org/jetbrains/kotlin/types/TypeUtils$NullableType", "<init>"));
            }
            super(delegate2);
        }

        @Override
        public boolean isMarkedNullable() {
            return true;
        }
    }

    private static abstract class AbstractTypeWithKnownNullability
    extends AbstractKotlinType {
        private final KotlinType delegate;

        private AbstractTypeWithKnownNullability(@NotNull KotlinType delegate2) {
            if (delegate2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "org/jetbrains/kotlin/types/TypeUtils$AbstractTypeWithKnownNullability", "<init>"));
            }
            this.delegate = delegate2;
        }

        @Override
        @NotNull
        public TypeConstructor getConstructor() {
            TypeConstructor typeConstructor2 = this.delegate.getConstructor();
            if (typeConstructor2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/TypeUtils$AbstractTypeWithKnownNullability", "getConstructor"));
            }
            return typeConstructor2;
        }

        @Override
        @NotNull
        public List<TypeProjection> getArguments() {
            List<TypeProjection> list2 = this.delegate.getArguments();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/TypeUtils$AbstractTypeWithKnownNullability", "getArguments"));
            }
            return list2;
        }

        @Override
        public abstract boolean isMarkedNullable();

        @Override
        @NotNull
        public MemberScope getMemberScope() {
            MemberScope memberScope2 = this.delegate.getMemberScope();
            if (memberScope2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/TypeUtils$AbstractTypeWithKnownNullability", "getMemberScope"));
            }
            return memberScope2;
        }

        @Override
        public boolean isError() {
            return this.delegate.isError();
        }

        @Override
        @NotNull
        public Annotations getAnnotations() {
            Annotations annotations2 = this.delegate.getAnnotations();
            if (annotations2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/TypeUtils$AbstractTypeWithKnownNullability", "getAnnotations"));
            }
            return annotations2;
        }

        @Override
        @NotNull
        public TypeSubstitution getSubstitution() {
            TypeSubstitution typeSubstitution = this.delegate.getSubstitution();
            if (typeSubstitution == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/TypeUtils$AbstractTypeWithKnownNullability", "getSubstitution"));
            }
            return typeSubstitution;
        }

        @Override
        @Nullable
        public <T extends TypeCapability> T getCapability(@NotNull Class<T> capabilityClass) {
            if (capabilityClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "capabilityClass", "org/jetbrains/kotlin/types/TypeUtils$AbstractTypeWithKnownNullability", "getCapability"));
            }
            return this.delegate.getCapability(capabilityClass);
        }

        @Override
        @NotNull
        public TypeCapabilities getCapabilities() {
            TypeCapabilities typeCapabilities2 = this.delegate.getCapabilities();
            if (typeCapabilities2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/TypeUtils$AbstractTypeWithKnownNullability", "getCapabilities"));
            }
            return typeCapabilities2;
        }
    }

    public static class SpecialType
    implements KotlinType {
        private final String name;

        public SpecialType(String name) {
            this.name = name;
        }

        @Override
        @NotNull
        public TypeConstructor getConstructor() {
            throw new IllegalStateException(this.name);
        }

        @Override
        @NotNull
        public List<TypeProjection> getArguments() {
            throw new IllegalStateException(this.name);
        }

        @Override
        @NotNull
        public TypeSubstitution getSubstitution() {
            throw new IllegalStateException(this.name);
        }

        @Override
        public boolean isMarkedNullable() {
            throw new IllegalStateException(this.name);
        }

        @Override
        @NotNull
        public MemberScope getMemberScope() {
            throw new IllegalStateException(this.name);
        }

        @Override
        public boolean isError() {
            return false;
        }

        @Override
        @NotNull
        public Annotations getAnnotations() {
            throw new IllegalStateException(this.name);
        }

        @Override
        @Nullable
        public <T extends TypeCapability> T getCapability(@NotNull Class<T> capabilityClass) {
            if (capabilityClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "capabilityClass", "org/jetbrains/kotlin/types/TypeUtils$SpecialType", "getCapability"));
            }
            return null;
        }

        @Override
        @NotNull
        public TypeCapabilities getCapabilities() {
            TypeCapabilities.NONE nONE = TypeCapabilities.NONE.INSTANCE;
            if (nONE == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/TypeUtils$SpecialType", "getCapabilities"));
            }
            return nONE;
        }

        public String toString() {
            return this.name;
        }
    }
}

