/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.DefaultExternalFilter;
import org.jetbrains.plugins.gradle.model.ExternalFilter;
import org.jetbrains.plugins.gradle.model.ExternalSourceDirectorySet;

public class DefaultExternalSourceDirectorySet
implements ExternalSourceDirectorySet {
    private static final long serialVersionUID = 1L;
    @NotNull
    private String myName;
    @NotNull
    private Set<File> mySrcDirs = new HashSet<File>();
    @NotNull
    private File myOutputDir;
    @NotNull
    private Set<String> myExcludes = new HashSet<String>();
    @NotNull
    private Set<String> myIncludes = new HashSet<String>();
    @NotNull
    private List<ExternalFilter> myFilters = new ArrayList<ExternalFilter>();
    private boolean myInheritedCompilerOutput;

    public DefaultExternalSourceDirectorySet() {
    }

    public DefaultExternalSourceDirectorySet(ExternalSourceDirectorySet sourceDirectorySet) {
        this();
        this.myName = sourceDirectorySet.getName();
        this.mySrcDirs = new HashSet<File>(sourceDirectorySet.getSrcDirs());
        this.myOutputDir = sourceDirectorySet.getOutputDir();
        this.myExcludes = new HashSet<String>(sourceDirectorySet.getExcludes());
        this.myIncludes = new HashSet<String>(sourceDirectorySet.getIncludes());
        for (ExternalFilter filter : sourceDirectorySet.getFilters()) {
            this.myFilters.add(new DefaultExternalFilter(filter));
        }
        this.myInheritedCompilerOutput = sourceDirectorySet.isCompilerOutputPathInherited();
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/model/DefaultExternalSourceDirectorySet", "getName"));
        }
        return string;
    }

    public void setName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/gradle/model/DefaultExternalSourceDirectorySet", "setName"));
        }
        this.myName = name;
    }

    @NotNull
    public Set<File> getSrcDirs() {
        Set<File> set = this.mySrcDirs;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/model/DefaultExternalSourceDirectorySet", "getSrcDirs"));
        }
        return set;
    }

    public void setSrcDirs(@NotNull Set<File> srcDirs) {
        if (srcDirs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "srcDirs", "org/jetbrains/plugins/gradle/model/DefaultExternalSourceDirectorySet", "setSrcDirs"));
        }
        this.mySrcDirs = srcDirs;
    }

    @NotNull
    public File getOutputDir() {
        File file = this.myOutputDir;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/model/DefaultExternalSourceDirectorySet", "getOutputDir"));
        }
        return file;
    }

    public boolean isCompilerOutputPathInherited() {
        return this.myInheritedCompilerOutput;
    }

    public void setInheritedCompilerOutput(boolean inheritedCompilerOutput) {
        this.myInheritedCompilerOutput = inheritedCompilerOutput;
    }

    @NotNull
    public Set<String> getIncludes() {
        Set<String> set = this.myIncludes;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/model/DefaultExternalSourceDirectorySet", "getIncludes"));
        }
        return set;
    }

    public void setIncludes(@NotNull Set<String> includes) {
        if (includes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "includes", "org/jetbrains/plugins/gradle/model/DefaultExternalSourceDirectorySet", "setIncludes"));
        }
        this.myIncludes = includes;
    }

    @NotNull
    public Set<String> getExcludes() {
        Set<String> set = this.myExcludes;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/model/DefaultExternalSourceDirectorySet", "getExcludes"));
        }
        return set;
    }

    public void setExcludes(@NotNull Set<String> excludes) {
        if (excludes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "excludes", "org/jetbrains/plugins/gradle/model/DefaultExternalSourceDirectorySet", "setExcludes"));
        }
        this.myExcludes = excludes;
    }

    @NotNull
    public List<ExternalFilter> getFilters() {
        List<ExternalFilter> list = this.myFilters;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/model/DefaultExternalSourceDirectorySet", "getFilters"));
        }
        return list;
    }

    public void setFilters(@NotNull List<ExternalFilter> filters) {
        if (filters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filters", "org/jetbrains/plugins/gradle/model/DefaultExternalSourceDirectorySet", "setFilters"));
        }
        this.myFilters = filters;
    }

    public void setOutputDir(@NotNull File outputDir) {
        if (outputDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputDir", "org/jetbrains/plugins/gradle/model/DefaultExternalSourceDirectorySet", "setOutputDir"));
        }
        this.myOutputDir = outputDir;
    }
}

