/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.builder;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.plugins.scala.ScalaPlugin;
import org.gradle.api.tasks.scala.ScalaCompile;
import org.gradle.api.tasks.scala.ScalaCompileOptions;
import org.gradle.api.tasks.scala.ScalaForkOptions;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.scala.ScalaModel;
import org.jetbrains.plugins.gradle.tooling.ErrorMessageBuilder;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderService;
import org.jetbrains.plugins.gradle.tooling.internal.scala.ScalaCompileOptionsImpl;
import org.jetbrains.plugins.gradle.tooling.internal.scala.ScalaForkOptionsImpl;
import org.jetbrains.plugins.gradle.tooling.internal.scala.ScalaModelImpl;

public class ScalaModelBuilderImpl
implements ModelBuilderService {
    private static final String COMPILE_SCALA_TASK = "compileScala";

    public boolean canBuild(String modelName) {
        return ScalaModel.class.getName().equals(modelName);
    }

    public Object buildAll(String modelName, Project project) {
        ScalaPlugin scalaPlugin = (ScalaPlugin)project.getPlugins().findPlugin(ScalaPlugin.class);
        ScalaModel scalaModel = null;
        if (scalaPlugin != null) {
            Task scalaTask = project.getTasks().getByName(COMPILE_SCALA_TASK);
            scalaModel = ScalaModelBuilderImpl.createModel(scalaTask);
        } else {
            Iterator it = project.getTasks().withType(ScalaCompile.class).iterator();
            if (it.hasNext()) {
                scalaModel = ScalaModelBuilderImpl.createModel((Task)it.next());
            }
        }
        return scalaModel;
    }

    @Nullable
    private static ScalaModel createModel(@Nullable Task task) {
        if (!(task instanceof ScalaCompile)) {
            return null;
        }
        ScalaCompile scalaCompile = (ScalaCompile)task;
        ScalaModelImpl scalaModel = new ScalaModelImpl();
        scalaModel.setScalaClasspath(scalaCompile.getScalaClasspath().getFiles());
        scalaModel.setZincClasspath(scalaCompile.getZincClasspath().getFiles());
        scalaModel.setScalaCompileOptions(ScalaModelBuilderImpl.create(scalaCompile.getScalaCompileOptions()));
        scalaModel.setTargetCompatibility(scalaCompile.getTargetCompatibility());
        scalaModel.setSourceCompatibility(scalaCompile.getSourceCompatibility());
        return scalaModel;
    }

    @NotNull
    public ErrorMessageBuilder getErrorMessageBuilder(@NotNull Project project, @NotNull Exception e) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/tooling/builder/ScalaModelBuilderImpl", "getErrorMessageBuilder"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/gradle/tooling/builder/ScalaModelBuilderImpl", "getErrorMessageBuilder"));
        }
        ErrorMessageBuilder errorMessageBuilder = ErrorMessageBuilder.create((Project)project, (Exception)e, (String)"Scala import errors").withDescription("Unable to build Scala project configuration");
        if (errorMessageBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/tooling/builder/ScalaModelBuilderImpl", "getErrorMessageBuilder"));
        }
        return errorMessageBuilder;
    }

    @Nullable
    @Contract(value="null -> null")
    private static ScalaCompileOptionsImpl create(@Nullable ScalaCompileOptions options) {
        if (options == null) {
            return null;
        }
        ScalaCompileOptionsImpl result = new ScalaCompileOptionsImpl();
        result.setAdditionalParameters(ScalaModelBuilderImpl.wrapStringList(options.getAdditionalParameters()));
        result.setDaemonServer(options.getDaemonServer());
        result.setDebugLevel(options.getDebugLevel());
        result.setDeprecation(options.isDeprecation());
        result.setEncoding(options.getEncoding());
        result.setFailOnError(options.isFailOnError());
        result.setForce(options.getForce());
        result.setFork(options.isFork());
        result.setForkOptions(ScalaModelBuilderImpl.create(options.getForkOptions()));
        result.setListFiles(options.isListFiles());
        result.setLoggingLevel(options.getLoggingLevel());
        result.setDebugLevel(options.getDebugLevel());
        result.setLoggingPhases(ScalaModelBuilderImpl.wrapStringList(options.getLoggingPhases()));
        result.setOptimize(options.isOptimize());
        result.setUnchecked(options.isUnchecked());
        result.setUseAnt(options.isUseAnt());
        result.setUseCompileDaemon(options.isUseCompileDaemon());
        return result;
    }

    @Nullable
    private static List<String> wrapStringList(@Nullable List<String> list) {
        if (list == null) {
            return null;
        }
        ArrayList<String> strings = new ArrayList<String>();
        for (CharSequence charSequence : list) {
            strings.add(charSequence.toString());
        }
        return strings;
    }

    @Nullable
    @Contract(value="null -> null")
    private static ScalaForkOptionsImpl create(@Nullable ScalaForkOptions forkOptions) {
        if (forkOptions == null) {
            return null;
        }
        ScalaForkOptionsImpl result = new ScalaForkOptionsImpl();
        result.setJvmArgs(ScalaModelBuilderImpl.wrapStringList(forkOptions.getJvmArgs()));
        result.setMemoryInitialSize(forkOptions.getMemoryInitialSize());
        result.setMemoryMaximumSize(forkOptions.getMemoryMaximumSize());
        return result;
    }
}

