/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.context;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.tasks.context.WorkingContextProvider;
import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl;
import java.util.Collection;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class XDebuggerBreakpointsContextProvider
extends WorkingContextProvider {
    private final XBreakpointManagerImpl myBreakpointManager;

    public XDebuggerBreakpointsContextProvider(XDebuggerManager xDebuggerManager) {
        this.myBreakpointManager = (XBreakpointManagerImpl)xDebuggerManager.getBreakpointManager();
    }

    @NotNull
    public String getId() {
        if ("xDebugger" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/context/XDebuggerBreakpointsContextProvider", "getId"));
        }
        return "xDebugger";
    }

    @NotNull
    public String getDescription() {
        if ("XDebugger breakpoints" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/context/XDebuggerBreakpointsContextProvider", "getDescription"));
        }
        return "XDebugger breakpoints";
    }

    public void saveContext(Element toElement) throws WriteExternalException {
        XBreakpointManagerImpl.BreakpointManagerState state = this.myBreakpointManager.getState();
        Element serialize = XmlSerializer.serialize((Object)state, (SerializationFilter)new SerializationFilter(){

            public boolean accepts(@NotNull Accessor accessor, @NotNull Object bean) {
                if (accessor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessor", "com/intellij/tasks/context/XDebuggerBreakpointsContextProvider$1", "accepts"));
                }
                if (bean == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/intellij/tasks/context/XDebuggerBreakpointsContextProvider$1", "accepts"));
                }
                return accessor.read(bean) != null;
            }
        });
        toElement.addContent((Collection)serialize.removeContent());
    }

    public void loadContext(Element fromElement) throws InvalidDataException {
        XBreakpointManagerImpl.BreakpointManagerState state = (XBreakpointManagerImpl.BreakpointManagerState)XmlSerializer.deserialize((Element)fromElement, XBreakpointManagerImpl.BreakpointManagerState.class);
        this.myBreakpointManager.loadState(state);
    }

    public void clearContext() {
        XBreakpointBase[] breakpoints;
        for (final XBreakpointBase breakpoint : breakpoints = this.myBreakpointManager.getAllBreakpoints()) {
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    XDebuggerBreakpointsContextProvider.this.myBreakpointManager.removeBreakpoint((XBreakpoint)breakpoint);
                }
            });
        }
    }
}

