/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath;

import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.classpath.ClassPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultClassPath
implements ClassPath,
Serializable {
    private final List<File> files;

    DefaultClassPath() {
        this.files = Collections.emptyList();
    }

    public static ClassPath of(Collection<File> files) {
        if (files == null || files.isEmpty()) {
            return EMPTY;
        }
        return new DefaultClassPath(files);
    }

    public DefaultClassPath(Iterable<File> files) {
        LinkedHashSet<File> noDuplicates = new LinkedHashSet<File>();
        for (File file : files) {
            noDuplicates.add(file);
        }
        this.files = new ArrayList<File>(noDuplicates);
    }

    private DefaultClassPath(Set<File> files) {
        this.files = new ArrayList<File>(files);
    }

    public DefaultClassPath(File ... files) {
        LinkedHashSet noDuplicates = new LinkedHashSet();
        Collections.addAll(noDuplicates, files);
        this.files = new ArrayList<File>(noDuplicates);
    }

    public String toString() {
        return this.files.toString();
    }

    @Override
    public boolean isEmpty() {
        return this.files.isEmpty();
    }

    @Override
    public List<URI> getAsURIs() {
        ArrayList<URI> urls = new ArrayList<URI>();
        for (File file : this.files) {
            urls.add(file.toURI());
        }
        return urls;
    }

    @Override
    public List<File> getAsFiles() {
        return this.files;
    }

    @Override
    public URL[] getAsURLArray() {
        List<URL> result = this.getAsURLs();
        return result.toArray(new URL[result.size()]);
    }

    @Override
    public List<URL> getAsURLs() {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (File file : this.files) {
            try {
                urls.add(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw UncheckedException.throwAsUncheckedException(e);
            }
        }
        return urls;
    }

    @Override
    public ClassPath plus(ClassPath other) {
        if (this.files.isEmpty()) {
            return other;
        }
        if (other.isEmpty()) {
            return this;
        }
        return new DefaultClassPath(this.concat(this.files, other.getAsFiles()));
    }

    @Override
    public ClassPath plus(Collection<File> other) {
        if (other.isEmpty()) {
            return this;
        }
        return new DefaultClassPath(this.concat(this.files, other));
    }

    private Set<File> concat(Collection<File> files1, Collection<File> files2) {
        LinkedHashSet<File> result = new LinkedHashSet<File>();
        result.addAll(files1);
        result.addAll(files2);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        DefaultClassPath other = (DefaultClassPath)obj;
        return this.files.equals(other.files);
    }

    public int hashCode() {
        return this.files.hashCode();
    }
}

