/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.idea.avdmanager.AvdUiAction;
import com.android.utils.HtmlBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;

public class AvdSummaryAction
extends AvdUiAction {
    private static final Logger LOG = Logger.getInstance(AvdSummaryAction.class);

    public AvdSummaryAction(AvdUiAction.AvdInfoProvider avdInfoProvider) {
        super(avdInfoProvider, "View Details", "View details for debugging", AllIcons.General.BalloonInformation);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        AvdInfo info = this.getAvdInfo();
        if (info == null) {
            return;
        }
        HtmlBuilder htmlBuilder = new HtmlBuilder();
        htmlBuilder.openHtmlBody();
        htmlBuilder.addHtml("<br>Name: ").add(info.getName());
        htmlBuilder.addHtml("<br>CPU/ABI: ").add(AvdInfo.getPrettyAbiType((AvdInfo)info));
        htmlBuilder.addHtml("<br>Path: ").add(info.getDataFolderPath());
        if (info.getStatus() != AvdInfo.AvdStatus.OK) {
            htmlBuilder.addHtml("<br>Error: ").add(info.getErrorMessage());
        } else {
            String snapshot;
            String sdcard;
            IAndroidTarget target = info.getTarget();
            AndroidVersion version = target.getVersion();
            htmlBuilder.addHtml("<br>Target: ").add(String.format("%1$s (API level %2$s)", target.getName(), version.getApiString()));
            Map properties = info.getProperties();
            String skin = (String)properties.get("skin.name");
            if (skin != null) {
                htmlBuilder.addHtml("<br>Skin: ").add(skin);
            }
            if ((sdcard = (String)properties.get("sdcard.size")) == null) {
                sdcard = (String)properties.get("sdcard.path");
            }
            if (sdcard != null) {
                htmlBuilder.addHtml("<br>SD Card: ").add(sdcard);
            }
            if ((snapshot = (String)properties.get("snapshot.present")) != null) {
                htmlBuilder.addHtml("<br>Snapshot: ").add(snapshot);
            }
            HashMap copy = new HashMap(properties);
            copy.remove("abi.type");
            copy.remove("hw.cpu.arch");
            copy.remove("skin.name");
            copy.remove("skin.path");
            copy.remove("sdcard.size");
            copy.remove("sdcard.path");
            copy.remove("image.sysdir.1");
            copy.remove("image.sysdir.2");
            if (copy.size() > 0) {
                for (Map.Entry entry : copy.entrySet()) {
                    htmlBuilder.addHtml("<br>").add((String)entry.getKey()).add(": ").add((String)entry.getValue());
                }
            }
        }
        htmlBuilder.closeHtmlBody();
        String[] options = new String[]{"Copy to Clipboard and Close", "Close"};
        int i = Messages.showDialog((Project)null, (String)htmlBuilder.getHtml(), (String)("Details for " + info.getName()), (String[])options, (int)0, (Icon)AllIcons.General.InformationDialog);
        if (i == 0) {
            CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(StringUtil.stripHtml((String)htmlBuilder.getHtml(), (boolean)true)));
        }
    }

    @Override
    public boolean isEnabled() {
        return this.getAvdInfo() != null;
    }
}

