/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.tools.idea.configurations.RenderContext;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.CheckboxAction;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.UIUtil;
import org.jetbrains.android.uipreview.AndroidEditorSettings;
import org.jetbrains.annotations.NotNull;

public class RenderOptionsMenuBuilder {
    final DefaultActionGroup myGroup;
    final AndroidEditorSettings mySettings;
    private final RenderContext myContext;

    private RenderOptionsMenuBuilder(@NotNull RenderContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/configurations/RenderOptionsMenuBuilder", "<init>"));
        }
        this.myGroup = new DefaultActionGroup();
        this.mySettings = AndroidEditorSettings.getInstance();
        this.myContext = context;
    }

    public static RenderOptionsMenuBuilder create(@NotNull RenderContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/configurations/RenderOptionsMenuBuilder", "create"));
        }
        return new RenderOptionsMenuBuilder(context);
    }

    @NotNull
    public RenderOptionsMenuBuilder addPreferXmlOption() {
        this.myGroup.addAction((AnAction)new CheckboxAction("Prefer XML Editor"){

            public boolean isSelected(AnActionEvent e) {
                return RenderOptionsMenuBuilder.this.mySettings.getGlobalState().isPreferXmlEditor();
            }

            public void setSelected(AnActionEvent e, boolean state) {
                RenderOptionsMenuBuilder.this.mySettings.getGlobalState().setPreferXmlEditor(state);
                Module module = RenderOptionsMenuBuilder.this.myContext.getModule();
                VirtualFile file = RenderOptionsMenuBuilder.this.myContext.getVirtualFile();
                if (module != null && file != null) {
                    Project project = module.getProject();
                    FileEditorManager manager = FileEditorManager.getInstance((Project)project);
                    if (state) {
                        OpenFileDescriptor descriptor = new OpenFileDescriptor(project, file, 0);
                        manager.openEditor(descriptor, true);
                    } else {
                        FileEditorManager.getInstance((Project)project).setSelectedEditor(file, "android-designer");
                    }
                }
            }
        }).setAsSecondary(true);
        RenderOptionsMenuBuilder renderOptionsMenuBuilder = this;
        if (renderOptionsMenuBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/RenderOptionsMenuBuilder", "addPreferXmlOption"));
        }
        return renderOptionsMenuBuilder;
    }

    @NotNull
    public RenderOptionsMenuBuilder addHideOption() {
        this.myGroup.addAction((AnAction)new CheckboxAction("Hide for Non-layout Files"){

            public boolean isSelected(AnActionEvent e) {
                return RenderOptionsMenuBuilder.this.mySettings.getGlobalState().isHideForNonLayoutFiles();
            }

            public void setSelected(AnActionEvent e, boolean state) {
                RenderOptionsMenuBuilder.this.mySettings.getGlobalState().setHideForNonLayoutFiles(state);
            }
        }).setAsSecondary(true);
        RenderOptionsMenuBuilder renderOptionsMenuBuilder = this;
        if (renderOptionsMenuBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/RenderOptionsMenuBuilder", "addHideOption"));
        }
        return renderOptionsMenuBuilder;
    }

    @NotNull
    public RenderOptionsMenuBuilder addDeviceFrameOption() {
        this.myGroup.addAction((AnAction)new CheckboxAction("Include Device Frames (if available)"){

            public boolean isSelected(AnActionEvent e) {
                return RenderOptionsMenuBuilder.this.mySettings.getGlobalState().isShowDeviceFrames();
            }

            public void setSelected(AnActionEvent e, boolean state) {
                RenderOptionsMenuBuilder.this.mySettings.getGlobalState().setShowDeviceFrames(state);
                RenderOptionsMenuBuilder.this.myContext.requestRender();
            }
        }).setAsSecondary(true);
        this.myGroup.addAction((AnAction)new CheckboxAction("    Show Lighting Effects"){

            public boolean isSelected(AnActionEvent e) {
                return RenderOptionsMenuBuilder.this.mySettings.getGlobalState().isShowEffects();
            }

            public void setSelected(AnActionEvent e, boolean state) {
                RenderOptionsMenuBuilder.this.mySettings.getGlobalState().setShowEffects(state);
                RenderOptionsMenuBuilder.this.myContext.requestRender();
            }
        }).setAsSecondary(true);
        RenderOptionsMenuBuilder renderOptionsMenuBuilder = this;
        if (renderOptionsMenuBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/RenderOptionsMenuBuilder", "addDeviceFrameOption"));
        }
        return renderOptionsMenuBuilder;
    }

    @NotNull
    public RenderOptionsMenuBuilder addRetinaOption() {
        if (UIUtil.isRetina()) {
            this.myGroup.addAction((AnAction)new CheckboxAction("DEBUG: Render in Retina resolution"){

                public boolean isSelected(AnActionEvent e) {
                    return RenderOptionsMenuBuilder.this.mySettings.getGlobalState().isRetina();
                }

                public void setSelected(AnActionEvent e, boolean state) {
                    RenderOptionsMenuBuilder.this.mySettings.getGlobalState().setRetina(state);
                    RenderOptionsMenuBuilder.this.myContext.requestRender();
                }
            }).setAsSecondary(true);
        }
        RenderOptionsMenuBuilder renderOptionsMenuBuilder = this;
        if (renderOptionsMenuBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/RenderOptionsMenuBuilder", "addRetinaOption"));
        }
        return renderOptionsMenuBuilder;
    }

    @NotNull
    public ActionToolbar build() {
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)this.myGroup, true);
        toolbar.setReservePlaceAutoPopupIcon(false);
        toolbar.setSecondaryActionsTooltip("Options");
        ActionToolbar actionToolbar = toolbar;
        if (actionToolbar == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/RenderOptionsMenuBuilder", "build"));
        }
        return actionToolbar;
    }
}

