/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.google.common.base.Objects;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import org.jetbrains.annotations.Nullable;

public class ThemeEditorState
implements FileEditorState {
    @Nullable
    private final String myModuleName;
    @Nullable
    private final String myThemeName;
    @Nullable
    private final String mySubStyleName;
    private final float myProportion;

    public ThemeEditorState(@Nullable String themeName, @Nullable String subStyleName, @Nullable Float proportion, @Nullable String moduleName) {
        this.myThemeName = themeName;
        this.mySubStyleName = subStyleName;
        this.myModuleName = moduleName;
        this.myProportion = proportion == null ? 0.5f : proportion.floatValue();
    }

    @Nullable
    public String getThemeName() {
        return this.myThemeName;
    }

    @Nullable
    public String getSubStyleName() {
        return this.mySubStyleName;
    }

    public float getProportion() {
        return this.myProportion;
    }

    @Nullable
    public String getModuleName() {
        return this.myModuleName;
    }

    public boolean canBeMergedWith(FileEditorState otherState, FileEditorStateLevel level) {
        return otherState instanceof ThemeEditorState;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThemeEditorState that = (ThemeEditorState)o;
        return Objects.equal((Object)Float.valueOf(this.myProportion), (Object)Float.valueOf(that.myProportion)) && Objects.equal((Object)this.myModuleName, (Object)that.myModuleName) && Objects.equal((Object)this.myThemeName, (Object)that.myThemeName) && Objects.equal((Object)this.mySubStyleName, (Object)that.mySubStyleName);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.myModuleName, this.myThemeName, this.mySubStyleName, Float.valueOf(this.myProportion)});
    }

    public String toString() {
        return "ThemeEditorState{myModuleName='" + this.myModuleName + '\'' + ", myThemeName='" + this.myThemeName + '\'' + ", mySubStyleName='" + this.mySubStyleName + '\'' + ", myProportion=" + this.myProportion + '}';
    }
}

