/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.eclipse;

import com.android.tools.idea.gradle.eclipse.AdtImportProvider;
import com.android.tools.idea.gradle.eclipse.GradleImport;
import com.google.common.collect.Lists;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.projectImport.ProjectImportWizardStep;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;

class AdtImportWarningsStep
extends ProjectImportWizardStep {
    private JTextArea myWarnings;
    private JPanel myPanel;

    AdtImportWarningsStep(WizardContext context) {
        super(context);
        this.$$$setupUI$$$();
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public void updateDataModel() {
    }

    public void updateStep() {
        super.updateStep();
        GradleImport importer = AdtImportProvider.getImporter(this.getWizardContext());
        if (importer != null) {
            StringBuilder sb = new StringBuilder();
            ArrayList problems = Lists.newArrayList();
            problems.addAll(importer.getErrors());
            problems.addAll(importer.getWarnings());
            if (!problems.isEmpty()) {
                sb.append("\n");
                for (String problem : problems) {
                    sb.append(" * ");
                    sb.append(problem);
                    sb.append("\n");
                }
            }
            this.myWarnings.setText(sb.toString());
        }
    }

    public boolean isStepVisible() {
        GradleImport importer = AdtImportProvider.getImporter(this.getWizardContext());
        return importer == null || !importer.getErrors().isEmpty() || !importer.getWarnings().isEmpty();
    }

    public boolean validate() throws ConfigurationException {
        GradleImport importer = AdtImportProvider.getImporter(this.getWizardContext());
        if (importer != null && !importer.getErrors().isEmpty()) {
            throw new ConfigurationException("There are unrecoverable errors which must be corrected first");
        }
        return super.validate();
    }

    public String getName() {
        return "ADT Import Issues";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextArea jTextArea;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.setPreferredSize(new Dimension(500, 61));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("<html>Loading the Eclipse project generated the following warnings. If the errors are recoverable you can proceed with the import. When done, it will open a report which explains how the old project was mapped to the new Gradle-style project, and any subsequent manual steps.</html>");
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 9, 0, 7, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myWarnings = jTextArea = new JTextArea();
        jTextArea.setEditable(false);
        jBScrollPane.setViewportView(jTextArea);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

