/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.invoker.console.view;

import com.intellij.codeEditor.printing.PrintAction;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.ide.actions.NextOccurenceToolbarAction;
import com.intellij.ide.actions.PreviousOccurenceToolbarAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class GradleConsoleView
implements Disposable {
    private static final Class<?>[] IGNORED_CONSOLE_ACTION_TYPES = new Class[]{PreviousOccurenceToolbarAction.class, NextOccurenceToolbarAction.class, ConsoleViewImpl.ClearAllAction.class, PrintAction.class};
    @NotNull
    private final Project myProject;
    @NotNull
    private final ConsoleViewImpl myConsoleView;
    private JPanel myConsolePanel;

    public GradleConsoleView(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/invoker/console/view/GradleConsoleView", "<init>"));
        }
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myConsoleView = new ConsoleViewImpl(this.myProject, false);
        Disposer.register((Disposable)this, (Disposable)this.myConsoleView);
    }

    public static GradleConsoleView getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/invoker/console/view/GradleConsoleView", "getInstance"));
        }
        return (GradleConsoleView)ServiceManager.getService((Project)project, GradleConsoleView.class);
    }

    public void createToolWindowContent(@NotNull ToolWindow toolWindow) {
        AnAction[] consoleActions;
        if (toolWindow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindow", "com/android/tools/idea/gradle/invoker/console/view/GradleConsoleView", "createToolWindowContent"));
        }
        RunnerLayoutUi.Factory factory = RunnerLayoutUi.Factory.getInstance((Project)this.myProject);
        RunnerLayoutUi layoutUi = factory.create("", "", "session", (Disposable)this.myProject);
        DefaultActionGroup group = new DefaultActionGroup();
        layoutUi.getOptions().setLeftToolbar((ActionGroup)group, "unknown");
        Content console = layoutUi.createContent("Gradle Console", this.myConsoleView.getComponent(), "", null, null);
        for (AnAction action : consoleActions = this.myConsoleView.createConsoleActions()) {
            if (GradleConsoleView.shouldIgnoreAction(action)) continue;
            group.add(action);
        }
        layoutUi.addContent(console, 0, PlaceInGrid.right, false);
        JComponent layoutComponent = layoutUi.getComponent();
        this.myConsolePanel.add((Component)layoutComponent, "Center");
        Content content = ContentFactory.SERVICE.getInstance().createContent(layoutComponent, null, true);
        toolWindow.getContentManager().addContent(content);
    }

    private static boolean shouldIgnoreAction(@NotNull AnAction action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/android/tools/idea/gradle/invoker/console/view/GradleConsoleView", "shouldIgnoreAction"));
        }
        for (Class<?> actionType : IGNORED_CONSOLE_ACTION_TYPES) {
            if (!actionType.isInstance(action)) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        if (this.myConsoleView.isShowing()) {
            this.myConsoleView.clear();
        } else {
            ApplicationManager.getApplication().invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    GradleConsoleView.this.myConsoleView.flushDeferredText();
                }
            }, ModalityState.NON_MODAL);
        }
    }

    public void print(@NotNull String text, @NotNull ConsoleViewContentType contentType) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/gradle/invoker/console/view/GradleConsoleView", "print"));
        }
        if (contentType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentType", "com/android/tools/idea/gradle/invoker/console/view/GradleConsoleView", "print"));
        }
        this.myConsoleView.print(text, contentType);
    }

    public void dispose() {
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.myConsolePanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myConsolePanel;
    }
}

