/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator;

import com.android.tools.idea.navigator.AndroidTreeUpdater;
import com.android.tools.idea.navigator.nodes.DirectoryGroupNode;
import com.google.common.collect.Maps;
import com.intellij.ide.projectView.impl.ProjectAbstractTreeStructureBase;
import com.intellij.ide.projectView.impl.ProjectTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeUpdater;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidProjectTreeBuilder
extends ProjectTreeBuilder {
    private Map<VirtualFile, AbstractTreeNode> myFileToNodeMap;

    public AndroidProjectTreeBuilder(@NotNull Project project, @NotNull JTree tree, @NotNull DefaultTreeModel treeModel, @Nullable Comparator<NodeDescriptor> comparator, @NotNull ProjectAbstractTreeStructureBase treeStructure) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/navigator/AndroidProjectTreeBuilder", "<init>"));
        }
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/navigator/AndroidProjectTreeBuilder", "<init>"));
        }
        if (treeModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeModel", "com/android/tools/idea/navigator/AndroidProjectTreeBuilder", "<init>"));
        }
        if (treeStructure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeStructure", "com/android/tools/idea/navigator/AndroidProjectTreeBuilder", "<init>"));
        }
        super(project, tree, treeModel, comparator, treeStructure);
        this.myFileToNodeMap = Maps.newHashMap();
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)project);
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener.Adapter(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/android/tools/idea/navigator/AndroidProjectTreeBuilder$1", "after"));
                }
                for (VFileEvent vFileEvent : events) {
                    if (!(vFileEvent instanceof VFileDeleteEvent)) continue;
                    AndroidProjectTreeBuilder.this.removeMapping(vFileEvent.getFile());
                }
            }
        });
    }

    @Nullable
    protected AbstractTreeUpdater createUpdater() {
        return new AndroidTreeUpdater(this.getTreeStructure(), this);
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/navigator/AndroidProjectTreeBuilder", "getProject"));
        }
        return project;
    }

    @Nullable
    protected Object findNodeByElement(@Nullable Object element) {
        if (element == null) {
            return null;
        }
        Object node = super.findNodeByElement(element);
        if (node != null) {
            return node;
        }
        VirtualFile virtualFile = null;
        if (element instanceof PsiDirectory) {
            virtualFile = ((PsiDirectory)element).getVirtualFile();
        } else if (element instanceof PsiFile) {
            virtualFile = ((PsiFile)element).getVirtualFile();
        }
        if (virtualFile == null) {
            return null;
        }
        AbstractTreeNode treeNode = this.getNodeForFile(virtualFile);
        if (treeNode == null) {
            return null;
        }
        Object parentNode = this.findNodeByElement(treeNode.getParent());
        if (!(parentNode instanceof DefaultMutableTreeNode)) {
            return null;
        }
        Enumeration<TreeNode> children = ((DefaultMutableTreeNode)parentNode).children();
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
            if (!(child.getUserObject() instanceof DirectoryGroupNode)) continue;
            for (PsiDirectory folder : ((DirectoryGroupNode)child.getUserObject()).getDirectories()) {
                if (!folder.getVirtualFile().equals(virtualFile)) continue;
                return child;
            }
        }
        return null;
    }

    public void createMapping(@NotNull VirtualFile file, @NotNull AbstractTreeNode node) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/navigator/AndroidProjectTreeBuilder", "createMapping"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/idea/navigator/AndroidProjectTreeBuilder", "createMapping"));
        }
        this.myFileToNodeMap.put(file, node);
    }

    private void removeMapping(@Nullable VirtualFile file) {
        this.myFileToNodeMap.remove(file);
    }

    @Nullable
    private AbstractTreeNode getNodeForFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/navigator/AndroidProjectTreeBuilder", "getNodeForFile"));
        }
        return this.myFileToNodeMap.get(file);
    }
}

