/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw;

import com.android.tools.idea.npw.ConfigureAndroidProjectPath;
import com.android.tools.idea.npw.NewProjectWizardState;
import com.android.tools.idea.npw.WizardUtils;
import com.android.tools.idea.ui.LabelWithEditLink;
import com.android.tools.idea.wizard.WizardConstants;
import com.android.tools.idea.wizard.dynamic.DynamicWizardStepWithHeaderAndDescription;
import com.android.tools.idea.wizard.dynamic.ScopedDataBinder;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigureAndroidProjectStep
extends DynamicWizardStepWithHeaderAndDescription {
    private static final String EXAMPLE_DOMAIN = "example.com";
    public static final String SAVED_COMPANY_DOMAIN = "SAVED_COMPANY_DOMAIN";
    private static final CharMatcher ILLEGAL_CHARACTER_MATCHER = CharMatcher.anyOf((CharSequence)"[/\\\\?%*:|\"<>!;]");
    static final Set<String> INVALID_MSFT_FILENAMES = ImmutableSet.of((Object)"con", (Object)"prn", (Object)"aux", (Object)"clock$", (Object)"nul", (Object)"com1", (Object[])new String[]{"com2", "com3", "com4", "com5", "com6", "com7", "com8", "com9", "lpt1", "lpt2", "lpt3", "lpt4", "lpt5", "lpt6", "lpt7", "lpt8", "lpt9", "$mft", "$mftmirr", "$logfile", "$volume", "$attrdef", "$bitmap", "$boot", "$badclus", "$secure", "$upcase", "$extend", "$quota", "$objid", "$reparse"});
    private TextFieldWithBrowseButton myProjectLocation;
    private JTextField myAppName;
    private JPanel myPanel;
    private JTextField myCompanyDomain;
    private LabelWithEditLink myPackageName;
    public static final ScopedDataBinder.ValueDeriver<String> PACKAGE_NAME_DERIVER = new ScopedDataBinder.ValueDeriver<String>(){

        @Override
        @Nullable
        public Set<ScopedStateStore.Key<?>> getTriggerKeys() {
            return 2.makeSetOf(WizardConstants.APPLICATION_NAME_KEY, WizardConstants.COMPANY_DOMAIN_KEY);
        }

        @Override
        @Nullable
        public String deriveValue(@NotNull ScopedStateStore state, ScopedStateStore.Key changedKey, @Nullable String currentValue) {
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/npw/ConfigureAndroidProjectStep$2", "deriveValue"));
            }
            String projectName = state.get(WizardConstants.APPLICATION_NAME_KEY);
            if (projectName == null) {
                projectName = "app";
            }
            projectName = ConfigureAndroidProjectStep.nameToPackage(projectName);
            String companyDomain = state.get(WizardConstants.COMPANY_DOMAIN_KEY);
            if (companyDomain == null) {
                companyDomain = ConfigureAndroidProjectStep.EXAMPLE_DOMAIN;
            }
            ArrayList domainParts = Lists.newArrayList((Object[])companyDomain.split("\\."));
            String reversedDomain = Joiner.on((char)'.').skipNulls().join((Iterable)Lists.reverse((List)Lists.transform((List)domainParts, (Function)new Function<String, String>(){

                public String apply(String input) {
                    String name = ConfigureAndroidProjectStep.nameToPackage(input);
                    return name.isEmpty() ? null : name;
                }
            })));
            return reversedDomain + '.' + projectName;
        }
    };
    private static final ScopedDataBinder.ValueDeriver<String> myProjectLocationDeriver = new ScopedDataBinder.ValueDeriver<String>(){

        @Override
        @Nullable
        public Set<ScopedStateStore.Key<?>> getTriggerKeys() {
            return 3.makeSetOf(WizardConstants.APPLICATION_NAME_KEY);
        }

        @Override
        @Nullable
        public String deriveValue(ScopedStateStore state, ScopedStateStore.Key changedKey, @Nullable String currentValue) {
            String name = state.get(WizardConstants.APPLICATION_NAME_KEY);
            name = name == null ? "" : name;
            name = name.replaceAll("[/\\\\?%*:|\"<>!;]", "");
            name = name.replaceAll("\\s", "");
            File baseDirectory = new File(NewProjectWizardState.getProjectFileDirectory());
            File projectDir = new File(baseDirectory, name);
            int i = 2;
            while (projectDir.exists()) {
                projectDir = new File(baseDirectory, name + i);
                ++i;
            }
            return projectDir.getPath();
        }
    };

    public ConfigureAndroidProjectStep(@NotNull Disposable disposable) {
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/android/tools/idea/npw/ConfigureAndroidProjectStep", "<init>"));
        }
        this("Configure your new project", disposable);
    }

    public ConfigureAndroidProjectStep(String title, Disposable parentDisposable) {
        super(title, null, parentDisposable);
        this.$$$setupUI$$$();
        this.setBodyComponent(this.myPanel);
    }

    @Override
    public void init() {
        this.register(WizardConstants.APPLICATION_NAME_KEY, this.myAppName);
        this.register(WizardConstants.COMPANY_DOMAIN_KEY, this.myCompanyDomain);
        this.register(WizardConstants.PACKAGE_NAME_KEY, this.myPackageName);
        this.registerValueDeriver(WizardConstants.PACKAGE_NAME_KEY, PACKAGE_NAME_DERIVER);
        this.register(WizardConstants.PROJECT_LOCATION_KEY, this.myProjectLocation);
        this.registerValueDeriver(WizardConstants.PROJECT_LOCATION_KEY, myProjectLocationDeriver);
        this.myProjectLocation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigureAndroidProjectStep.this.browseForFile();
            }
        });
        this.myState.put(WizardConstants.APPLICATION_NAME_KEY, "My Application");
        String savedCompanyDomain = PropertiesComponent.getInstance().getValue(SAVED_COMPANY_DOMAIN);
        if (savedCompanyDomain == null && (savedCompanyDomain = ConfigureAndroidProjectStep.nameToPackage(System.getProperty("user.name"))) != null) {
            savedCompanyDomain = savedCompanyDomain + '.' + EXAMPLE_DOMAIN;
        }
        if (savedCompanyDomain == null) {
            savedCompanyDomain = EXAMPLE_DOMAIN;
        }
        this.myState.put(WizardConstants.COMPANY_DOMAIN_KEY, savedCompanyDomain);
        super.init();
    }

    private void browseForFile() {
        FileSaverDescriptor fileSaverDescriptor = new FileSaverDescriptor("Project location", "Please choose a location for your project", new String[0]);
        File currentPath = new File(this.myProjectLocation.getText());
        File parentPath = currentPath.getParentFile();
        if (parentPath == null) {
            String homePath = System.getProperty("user.home");
            parentPath = homePath == null ? new File("/") : new File(homePath);
        }
        VirtualFile parent = LocalFileSystem.getInstance().findFileByIoFile(parentPath);
        String filename = currentPath.getName();
        VirtualFileWrapper fileWrapper = FileChooserFactory.getInstance().createSaveFileDialog(fileSaverDescriptor, (Project)null).save(parent, filename);
        if (fileWrapper != null) {
            this.myProjectLocation.setText(fileWrapper.getFile().getAbsolutePath());
        }
    }

    @Override
    public void deriveValues(Set<ScopedStateStore.Key> modified) {
        String message;
        String domain;
        super.deriveValues(modified);
        if (modified.contains(WizardConstants.COMPANY_DOMAIN_KEY) && (domain = this.myState.get(WizardConstants.COMPANY_DOMAIN_KEY)) != null && !domain.isEmpty() && this.myState.containsKey(WizardConstants.PACKAGE_NAME_KEY) && (message = AndroidUtils.validateAndroidPackageName(this.myState.get(WizardConstants.PACKAGE_NAME_KEY))) == null) {
            PropertiesComponent.getInstance().setValue(SAVED_COMPANY_DOMAIN, domain);
        }
    }

    @Override
    public boolean validate() {
        if (!this.myPath.validate()) {
            return false;
        }
        WizardUtils.ValidationResult locationValidationResult = WizardUtils.validateLocation(this.myState.get(WizardConstants.PROJECT_LOCATION_KEY));
        this.setErrorHtml(locationValidationResult.isOk() ? "" : locationValidationResult.getFormattedMessage());
        return this.validateAppName() && this.validatePackageName() && !locationValidationResult.isError();
    }

    protected boolean validateAppName() {
        String appName = this.myState.get(WizardConstants.APPLICATION_NAME_KEY);
        if (appName == null || appName.isEmpty()) {
            this.setErrorHtml("Please enter an application name (shown in launcher)");
            return false;
        }
        if (Character.isLowerCase(appName.charAt(0))) {
            this.setErrorHtml("The application name for most apps begins with an uppercase letter");
        }
        return true;
    }

    protected boolean validatePackageName() {
        String packageName = this.myState.get(WizardConstants.PACKAGE_NAME_KEY);
        if (packageName == null) {
            this.setErrorHtml("Please enter a package name (This package uniquely identifies your application)");
            return false;
        }
        String message = AndroidUtils.validateAndroidPackageName(packageName);
        if (message != null) {
            this.setErrorHtml("Invalid package name: " + message);
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public String getStepName() {
        if ("Create Android Project" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/ConfigureAndroidProjectStep", "getStepName"));
        }
        return "Create Android Project";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myAppName;
    }

    @Nullable
    public String getHelpText(@NotNull ScopedStateStore.Key<?> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/npw/ConfigureAndroidProjectStep", "getHelpText"));
        }
        if (key.equals(WizardConstants.APPLICATION_NAME_KEY)) {
            return "The application name is shown in the Play store, as well as in the Manage Applications list in Settings.";
        }
        if (key.equals(WizardConstants.PACKAGE_NAME_KEY)) {
            return "The package name must be a unique identifier for your application.\n It is typically not shown to users, but it <b>must</b> stay the same for the lifetime of your application; it is how multiple versions of the same application are considered the \"same app\".\nThis is typically the reverse domain name of your organization plus one or more application identifiers, and it must be a valid Java package name.";
        }
        return null;
    }

    static String nameToPackage(String name) {
        name = name.replace('-', '_');
        name = name.replaceAll("[^a-zA-Z0-9_]", "");
        name = name.toLowerCase();
        return name;
    }

    @Override
    @NotNull
    protected DynamicWizardStepWithHeaderAndDescription.WizardStepHeaderSettings getStepHeader() {
        DynamicWizardStepWithHeaderAndDescription.WizardStepHeaderSettings wizardStepHeaderSettings = ConfigureAndroidProjectPath.buildConfigurationHeader();
        if (wizardStepHeaderSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/ConfigureAndroidProjectStep", "getStepHeader"));
        }
        return wizardStepHeaderSettings;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        LabelWithEditLink labelWithEditLink;
        JTextField jTextField;
        JTextField jTextField2;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 5, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        jLabel.setText("Project location:");
        jPanel.add((Component)jLabel, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myProjectLocation = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(4, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myAppName = jTextField2 = new JTextField();
        jPanel.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Application name:");
        jLabel2.setDisplayedMnemonic('A');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Package name:");
        jPanel.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCompanyDomain = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Company Domain:");
        jLabel4.setDisplayedMnemonic('C');
        jLabel4.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel4, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(5, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myPackageName = labelWithEditLink = new LabelWithEditLink();
        jPanel.add((Component)labelWithEditLink, new GridConstraints(2, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        jLabel2.setLabelFor(jTextField2);
        jLabel4.setLabelFor(jTextField);
    }

    @Override
    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

