/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.run.ConsolePrinter;
import com.google.common.base.Predicate;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import org.jetbrains.annotations.NotNull;

public final class DeviceReadyListener
implements AndroidDebugBridge.IDeviceChangeListener,
Disposable {
    private final MergingUpdateQueue myQueue;
    @NotNull
    private final ConsolePrinter myPrinter;
    @NotNull
    private final Predicate<IDevice> myDeviceFilter;
    @NotNull
    private final Callback myCallback;
    @NotNull
    private final Object myFinishedLock;
    private boolean myFinished;

    public DeviceReadyListener(@NotNull ConsolePrinter printer, @NotNull Predicate<IDevice> deviceFilter, @NotNull Callback callback) {
        if (printer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printer", "com/android/tools/idea/run/DeviceReadyListener", "<init>"));
        }
        if (deviceFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deviceFilter", "com/android/tools/idea/run/DeviceReadyListener", "<init>"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/android/tools/idea/run/DeviceReadyListener", "<init>"));
        }
        this.myQueue = new MergingUpdateQueue("ANDROID_DEVICE_STATE_UPDATE_QUEUE", 1000, true, null, (Disposable)this, null, false);
        this.myFinishedLock = new Object();
        this.myPrinter = printer;
        this.myDeviceFilter = deviceFilter;
        this.myCallback = callback;
    }

    public void dispose() {
    }

    public void deviceConnected(@NotNull IDevice device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/DeviceReadyListener", "deviceConnected"));
        }
        if (device.getAvdName() == null || this.myDeviceFilter.apply((Object)device)) {
            this.myPrinter.stdout("Device connected: " + device.getSerialNumber());
            this.myQueue.queue((Update)new MyDeviceStateUpdate(device));
        }
    }

    public void deviceDisconnected(@NotNull IDevice device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/DeviceReadyListener", "deviceDisconnected"));
        }
        if (this.myDeviceFilter.apply((Object)device)) {
            this.myPrinter.stdout("Device disconnected: " + device.getSerialNumber());
        }
    }

    public void deviceChanged(final @NotNull IDevice device, int changeMask) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/DeviceReadyListener", "deviceChanged"));
        }
        this.myQueue.queue(new Update(device.getSerialNumber()){

            public void run() {
                DeviceReadyListener.this.onDeviceChanged(device);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onDeviceChanged(@NotNull IDevice device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/DeviceReadyListener", "onDeviceChanged"));
        }
        Object object = this.myFinishedLock;
        synchronized (object) {
            if (this.myFinished || !this.myDeviceFilter.apply((Object)device) || !device.isOnline()) {
                return;
            }
            if (!DeviceReadyListener.isReady(device)) {
                return;
            }
            this.myPrinter.stdout("Device is ready: " + device.getName());
            this.myFinished = true;
        }
        Disposer.dispose((Disposable)this.myQueue);
        this.myCallback.onDeviceReady(device);
    }

    private static boolean isReady(@NotNull IDevice device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/DeviceReadyListener", "isReady"));
        }
        if (!device.isOnline()) {
            return false;
        }
        return device.getClients().length >= 5 || device.getClient("android.process.acore") != null || device.getClient("com.google.android.wearable.app") != null;
    }

    public static ListenableFuture<IDevice> getReadyDevice(@NotNull Predicate<IDevice> deviceFilter, @NotNull ConsolePrinter logger) {
        if (deviceFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deviceFilter", "com/android/tools/idea/run/DeviceReadyListener", "getReadyDevice"));
        }
        if (logger == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logger", "com/android/tools/idea/run/DeviceReadyListener", "getReadyDevice"));
        }
        final SettableFuture future = SettableFuture.create();
        Callback callback = new Callback(){

            @Override
            public void onDeviceReady(@NotNull IDevice device) {
                if (device == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/DeviceReadyListener$2", "onDeviceReady"));
                }
                future.set((Object)device);
            }
        };
        final DeviceReadyListener deviceReadyListener = new DeviceReadyListener(logger, deviceFilter, callback);
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<IDevice>(){

            public void onSuccess(IDevice result) {
                DeviceReadyListener.shutdown(deviceReadyListener);
            }

            public void onFailure(@NotNull Throwable t) {
                if (t == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/android/tools/idea/run/DeviceReadyListener$3", "onFailure"));
                }
                DeviceReadyListener.shutdown(deviceReadyListener);
            }
        });
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)deviceReadyListener);
        return future;
    }

    private static void shutdown(@NotNull DeviceReadyListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/run/DeviceReadyListener", "shutdown"));
        }
        Disposer.dispose((Disposable)listener);
        AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)listener);
    }

    private class MyDeviceStateUpdate
    extends Update {
        @NotNull
        private final IDevice myDevice;

        public MyDeviceStateUpdate(IDevice device) {
            if (device == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/DeviceReadyListener$MyDeviceStateUpdate", "<init>"));
            }
            super((Object)device.getSerialNumber());
            this.myDevice = device;
        }

        public void run() {
            DeviceReadyListener.this.onDeviceChanged(this.myDevice);
            DeviceReadyListener.this.myQueue.queue((Update)new MyDeviceStateUpdate(this.myDevice));
        }
    }

    static interface Callback {
        public void onDeviceReady(@NotNull IDevice var1);
    }
}

