/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.testing;

import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.tools.idea.run.AndroidRunningState;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.sm.ServiceMessageBuilder;
import com.intellij.openapi.util.Comparing;
import java.util.Map;

public class AndroidTestListener
implements ITestRunListener {
    private final AndroidRunningState myRunningState;
    private long myTestStartingTime;
    private long myTestSuiteStartingTime;
    private String myTestClassName = null;
    private ProcessHandler myProcessHandler;

    public ProcessHandler getProcessHandler() {
        if (this.myProcessHandler == null) {
            this.myProcessHandler = this.myRunningState.getProcessHandler();
        }
        return this.myProcessHandler;
    }

    public AndroidTestListener(AndroidRunningState runningState) {
        this.myRunningState = runningState;
    }

    public void testRunStopped(long elapsedTime) {
        ProcessHandler handler = this.getProcessHandler();
        handler.notifyTextAvailable("Test running stopped\n", ProcessOutputTypes.STDOUT);
        handler.destroyProcess();
    }

    public void testRunEnded(long elapsedTime, Map<String, String> runMetrics) {
        if (this.myTestClassName != null) {
            this.testSuiteFinished();
        }
        ProcessHandler handler = this.getProcessHandler();
        handler.notifyTextAvailable("Finish\n", ProcessOutputTypes.STDOUT);
        handler.destroyProcess();
    }

    public void testRunStarted(String runName, int testCount) {
        ProcessHandler handler = this.getProcessHandler();
        handler.notifyTextAvailable("Test running started\n", ProcessOutputTypes.STDOUT);
        ServiceMessageBuilder builder = new ServiceMessageBuilder("enteredTheMatrix");
        handler.notifyTextAvailable(builder.toString() + '\n', ProcessOutputTypes.STDOUT);
    }

    public void testStarted(TestIdentifier test) {
        if (!Comparing.equal((String)test.getClassName(), (String)this.myTestClassName)) {
            if (this.myTestClassName != null) {
                this.testSuiteFinished();
            }
            this.myTestClassName = test.getClassName();
            this.testSuiteStarted();
        }
        ServiceMessageBuilder builder = new ServiceMessageBuilder("testStarted");
        builder.addAttribute("name", test.getTestName());
        builder.addAttribute("locationHint", "android://" + this.myRunningState.getModule().getName() + ':' + test.getClassName() + '.' + test.getTestName() + "()");
        this.getProcessHandler().notifyTextAvailable(builder.toString() + '\n', ProcessOutputTypes.STDOUT);
        this.myTestStartingTime = System.currentTimeMillis();
    }

    private void testSuiteStarted() {
        this.myTestSuiteStartingTime = System.currentTimeMillis();
        ServiceMessageBuilder builder = new ServiceMessageBuilder("testSuiteStarted");
        builder.addAttribute("name", this.myTestClassName);
        builder.addAttribute("locationHint", "android://" + this.myRunningState.getModule().getName() + ':' + this.myTestClassName);
        this.getProcessHandler().notifyTextAvailable(builder.toString() + '\n', ProcessOutputTypes.STDOUT);
    }

    private void testSuiteFinished() {
        ServiceMessageBuilder builder = new ServiceMessageBuilder("testSuiteFinished");
        builder.addAttribute("name", this.myTestClassName);
        builder.addAttribute("duration", Long.toString(System.currentTimeMillis() - this.myTestSuiteStartingTime));
        this.getProcessHandler().notifyTextAvailable(builder.toString() + '\n', ProcessOutputTypes.STDOUT);
        this.myTestClassName = null;
    }

    public void testFailed(TestIdentifier test, String stackTrace) {
        ServiceMessageBuilder builder = new ServiceMessageBuilder("testFailed");
        builder.addAttribute("name", test.getTestName());
        builder.addAttribute("message", "");
        builder.addAttribute("details", stackTrace);
        builder.addAttribute("error", "true");
        this.getProcessHandler().notifyTextAvailable(builder.toString() + '\n', ProcessOutputTypes.STDOUT);
    }

    public void testAssumptionFailure(TestIdentifier test, String trace) {
        ServiceMessageBuilder builder = ServiceMessageBuilder.testIgnored((String)test.getTestName());
        builder.addAttribute("message", "Test ignored. Assumption Failed:");
        builder.addAttribute("details", trace);
        this.getProcessHandler().notifyTextAvailable(builder.toString() + "\n", ProcessOutputTypes.STDOUT);
    }

    public void testIgnored(TestIdentifier test) {
        ServiceMessageBuilder builder = ServiceMessageBuilder.testIgnored((String)test.getTestName());
        this.getProcessHandler().notifyTextAvailable(builder.toString() + "\n", ProcessOutputTypes.STDOUT);
    }

    public void testEnded(TestIdentifier test, Map<String, String> testMetrics) {
        ServiceMessageBuilder builder = new ServiceMessageBuilder("testFinished");
        builder.addAttribute("name", test.getTestName());
        builder.addAttribute("duration", Long.toString(System.currentTimeMillis() - this.myTestStartingTime));
        this.getProcessHandler().notifyTextAvailable(builder.toString() + '\n', ProcessOutputTypes.STDOUT);
    }

    public void testRunFailed(String errorMessage) {
        ProcessHandler handler = this.getProcessHandler();
        handler.notifyTextAvailable("Test running failed: " + errorMessage + "\n", ProcessOutputTypes.STDERR);
        handler.destroyProcess();
    }
}

