/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.tools.idea.welcome.install.InstallContext;
import com.android.tools.idea.welcome.install.InstallOperation;
import com.android.tools.idea.welcome.install.InstallationCancelledException;
import com.android.tools.idea.welcome.install.WizardException;
import com.android.tools.idea.welcome.wizard.WelcomeUIUtils;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.io.URLUtil;
import com.intellij.util.net.HttpConfigurable;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import org.jetbrains.annotations.NotNull;

public final class DownloadOperation
extends InstallOperation<File, File> {
    @NotNull
    private final String myUrl;

    public DownloadOperation(@NotNull InstallContext context, @NotNull String url, double progressShare) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/welcome/install/DownloadOperation", "<init>"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/android/tools/idea/welcome/install/DownloadOperation", "<init>"));
        }
        super(context, progressShare);
        this.myUrl = url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void download(@NotNull String url, @NotNull File destination, @NotNull ProgressIndicator indicator) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/android/tools/idea/welcome/install/DownloadOperation", "download"));
        }
        if (destination == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destination", "com/android/tools/idea/welcome/install/DownloadOperation", "download"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/welcome/install/DownloadOperation", "download"));
        }
        indicator.setText(String.format("Downloading %s", destination.getName()));
        HttpURLConnection connection = HttpConfigurable.getInstance().openHttpConnection(url);
        int contentLength = connection.getContentLength();
        if (contentLength <= 0) {
            indicator.setIndeterminate(true);
        }
        InputStream readStream = null;
        OutputStream stream = null;
        try {
            readStream = connection.getInputStream();
            stream = new BufferedOutputStream(new FileOutputStream(destination));
            byte[] buffer = new byte[0x200000];
            int totalRead = 0;
            long startTime = System.currentTimeMillis();
            int read = readStream.read(buffer);
            while (read > 0) {
                stream.write(buffer, 0, read);
                long duration = System.currentTimeMillis() - startTime;
                long downloadRate = duration == 0L ? 0L : (long)(totalRead += read) / duration;
                String message = String.format("Downloading %1$s (%2$s/s)", destination.getName(), WelcomeUIUtils.getSizeLabel(downloadRate * 1000L));
                indicator.setText(message);
                if (contentLength > 0) {
                    indicator.setFraction((double)totalRead / (double)contentLength);
                }
                indicator.checkCanceled();
                read = readStream.read(buffer);
            }
        }
        finally {
            if (stream != null) {
                stream.close();
            }
            if (readStream != null) {
                readStream.close();
            }
        }
    }

    @NotNull
    private static String getFileName(@NotNull String urlString) {
        block5: {
            String string;
            if (urlString == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urlString", "com/android/tools/idea/welcome/install/DownloadOperation", "getFileName"));
            }
            try {
                if (!URLUtil.containsScheme((String)urlString)) break block5;
                URL url = new URL(urlString);
                string = PathUtil.getFileName((String)url.getPath());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/install/DownloadOperation", "getFileName"));
            }
            return string;
        }
        String string = PathUtil.getFileName((String)urlString);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/install/DownloadOperation", "getFileName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected File perform(@NotNull ProgressIndicator indicator, @NotNull File arg) throws WizardException, InstallationCancelledException {
        File file;
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/welcome/install/DownloadOperation", "perform"));
        }
        if (arg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arg", "com/android/tools/idea/welcome/install/DownloadOperation", "perform"));
        }
        File file2 = new File(this.myContext.getTempDirectory(), DownloadOperation.getFileName(this.myUrl));
        this.myContext.print(String.format("Downloading %1$s from %2$s\n", file2.getName(), this.myUrl), ConsoleViewContentType.SYSTEM_OUTPUT);
        indicator.start();
        try {
            while (!this.attemptDownload(file2, indicator)) {
            }
            file = file2;
        }
        catch (ProcessCanceledException e) {
            throw new InstallationCancelledException();
        }
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/install/DownloadOperation", "perform"));
        }
        return file;
    }

    private boolean attemptDownload(File file, ProgressIndicator indicator) throws WizardException {
        try {
            DownloadOperation.download(this.myUrl, file, indicator);
            return true;
        }
        catch (UnknownHostException e) {
            this.prompt(String.format("Unknown host: %s", e.getMessage()), e);
        }
        catch (IOException e) {
            String details = StringUtil.isEmpty((String)e.getMessage()) ? "Unable to download Android Studio components." : e.getMessage();
            this.prompt(details, e);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (RuntimeException e) {
            String details = StringUtil.isEmpty((String)e.getMessage()) ? "Unable to download Android Studio components." : e.getMessage();
            this.prompt(details, e);
        }
        return false;
    }

    private void prompt(String details, Exception e) throws WizardException {
        this.promptToRetry(details + "\n\nPlease check your Internet connection and retry.", details, e);
    }

    @Override
    public void cleanup(@NotNull File result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/welcome/install/DownloadOperation", "cleanup"));
        }
        if (result.isFile() && FileUtil.isAncestor((File)result, (File)this.myContext.getTempDirectory(), (boolean)false)) {
            FileUtil.delete((File)result);
        }
    }
}

