/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.sdklib.devices.Storage;
import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.NoPreviewRevision;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.descriptors.IdDisplay;
import com.android.sdklib.repository.descriptors.PkgDesc;
import com.android.sdklib.repository.descriptors.PkgType;
import com.android.tools.idea.sdk.remote.RemotePkgInfo;
import com.android.tools.idea.welcome.install.FirstRunWizardDefaults;
import com.android.tools.idea.welcome.install.InstallContext;
import com.android.tools.idea.welcome.install.InstallableComponent;
import com.android.tools.idea.welcome.install.WizardException;
import com.android.tools.idea.welcome.wizard.HaxmInstallSettingsStep;
import com.android.tools.idea.welcome.wizard.ProgressStep;
import com.android.tools.idea.wizard.dynamic.DynamicWizardStep;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Platform;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingAnsiEscapesAwareProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Haxm
extends InstallableComponent {
    public static final Storage.Unit UI_UNITS = Storage.Unit.MiB;
    public static final Logger LOG = Logger.getInstance(Haxm.class);
    public static final IdDisplay ID_INTEL = new IdDisplay("intel", "");
    public static final String COMPONENT_PATH = "Hardware_Accelerated_Execution_Manager";
    public static final String RUNNING_INTEL_HAXM_INSTALLER_MESSAGE = "Running Intel\u00ae HAXM installer";
    private static final ScopedStateStore.Key<Integer> KEY_EMULATOR_MEMORY_MB = ScopedStateStore.createKey("emulator.memory", ScopedStateStore.Scope.PATH, Integer.class);
    private static long myMemorySize = -1L;
    private final ScopedStateStore.Key<Boolean> myIsCustomInstall;
    private ProgressStep myProgressStep;

    public static FullRevision getInstalledVersion(@NotNull File sdk) throws WizardException {
        GeneralCommandLine command;
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/android/tools/idea/welcome/install/Haxm", "getInstalledVersion"));
        }
        String path = FileUtil.join((String[])new String[]{"extras", ID_INTEL.getId(), COMPONENT_PATH});
        File sourceLocation = new File(sdk, path);
        if (SystemInfo.isMac) {
            command = Haxm.addVersionParameters(Haxm.getMacHaxmCommandLine(sourceLocation));
        } else if (SystemInfo.isWindows) {
            command = Haxm.addVersionParameters(Haxm.getWindowsHaxmCommandLine(sourceLocation));
        } else {
            assert (!Haxm.canRun());
            throw new IllegalStateException("Unsupported OS");
        }
        try {
            CapturingAnsiEscapesAwareProcessHandler process = new CapturingAnsiEscapesAwareProcessHandler(command);
            return FullRevision.parseRevision((String)process.runProcess().getStdout());
        }
        catch (NumberFormatException e) {
            LOG.warn("Invalid HAXM version found.", (Throwable)e);
            return new FullRevision(0);
        }
        catch (ExecutionException e) {
            throw new WizardException("Failed to get HAXM version", e);
        }
    }

    public static boolean canRun() {
        if ((Boolean.getBoolean("install.haxm") && SystemInfo.isWindows || SystemInfo.isMac) && Haxm.isSupportedProcessor()) {
            return Haxm.getMemorySize() >= Storage.Unit.GiB.getNumberOfBytes();
        }
        return false;
    }

    private static boolean isSupportedProcessor() {
        String id;
        if (SystemInfo.isMac) {
            return true;
        }
        return SystemInfo.isWindows && (id = System.getenv().get("PROCESSOR_IDENTIFIER")) != null && id.contains("GenuineIntel");
    }

    public Haxm(@NotNull ScopedStateStore store, ScopedStateStore.Key<Boolean> isCustomInstall) {
        if (store == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "store", "com/android/tools/idea/welcome/install/Haxm", "<init>"));
        }
        super(store, "Performance (Intel \u00ae HAXM)", 0x233333L, "Enables a hardware-assisted virtualization engine (hypervisor) to speed up Android app emulation on your development computer. (Recommended)");
        this.myIsCustomInstall = isCustomInstall;
    }

    @NotNull
    private GeneralCommandLine addInstallParameters(@NotNull GeneralCommandLine cl, int memorySize) {
        if (cl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cl", "com/android/tools/idea/welcome/install/Haxm", "addInstallParameters"));
        }
        cl.addParameters(new String[]{"-m", String.valueOf(memorySize)});
        GeneralCommandLine generalCommandLine = cl;
        if (generalCommandLine == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/install/Haxm", "addInstallParameters"));
        }
        return generalCommandLine;
    }

    @NotNull
    private static GeneralCommandLine addVersionParameters(@NotNull GeneralCommandLine cl) {
        if (cl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cl", "com/android/tools/idea/welcome/install/Haxm", "addVersionParameters"));
        }
        cl.addParameters(new String[]{"-v"});
        GeneralCommandLine generalCommandLine = cl;
        if (generalCommandLine == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/install/Haxm", "addVersionParameters"));
        }
        return generalCommandLine;
    }

    private static GeneralCommandLine getMacHaxmCommandLine(File path) throws WizardException {
        Haxm.ensureExistsAndIsExecutable(path, "silent_install.sh");
        File executable = Haxm.ensureExistsAndIsExecutable(path, "HAXM installation");
        return new GeneralCommandLine(new String[]{executable.getAbsolutePath()}).withWorkDirectory(path);
    }

    @NotNull
    private static File ensureExistsAndIsExecutable(File path, String exeName) throws WizardException {
        File executable = new File(path, exeName);
        if (!executable.isFile()) {
            throw new WizardException("HAXM installer executable is missing: " + executable.getAbsolutePath());
        }
        if (executable.canExecute() || executable.setExecutable(true)) {
            File file = executable;
            if (file == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/install/Haxm", "ensureExistsAndIsExecutable"));
            }
            return file;
        }
        throw new WizardException("Unable to set execute permission bit on HAXM installer executable: " + executable.getAbsolutePath());
    }

    @NotNull
    private static GeneralCommandLine getWindowsHaxmCommandLine(File source) {
        File batFile = new File(source, "silent_install.bat");
        GeneralCommandLine generalCommandLine = new GeneralCommandLine(new String[]{batFile.getAbsolutePath()}).withWorkDirectory(source);
        if (generalCommandLine == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/install/Haxm", "getWindowsHaxmCommandLine"));
        }
        return generalCommandLine;
    }

    private static int getRecommendedMemoryAllocation() {
        return FirstRunWizardDefaults.getRecommendedHaxmMemory(Haxm.getMemorySize());
    }

    public static long getMemorySize() {
        if (myMemorySize < 0L) {
            myMemorySize = Haxm.checkMemorySize();
        }
        return myMemorySize;
    }

    private static long checkMemorySize() {
        OperatingSystemMXBean osMXBean = ManagementFactory.getOperatingSystemMXBean();
        try {
            Class<?> oracleSpecificMXBean = Class.forName("com.sun.management.OperatingSystemMXBean");
            Method getPhysicalMemorySizeMethod = oracleSpecificMXBean.getMethod("getTotalPhysicalMemorySize", new Class[0]);
            Object result = getPhysicalMemorySizeMethod.invoke((Object)osMXBean, new Object[0]);
            if (result instanceof Number) {
                return ((Number)result).longValue();
            }
        }
        catch (ClassNotFoundException oracleSpecificMXBean) {
        }
        catch (NoSuchMethodException oracleSpecificMXBean) {
        }
        catch (InvocationTargetException e) {
            LOG.error((Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOG.error((Throwable)e);
        }
        return 32L * Storage.Unit.GiB.getNumberOfBytes();
    }

    @NotNull
    private static IPkgDesc createExtra(@NotNull IdDisplay vendor, @NotNull String path) {
        if (vendor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vendor", "com/android/tools/idea/welcome/install/Haxm", "createExtra"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/welcome/install/Haxm", "createExtra"));
        }
        IPkgDesc iPkgDesc = PkgDesc.Builder.newExtra((IdDisplay)vendor, (String)path, (String)"", null, (NoPreviewRevision)new NoPreviewRevision(0)).create();
        if (iPkgDesc == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/install/Haxm", "createExtra"));
        }
        return iPkgDesc;
    }

    @Override
    public void init(@NotNull ProgressStep progressStep) {
        if (progressStep == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressStep", "com/android/tools/idea/welcome/install/Haxm", "init"));
        }
        this.myProgressStep = progressStep;
        this.myStateStore.put(KEY_EMULATOR_MEMORY_MB, Haxm.getRecommendedMemoryAllocation());
    }

    @Override
    @NotNull
    public Collection<DynamicWizardStep> createSteps() {
        Set<DynamicWizardStep> set = Collections.singleton(new HaxmInstallSettingsStep(this.myIsCustomInstall, this.myKey, KEY_EMULATOR_MEMORY_MB));
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/install/Haxm", "createSteps"));
        }
        return set;
    }

    @Override
    public void configure(@NotNull InstallContext installContext, @NotNull File sdk) {
        if (installContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "installContext", "com/android/tools/idea/welcome/install/Haxm", "configure"));
        }
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/android/tools/idea/welcome/install/Haxm", "configure"));
        }
        if (!Haxm.canRun()) {
            Logger.getInstance(this.getClass()).error(String.format("Tried to install HAXM on %s OS with %s memory size", Platform.current().name(), String.valueOf(Haxm.getMemorySize())));
            installContext.print("Unable to install Intel HAXM\n", ConsoleViewContentType.ERROR_OUTPUT);
            return;
        }
        try {
            GeneralCommandLine commandLine = this.getInstallCommandLine(sdk);
            this.runInstaller(installContext, commandLine);
        }
        catch (WizardException e) {
            String message = e.getMessage();
            if (!StringUtil.endsWithLineBreak((CharSequence)message)) {
                message = message + "\n";
            }
            installContext.print(message, ConsoleViewContentType.ERROR_OUTPUT);
            LOG.error((Throwable)e);
        }
    }

    private void runInstaller(InstallContext installContext, GeneralCommandLine commandLine) {
        try {
            ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
            progressIndicator.setIndeterminate(true);
            progressIndicator.setText(RUNNING_INTEL_HAXM_INSTALLER_MESSAGE);
            installContext.print("Running Intel\u00ae HAXM installer\n", ConsoleViewContentType.SYSTEM_OUTPUT);
            CapturingAnsiEscapesAwareProcessHandler process = new CapturingAnsiEscapesAwareProcessHandler(commandLine);
            final StringBuffer output = new StringBuffer();
            process.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void onTextAvailable(ProcessEvent event, Key outputType) {
                    output.append(event.getText());
                    super.onTextAvailable(event, outputType);
                }
            });
            this.myProgressStep.attachToProcess((ProcessHandler)process);
            int exitCode = process.runProcess().getExitCode();
            if (exitCode != 0) {
                installContext.print(String.format("HAXM installation failed. To install HAXM follow the instructions found at: %s", SystemInfo.isWindows ? "https://software.intel.com/android/articles/installation-instructions-for-intel-hardware-accelerated-execution-manager-windows" : "https://software.intel.com/android/articles/installation-instructions-for-intel-hardware-accelerated-execution-manager-mac-os-x"), ConsoleViewContentType.ERROR_OUTPUT);
                Matcher m = Pattern.compile("installation log:\\s*\"(.*)\"").matcher(output.toString());
                if (m.find()) {
                    String file = m.group(1);
                    try {
                        installContext.print("Installer log:\n", ConsoleViewContentType.ERROR_OUTPUT);
                        installContext.print(FileUtil.loadFile((File)new File(file), (String)"UTF-16"), ConsoleViewContentType.NORMAL_OUTPUT);
                    }
                    catch (IOException e) {
                        installContext.print("Failed to read installer output log.\n", ConsoleViewContentType.ERROR_OUTPUT);
                    }
                }
            }
            progressIndicator.setFraction(1.0);
        }
        catch (ExecutionException e) {
            installContext.print("Unable to run Intel HAXM installer: " + e.getMessage() + "\n", ConsoleViewContentType.ERROR_OUTPUT);
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    private GeneralCommandLine getInstallCommandLine(File sdk) throws WizardException {
        int memorySize = this.myStateStore.getNotNull(KEY_EMULATOR_MEMORY_MB, Haxm.getRecommendedMemoryAllocation());
        String path = FileUtil.join((String[])new String[]{"extras", ID_INTEL.getId(), COMPONENT_PATH});
        File sourceLocation = new File(sdk, path);
        if (SystemInfo.isMac) {
            GeneralCommandLine generalCommandLine = this.addInstallParameters(Haxm.getMacHaxmCommandLine(sourceLocation), memorySize);
            if (generalCommandLine == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/install/Haxm", "getInstallCommandLine"));
            }
            return generalCommandLine;
        }
        if (SystemInfo.isWindows) {
            GeneralCommandLine generalCommandLine = this.addInstallParameters(Haxm.getWindowsHaxmCommandLine(sourceLocation), memorySize);
            if (generalCommandLine == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/install/Haxm", "getInstallCommandLine"));
            }
            return generalCommandLine;
        }
        assert (!Haxm.canRun());
        throw new IllegalStateException("Unsupported OS");
    }

    @Override
    @NotNull
    public Collection<IPkgDesc> getRequiredSdkPackages(@Nullable Multimap<PkgType, RemotePkgInfo> remotePackages) {
        ImmutableList immutableList = ImmutableList.of((Object)Haxm.createExtra(ID_INTEL, COMPONENT_PATH));
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/install/Haxm", "getRequiredSdkPackages"));
        }
        return immutableList;
    }
}

