/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.designSurface.layout.caption;

import com.intellij.android.designer.designSurface.layout.caption.HorizontalCaptionFlowBaseOperation;
import com.intellij.android.designer.model.RadComponentOperations;
import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.android.designer.model.layout.table.RadCaptionTableColumn;
import com.intellij.android.designer.model.layout.table.RadTableLayoutComponent;
import com.intellij.android.designer.model.layout.table.RadTableRowLayout;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.designSurface.OperationContext;
import com.intellij.designer.model.RadComponent;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class TableHorizontalCaptionOperation
extends HorizontalCaptionFlowBaseOperation<RadTableLayoutComponent> {
    public TableHorizontalCaptionOperation(RadTableLayoutComponent mainContainer, RadComponent container, OperationContext context, EditableArea mainArea) {
        super(mainContainer, container, context, mainArea);
    }

    protected void execute(@Nullable RadComponent insertBefore) throws Exception {
        List<RadComponent> rows = ((RadTableLayoutComponent)this.myMainContainer).getChildren();
        RadComponent[][] components = ((RadTableLayoutComponent)this.myMainContainer).getGridComponents(false);
        for (int i = 0; i < components.length; ++i) {
            RadViewComponent container = (RadViewComponent)rows.get(i);
            if (!RadTableRowLayout.is((RadComponent)container)) continue;
            RadComponent[] rowComponents = components[i];
            ArrayList<RadViewComponent> editComponents = new ArrayList<RadViewComponent>();
            for (RadComponent component : this.myComponents) {
                int column = ((RadCaptionTableColumn)component).getIndex();
                RadViewComponent editComponent = (RadViewComponent)rowComponents[column];
                if (editComponent == null) continue;
                editComponents.add(editComponent);
            }
            if (editComponents.isEmpty()) continue;
            RadViewComponent insertBeforeColumn = null;
            if (insertBefore != null) {
                int column;
                for (int j = column = ((RadCaptionTableColumn)insertBefore).getIndex(); j < rowComponents.length; ++j) {
                    insertBeforeColumn = (RadViewComponent)rowComponents[j];
                    if (insertBeforeColumn == null) continue;
                    if (editComponents.isEmpty() || insertBeforeColumn != editComponents.get(0)) break;
                    editComponents.remove(0);
                    insertBeforeColumn = null;
                }
            }
            if (insertBefore != null && insertBeforeColumn == null) continue;
            for (RadViewComponent component : editComponents) {
                if (component == insertBeforeColumn) continue;
                RadComponentOperations.moveComponent(container, component, insertBeforeColumn);
            }
        }
        for (RadComponent component : this.myComponents) {
            component.removeFromParent();
            this.myContainer.add(component, insertBefore);
        }
        List columns = this.myContainer.getChildren();
        int size = columns.size();
        for (int i = 0; i < size; ++i) {
            int index = ((RadCaptionTableColumn)((Object)columns.get(i))).getIndex();
            for (int j = 0; j < components.length; ++j) {
                RadComponent cellComponent;
                if (!RadTableRowLayout.is(rows.get(j)) || (cellComponent = components[j][index]) == null) continue;
                RadTableLayoutComponent.setCellIndex(cellComponent, i);
            }
        }
    }
}

