/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.ddms.adb.AdbService;
import com.android.tools.idea.model.AndroidModel;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.execution.ExecutionHelper;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.remote.RemoteConfiguration;
import com.intellij.execution.remote.RemoteConfigurationType;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.JBDefaultTreeCellRenderer;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.content.Content;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.HashSet;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.android.compiler.AndroidCompileUtil;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidProcessChooserDialog
extends DialogWrapper {
    @NonNls
    private static final String DEBUGGABLE_PROCESS_PROPERTY = "DEBUGGABLE_PROCESS";
    @NonNls
    private static final String SHOW_ALL_PROCESSES_PROPERTY = "SHOW_ALL_PROCESSES";
    @NonNls
    private static final String DEBUGGABLE_DEVICE_PROPERTY = "DEBUGGABLE_DEVICE";
    @NonNls
    private static final String RUN_CONFIGURATION_NAME_PATTERN = "Android Debugger (%s)";
    private final Project myProject;
    private JPanel myContentPanel;
    private Tree myProcessTree;
    private JBCheckBox myShowAllProcessesCheckBox;
    private String myLastSelectedDevice;
    private String myLastSelectedProcess;
    private final MergingUpdateQueue myUpdatesQueue;
    private final AndroidDebugBridge.IClientChangeListener myClientChangeListener;
    private final AndroidDebugBridge.IDeviceChangeListener myDeviceChangeListener;

    protected AndroidProcessChooserDialog(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/actions/AndroidProcessChooserDialog", "<init>"));
        }
        super(project);
        this.$$$setupUI$$$();
        this.setTitle("Choose Process");
        this.myProject = project;
        this.myUpdatesQueue = new MergingUpdateQueue("AndroidProcessChooserDialogUpdatingQueue", 500, true, MergingUpdateQueue.ANY_COMPONENT, (Disposable)this.myProject);
        String showAllProcessesStr = PropertiesComponent.getInstance((Project)project).getValue(SHOW_ALL_PROCESSES_PROPERTY);
        boolean showAllProcesses = Boolean.parseBoolean(showAllProcessesStr);
        this.myShowAllProcessesCheckBox.setSelected(showAllProcesses);
        this.doUpdateTree(showAllProcesses);
        this.myClientChangeListener = new AndroidDebugBridge.IClientChangeListener(){

            public void clientChanged(Client client, int changeMask) {
                AndroidProcessChooserDialog.this.updateTree();
            }
        };
        AndroidDebugBridge.addClientChangeListener((AndroidDebugBridge.IClientChangeListener)this.myClientChangeListener);
        this.myDeviceChangeListener = new AndroidDebugBridge.IDeviceChangeListener(){

            public void deviceConnected(IDevice device) {
                AndroidProcessChooserDialog.this.updateTree();
            }

            public void deviceDisconnected(IDevice device) {
                AndroidProcessChooserDialog.this.updateTree();
            }

            public void deviceChanged(IDevice device, int changeMask) {
                AndroidProcessChooserDialog.this.updateTree();
            }
        };
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this.myDeviceChangeListener);
        this.myShowAllProcessesCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AndroidProcessChooserDialog.this.updateTree();
            }
        });
        this.myProcessTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                IDevice selectedDevice = AndroidProcessChooserDialog.this.getSelectedDevice();
                Client selectedClient = AndroidProcessChooserDialog.this.getSelectedClient();
                AndroidProcessChooserDialog.this.myLastSelectedDevice = AndroidProcessChooserDialog.getPersistableName(selectedDevice);
                AndroidProcessChooserDialog.this.myLastSelectedProcess = AndroidProcessChooserDialog.getPersistableName(selectedClient);
                AndroidProcessChooserDialog.this.getOKAction().setEnabled(selectedDevice != null && selectedClient != null);
            }
        });
        new TreeSpeedSearch((JTree)this.myProcessTree){

            protected boolean isMatchingElement(Object element, String pattern) {
                Object userObject;
                Object lastComponent;
                if (element instanceof TreePath && (lastComponent = ((TreePath)element).getLastPathComponent()) instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)lastComponent).getUserObject()) instanceof Client) {
                    String pkg = ((Client)userObject).getClientData().getClientDescription();
                    return pkg != null && pkg.contains(pattern);
                }
                return false;
            }
        };
        this.myProcessTree.setCellRenderer((TreeCellRenderer)new JBDefaultTreeCellRenderer((JTree)this.myProcessTree){

            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (value instanceof DefaultMutableTreeNode) {
                    Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
                    if (userObject instanceof IDevice) {
                        value = ((IDevice)userObject).getName();
                    } else if (userObject instanceof Client) {
                        ClientData clientData = ((Client)userObject).getClientData();
                        String description = clientData.getClientDescription();
                        if (clientData.isValidUserId() && clientData.getUserId() != 0) {
                            description = description + " (user " + Integer.toString(clientData.getUserId()) + ")";
                        }
                        value = description;
                    }
                }
                return super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            }

            public Icon getLeafIcon() {
                return null;
            }

            public Icon getOpenIcon() {
                return null;
            }

            public Icon getClosedIcon() {
                return null;
            }
        });
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent event) {
                if (AndroidProcessChooserDialog.this.isOKActionEnabled()) {
                    AndroidProcessChooserDialog.this.doOKAction();
                    return true;
                }
                return false;
            }
        }.installOn((Component)this.myProcessTree);
        this.myProcessTree.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && AndroidProcessChooserDialog.this.isOKActionEnabled()) {
                    AndroidProcessChooserDialog.this.doOKAction();
                }
            }
        });
        PropertiesComponent properties = PropertiesComponent.getInstance((Project)this.myProject);
        this.myLastSelectedProcess = properties.getValue(DEBUGGABLE_PROCESS_PROPERTY);
        this.myLastSelectedDevice = properties.getValue(DEBUGGABLE_DEVICE_PROPERTY);
        this.init();
    }

    @NotNull
    private static String getPersistableName(@Nullable Client client) {
        String string = client == null ? "" : client.getClientData().getClientDescription();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/actions/AndroidProcessChooserDialog", "getPersistableName"));
        }
        return string;
    }

    @NotNull
    private static String getPersistableName(@Nullable IDevice device) {
        String string = device == null ? "" : device.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/actions/AndroidProcessChooserDialog", "getPersistableName"));
        }
        return string;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myProcessTree;
    }

    protected void dispose() {
        super.dispose();
        AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this.myDeviceChangeListener);
        AndroidDebugBridge.removeClientChangeListener((AndroidDebugBridge.IClientChangeListener)this.myClientChangeListener);
    }

    private void updateTree() {
        final boolean showAllProcesses = this.myShowAllProcessesCheckBox.isSelected();
        this.myUpdatesQueue.queue(new Update((Object)this){

            public void run() {
                AndroidDebugBridge debugBridge = AndroidSdkUtils.getDebugBridge(AndroidProcessChooserDialog.this.myProject);
                if (debugBridge != null && AdbService.isDdmsCorrupted(debugBridge)) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Messages.showErrorDialog((Component)AndroidProcessChooserDialog.this.myContentPanel, (String)AndroidBundle.message("ddms.corrupted.error", new Object[0]));
                            AndroidProcessChooserDialog.this.close(1);
                        }
                    });
                    return;
                }
                AndroidProcessChooserDialog.this.doUpdateTree(showAllProcesses);
            }

            public boolean canEat(Update update) {
                return true;
            }
        });
    }

    private void doUpdateTree(boolean showAllProcesses) {
        IDevice[] devices;
        AndroidDebugBridge debugBridge = AndroidSdkUtils.getDebugBridge(this.myProject);
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        final DefaultTreeModel model = new DefaultTreeModel(root);
        if (debugBridge == null) {
            this.myProcessTree.setModel((TreeModel)model);
            return;
        }
        Set<String> processNames = AndroidProcessChooserDialog.collectAllProcessNames(this.myProject);
        DefaultMutableTreeNode selectedDeviceNode = null;
        DefaultMutableTreeNode selectedClientNode = null;
        Object[] firstTreePath = null;
        for (IDevice device : devices = debugBridge.getDevices()) {
            DefaultMutableTreeNode deviceNode = new DefaultMutableTreeNode(device);
            root.add(deviceNode);
            String deviceName = device.getName();
            if (deviceName.equals(this.myLastSelectedDevice)) {
                selectedDeviceNode = deviceNode;
            }
            for (Client client : device.getClients()) {
                String clientDescription = client.getClientData().getClientDescription();
                if (clientDescription == null || !showAllProcesses && !AndroidProcessChooserDialog.isRelatedProcess(processNames, clientDescription)) continue;
                DefaultMutableTreeNode clientNode = new DefaultMutableTreeNode(client);
                deviceNode.add(clientNode);
                if (clientDescription.equals(this.myLastSelectedProcess) && (selectedDeviceNode == null || deviceName.equals(this.myLastSelectedDevice))) {
                    selectedClientNode = clientNode;
                    selectedDeviceNode = deviceNode;
                }
                if (firstTreePath != null) continue;
                firstTreePath = new Object[]{root, deviceNode, clientNode};
            }
        }
        final Object[] pathToSelect = selectedDeviceNode != null && selectedClientNode != null ? new Object[]{root, selectedDeviceNode, selectedClientNode} : (selectedDeviceNode != null ? new Object[]{root, selectedDeviceNode} : firstTreePath);
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                AndroidProcessChooserDialog.this.myProcessTree.setModel((TreeModel)model);
                if (pathToSelect != null) {
                    AndroidProcessChooserDialog.this.myProcessTree.getSelectionModel().setSelectionPath(new TreePath(pathToSelect));
                } else {
                    AndroidProcessChooserDialog.this.getOKAction().setEnabled(false);
                }
                TreeUtil.expandAll((JTree)AndroidProcessChooserDialog.this.myProcessTree);
            }
        });
    }

    private static boolean isRelatedProcess(Set<String> processNames, String clientDescription) {
        String lc = clientDescription.toLowerCase();
        for (String processName : processNames) {
            if (!lc.startsWith(processName)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static Set<String> collectAllProcessNames(Project project) {
        List facets = ProjectFacetManager.getInstance((Project)project).getFacets(AndroidFacet.ID);
        HashSet result = new HashSet();
        for (AndroidFacet facet : facets) {
            AndroidModel androidModel;
            XmlElement xmlElement;
            Manifest manifest;
            String packageName = AndroidCompileUtil.getAaptManifestPackage(facet);
            if (packageName != null) {
                result.add(packageName.toLowerCase());
            }
            if ((manifest = facet.getManifest()) != null && (xmlElement = manifest.getXmlElement()) != null) {
                AndroidProcessChooserDialog.collectProcessNames(xmlElement, (Set<String>)result);
            }
            if ((androidModel = facet.getAndroidModel()) == null) continue;
            result.addAll(androidModel.getAllApplicationIds());
        }
        HashSet hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/actions/AndroidProcessChooserDialog", "collectAllProcessNames"));
        }
        return hashSet;
    }

    private static void collectProcessNames(XmlElement xmlElement, final Set<String> result) {
        xmlElement.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

            public void visitXmlAttribute(XmlAttribute attribute) {
                String value;
                if ("process".equals(attribute.getLocalName()) && (value = attribute.getValue()) != null) {
                    result.add(value.toLowerCase());
                }
            }
        });
    }

    protected JComponent createCenterPanel() {
        return this.myContentPanel;
    }

    protected void doOKAction() {
        PropertiesComponent properties = PropertiesComponent.getInstance((Project)this.myProject);
        IDevice selectedDevice = this.getSelectedDevice();
        if (selectedDevice == null) {
            return;
        }
        Client selectedClient = this.getSelectedClient();
        if (selectedClient == null) {
            return;
        }
        super.doOKAction();
        properties.setValue(DEBUGGABLE_DEVICE_PROPERTY, AndroidProcessChooserDialog.getPersistableName(selectedDevice));
        properties.setValue(DEBUGGABLE_PROCESS_PROPERTY, AndroidProcessChooserDialog.getPersistableName(selectedClient));
        properties.setValue(SHOW_ALL_PROCESSES_PROPERTY, Boolean.toString(this.myShowAllProcessesCheckBox.isSelected()));
        String debugPort = Integer.toString(selectedClient.getDebuggerListenPort());
        this.closeOldSessionAndRun(debugPort);
    }

    protected String getDimensionServiceKey() {
        return "AndroidProcessChooserDialog";
    }

    private void closeOldSessionAndRun(String debugPort) {
        final String configurationName = AndroidProcessChooserDialog.getRunConfigurationName(debugPort);
        Collection<Object> descriptors = null;
        Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
        Project targetProject = null;
        for (Project project : openProjects) {
            targetProject = project;
            descriptors = ExecutionHelper.findRunningConsoleByTitle((Project)targetProject, (NotNullFunction)new NotNullFunction<String, Boolean>(){

                @NotNull
                public Boolean fun(String title) {
                    Boolean bl = configurationName.equals(title);
                    if (bl == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/actions/AndroidProcessChooserDialog$12", "fun"));
                    }
                    return bl;
                }
            });
            if (descriptors.isEmpty()) {
                for (DebuggerSession session : DebuggerManagerEx.getInstanceEx((Project)targetProject).getSessions()) {
                    if (!debugPort.trim().equals(session.getProcess().getConnection().getAddress().trim()) || session.getXDebugSession() == null) continue;
                    descriptors = Collections.singletonList(session.getXDebugSession().getRunContentDescriptor());
                    break;
                }
            }
            if (!descriptors.isEmpty()) break;
        }
        if (descriptors != null && !descriptors.isEmpty()) {
            RunContentDescriptor descriptor = (RunContentDescriptor)descriptors.iterator().next();
            ProcessHandler processHandler = descriptor.getProcessHandler();
            Content content = descriptor.getAttachedContent();
            if (processHandler != null && content != null) {
                Executor executor = DefaultDebugExecutor.getDebugExecutorInstance();
                if (processHandler.isProcessTerminated()) {
                    ExecutionManager.getInstance((Project)targetProject).getContentManager().removeRunContent(executor, descriptor);
                } else {
                    if (targetProject != this.myProject) {
                        JFrame targetFrame = WindowManager.getInstance().getFrame(targetProject);
                        boolean alwaysOnTop = targetFrame.isAlwaysOnTop();
                        targetFrame.setExtendedState(0);
                        targetFrame.setAlwaysOnTop(true);
                        targetFrame.toFront();
                        targetFrame.requestFocus();
                        targetFrame.setAlwaysOnTop(alwaysOnTop);
                    }
                    content.getManager().setSelectedContent(content);
                    ToolWindow window = ToolWindowManager.getInstance((Project)targetProject).getToolWindow(executor.getToolWindowId());
                    window.activate(null, false, true);
                    return;
                }
            }
        }
        this.runSession(debugPort);
    }

    private void runSession(String debugPort) {
        RunnerAndConfigurationSettings settings = AndroidProcessChooserDialog.createRunConfiguration(this.myProject, debugPort);
        ProgramRunnerUtil.executeConfiguration((Project)this.myProject, (RunnerAndConfigurationSettings)settings, (Executor)DefaultDebugExecutor.getDebugExecutorInstance());
    }

    private static RunnerAndConfigurationSettings createRunConfiguration(Project project, String debugPort) {
        RemoteConfigurationType remoteConfigurationType = RemoteConfigurationType.getInstance();
        ConfigurationFactory factory = remoteConfigurationType.getFactory();
        RunnerAndConfigurationSettings runSettings = RunManager.getInstance((Project)project).createRunConfiguration(AndroidProcessChooserDialog.getRunConfigurationName(debugPort), factory);
        RemoteConfiguration configuration = (RemoteConfiguration)runSettings.getConfiguration();
        configuration.HOST = "localhost";
        configuration.PORT = debugPort;
        configuration.USE_SOCKET_TRANSPORT = true;
        configuration.SERVER_MODE = false;
        return runSettings;
    }

    @NotNull
    private static String getRunConfigurationName(String debugPort) {
        String string = String.format(RUN_CONFIGURATION_NAME_PATTERN, debugPort);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/actions/AndroidProcessChooserDialog", "getRunConfigurationName"));
        }
        return string;
    }

    @Nullable
    private IDevice getSelectedDevice() {
        TreePath selectionPath = this.myProcessTree.getSelectionPath();
        if (selectionPath == null || selectionPath.getPathCount() < 2) {
            return null;
        }
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)selectionPath.getPathComponent(1);
        Object obj = selectedNode.getUserObject();
        return obj instanceof IDevice ? (IDevice)obj : null;
    }

    @Nullable
    private Client getSelectedClient() {
        TreePath selectionPath = this.myProcessTree.getSelectionPath();
        if (selectionPath == null || selectionPath.getPathCount() < 3) {
            return null;
        }
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)selectionPath.getPathComponent(2);
        Object obj = selectedNode.getUserObject();
        return obj instanceof Client ? (Client)obj : null;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        Tree tree;
        JPanel jPanel;
        this.myContentPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Select a process to debug:");
        jBLabel.setDisplayedMnemonic('S');
        jBLabel.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(250, 300), null));
        this.myProcessTree = tree = new Tree();
        tree.setShowsRootHandles(true);
        tree.setRootVisible(false);
        jBScrollPane.setViewportView((Component)tree);
        this.myShowAllProcessesCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Show all processes");
        jBCheckBox.setMnemonic('A');
        jBCheckBox.setDisplayedMnemonicIndex(5);
        jPanel.add((Component)jBCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        jBLabel.setLabelFor((Component)jBScrollPane);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPanel;
    }
}

