/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.attrs;

import com.android.resources.ResourceType;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.intellij.util.xml.ResolvingConverter;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.android.dom.AndroidDomUtil;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeFormat;
import org.jetbrains.android.dom.converters.LightFlagConverter;
import org.jetbrains.android.dom.converters.PackageClassConverter;
import org.jetbrains.android.dom.converters.ResourceReferenceConverter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToolsAttributeUtil {
    private static final ResolvingConverter LAYOUT_REFERENCE_CONVERTER = new ResourceReferenceConverter(Collections.singleton(ResourceType.LAYOUT.getName()));
    private static final ResolvingConverter ACTIVITY_CLASS_CONVERTER = new PackageClassConverter(true, "android.app.Activity");
    private static final ResolvingConverter ACTION_BAR_MODE_FLAGS_CONVERTER = new LightFlagConverter("standard", "list", "tabs");
    private static final ImmutableMultimap<String, AttributeFormat> ATTRIBUTES = ImmutableMultimap.builder().putAll((Object)"actionBarMode", (Object[])new AttributeFormat[]{AttributeFormat.Flag}).putAll((Object)"context", (Object[])new AttributeFormat[]{AttributeFormat.Reference, AttributeFormat.String}).putAll((Object)"ignore", Collections.emptyList()).putAll((Object)"listfooter", (Object[])new AttributeFormat[]{AttributeFormat.Reference}).putAll((Object)"listheader", (Object[])new AttributeFormat[]{AttributeFormat.Reference}).putAll((Object)"listitem", (Object[])new AttributeFormat[]{AttributeFormat.Reference}).putAll((Object)"layout", (Object[])new AttributeFormat[]{AttributeFormat.Reference}).putAll((Object)"locale", Collections.emptyList()).putAll((Object)"menu", Collections.emptyList()).putAll((Object)"showIn", (Object[])new AttributeFormat[]{AttributeFormat.Reference}).putAll((Object)"targetApi", Collections.emptyList()).build();
    private static final ImmutableMap<String, ResolvingConverter> CONVERTERS = ImmutableMap.builder().put((Object)"actionBarMode", (Object)ACTION_BAR_MODE_FLAGS_CONVERTER).put((Object)"context", (Object)ACTIVITY_CLASS_CONVERTER).put((Object)"listfooter", (Object)LAYOUT_REFERENCE_CONVERTER).put((Object)"listheader", (Object)LAYOUT_REFERENCE_CONVERTER).put((Object)"listitem", (Object)LAYOUT_REFERENCE_CONVERTER).put((Object)"layout", (Object)LAYOUT_REFERENCE_CONVERTER).put((Object)"showIn", (Object)LAYOUT_REFERENCE_CONVERTER).build();

    @Nullable
    public static ResolvingConverter getConverter(@NotNull AttributeDefinition attrDef) {
        if (attrDef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrDef", "org/jetbrains/android/dom/attrs/ToolsAttributeUtil", "getConverter"));
        }
        String name = attrDef.getName();
        ResolvingConverter converter = (ResolvingConverter)CONVERTERS.get((Object)name);
        return converter != null ? converter : AndroidDomUtil.getConverter(attrDef);
    }

    @NotNull
    public static Set<String> getAttributeNames() {
        ImmutableSet immutableSet = ATTRIBUTES.keySet();
        if (immutableSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/attrs/ToolsAttributeUtil", "getAttributeNames"));
        }
        return immutableSet;
    }

    @Nullable
    public static AttributeDefinition getAttrDefByName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/android/dom/attrs/ToolsAttributeUtil", "getAttrDefByName"));
        }
        if (!ATTRIBUTES.containsKey((Object)name)) {
            return null;
        }
        ImmutableCollection formats = ATTRIBUTES.get((Object)name);
        AttributeDefinition def = new AttributeDefinition(name);
        def.addFormats((Collection<AttributeFormat>)formats);
        return def;
    }
}

