/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.repo;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Repository
extends Disposable {
    @NotNull
    public VirtualFile getRoot();

    @NotNull
    public String getPresentableUrl();

    @NotNull
    public Project getProject();

    @NotNull
    public State getState();

    @Nullable
    public String getCurrentBranchName();

    @NotNull
    public AbstractVcs getVcs();

    @Nullable
    public String getCurrentRevision();

    public boolean isFresh();

    public void update();

    @NotNull
    public String toLogString();

    public static enum State {
        NORMAL,
        MERGING{

            @NotNull
            public String toString() {
                if ("Merging" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/repo/Repository$State$1", "toString"));
                }
                return "Merging";
            }
        }
        ,
        REBASING{

            @NotNull
            public String toString() {
                if ("Rebasing" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/repo/Repository$State$2", "toString"));
                }
                return "Rebasing";
            }
        }
        ,
        GRAFTING{

            @NotNull
            public String toString() {
                if ("Grafting" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/repo/Repository$State$3", "toString"));
                }
                return "Grafting";
            }
        }
        ,
        DETACHED;

    }
}

