/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView;

import com.intellij.ide.projectView.RootsProvider;
import com.intellij.ide.projectView.SettingsProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiUtilCore;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProjectViewNode<Value>
extends AbstractTreeNode<Value>
implements RootsProvider,
SettingsProvider {
    protected static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.projectView.ProjectViewNode");
    private final ViewSettings mySettings;
    private boolean myValidating;

    protected ProjectViewNode(Project project, Value value, ViewSettings viewSettings) {
        super(project, value);
        this.mySettings = viewSettings;
    }

    public abstract boolean contains(@NotNull VirtualFile var1);

    @Override
    @Nullable
    public VirtualFile getVirtualFile() {
        return null;
    }

    @Override
    public final ViewSettings getSettings() {
        return this.mySettings;
    }

    public static List<AbstractTreeNode> wrap(Collection objects, Project project, Class<? extends AbstractTreeNode> nodeClass, ViewSettings settings) {
        try {
            ArrayList<AbstractTreeNode> result = new ArrayList<AbstractTreeNode>();
            for (Object object : objects) {
                result.add(ProjectViewNode.createTreeNode(nodeClass, project, object, settings));
            }
            return result;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return new ArrayList<AbstractTreeNode>();
        }
    }

    public static AbstractTreeNode createTreeNode(Class<? extends AbstractTreeNode> nodeClass, Project project, Object value, ViewSettings settings) throws InstantiationException {
        Object[] parameters = new Object[]{project, value, settings};
        for (Constructor<?> constructor : nodeClass.getConstructors()) {
            if (constructor.getParameterTypes().length != 3) continue;
            try {
                return (AbstractTreeNode)constructor.newInstance(parameters);
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        throw new InstantiationException("no constructor found in " + nodeClass);
    }

    public boolean someChildContainsFile(VirtualFile file) {
        return this.someChildContainsFile(file, true);
    }

    public boolean someChildContainsFile(VirtualFile file, boolean optimizeByCheckingFileRootsFirst) {
        VirtualFile parent = file.getParent();
        boolean mayContain = false;
        if (optimizeByCheckingFileRootsFirst && parent != null) {
            Collection<VirtualFile> roots = this.getRoots();
            for (VirtualFile eachRoot : roots) {
                if (parent.equals(eachRoot.getParent())) {
                    mayContain = true;
                } else {
                    if (!VfsUtilCore.isAncestor(eachRoot, file, true)) continue;
                    mayContain = true;
                }
                break;
            }
        } else {
            mayContain = true;
        }
        if (!mayContain) {
            return false;
        }
        Collection<AbstractTreeNode> kids = this.getChildren();
        for (AbstractTreeNode kid : kids) {
            ProjectViewNode node = (ProjectViewNode)kid;
            if (!node.contains(file)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getRoots() {
        Object value = this.getValue();
        if (value instanceof RootsProvider) {
            Collection<VirtualFile> collection = ((RootsProvider)value).getRoots();
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/ProjectViewNode", "getRoots"));
            }
            return collection;
        }
        if (value instanceof PsiFile) {
            PsiFile vFile = ((PsiFile)value).getContainingFile();
            if (vFile != null && vFile.getVirtualFile() != null) {
                Set<VirtualFile> set = Collections.singleton(vFile.getVirtualFile());
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/ProjectViewNode", "getRoots"));
                }
                return set;
            }
        } else {
            if (value instanceof VirtualFile) {
                Set<VirtualFile> set = Collections.singleton((VirtualFile)value);
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/ProjectViewNode", "getRoots"));
                }
                return set;
            }
            if (value instanceof PsiFileSystemItem) {
                Set<VirtualFile> set = Collections.singleton(((PsiFileSystemItem)value).getVirtualFile());
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/ProjectViewNode", "getRoots"));
                }
                return set;
            }
        }
        Set set = EMPTY_ROOTS;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/ProjectViewNode", "getRoots"));
        }
        return set;
    }

    @Override
    protected boolean hasProblemFileBeneath() {
        if (!Registry.is((String)"projectView.showHierarchyErrors")) {
            return false;
        }
        return WolfTheProblemSolver.getInstance(this.getProject()).hasProblemFilesBeneath(new Condition<VirtualFile>(){

            public boolean value(VirtualFile virtualFile) {
                Object value;
                return ProjectViewNode.this.contains(virtualFile) && ((value = ProjectViewNode.this.getValue()) instanceof PsiElement && Comparing.equal((Object)PsiUtilCore.getVirtualFile((PsiElement)value), (Object)virtualFile) || ProjectViewNode.this.someChildContainsFile(virtualFile));
            }
        });
    }

    public boolean canHaveChildrenMatching(Condition<PsiFile> condition) {
        return true;
    }

    @Nullable
    public String getTitle() {
        return null;
    }

    public boolean isSortByFirstChild() {
        return false;
    }

    public int getTypeSortWeight(boolean sortByType) {
        return 0;
    }

    @Nullable
    public Comparable getTypeSortKey() {
        return null;
    }

    @Nullable
    public Comparable getSortKey() {
        return null;
    }

    @Nullable
    public Comparable getManualOrderKey() {
        return null;
    }

    @Nullable
    public String getQualifiedNameSortKey() {
        return null;
    }

    public boolean shouldDrillDownOnEmptyElement() {
        return false;
    }

    public boolean validate() {
        this.setValidating(true);
        try {
            this.update();
        }
        finally {
            this.setValidating(false);
        }
        return this.getValue() != null;
    }

    @Override
    protected boolean shouldPostprocess() {
        return !this.isValidating();
    }

    @Override
    protected boolean shouldApply() {
        return !this.isValidating();
    }

    private void setValidating(boolean validating) {
        this.myValidating = validating;
    }

    public boolean isValidating() {
        return this.myValidating;
    }
}

