/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.diagnostic.ThreadDumper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.util.concurrency.Semaphore;

public class EnsureUpToDateFromNonAWTThread {
    private final Project myProject;
    private volatile boolean myDone;

    public EnsureUpToDateFromNonAWTThread(Project project) {
        this.myProject = project;
    }

    public void execute() {
        assert (!ApplicationManager.getApplication().isDispatchThread());
        final Semaphore lock = new Semaphore();
        lock.down();
        ChangeListManager.getInstance(this.myProject).invokeAfterUpdate(new Runnable(){

            @Override
            public void run() {
                EnsureUpToDateFromNonAWTThread.this.myDone = true;
                lock.up();
            }
        }, InvokeAfterUpdateMode.SILENT, null, null);
        if (this.myProject.isDisposed()) {
            return;
        }
        if (!lock.waitFor(100000L) && !this.myProject.isDisposed()) {
            System.out.println(ThreadDumper.dumpThreadsToString());
            throw new AssertionError((Object)"Couldn't wait for changes update");
        }
    }

    public boolean isDone() {
        return this.myDone;
    }
}

