/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.persistent;

import com.intellij.openapi.Forceable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.UnsyncByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class SmallMapSerializer<K, V>
implements Forceable {
    private final Map<KeyWrapper<K>, V> myMap;
    private final File myFile;
    private final KeyDescriptor<K> myKeyDescriptor;
    private final DataExternalizer<V> myValueExternalizer;
    private boolean myDirty;
    private Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.persistent.SmallMapSerializer");

    public SmallMapSerializer(File file, KeyDescriptor<K> keyDescriptor, DataExternalizer<V> valueExternalizer) {
        this.myFile = file;
        this.myKeyDescriptor = keyDescriptor;
        this.myValueExternalizer = valueExternalizer;
        this.myMap = new HashMap<KeyWrapper<K>, V>();
        this.init();
    }

    private void init() {
        try {
            byte[] bytes = FileUtil.loadFileBytes((File)this.myFile);
            DataInputStream dis = new DataInputStream((InputStream)new UnsyncByteArrayInputStream(bytes));
            int size = dis.readInt();
            for (int i = 0; i < size; ++i) {
                KeyWrapper keyWrapper = new KeyWrapper(this.myKeyDescriptor, this.myKeyDescriptor.read((DataInput)dis));
                Object value = this.myValueExternalizer.read((DataInput)dis);
                this.myMap.put(keyWrapper, value);
            }
        }
        catch (FileNotFoundException bytes) {
        }
        catch (IOException e) {
            this.LOG.error((Throwable)e);
        }
    }

    public void put(K key, V value) {
        this.myMap.put(new KeyWrapper(this.myKeyDescriptor, key), value);
        this.myDirty = true;
    }

    public V get(K key) {
        return this.myMap.get(new KeyWrapper(this.myKeyDescriptor, key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void force() {
        if (!this.myDirty) {
            return;
        }
        try {
            BufferExposingByteArrayOutputStream bos = new BufferExposingByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream((OutputStream)bos);
            out.writeInt(this.myMap.size());
            for (Map.Entry<KeyWrapper<K>, V> entry : this.myMap.entrySet()) {
                this.myKeyDescriptor.save((DataOutput)out, ((KeyWrapper)entry.getKey()).myKey);
                this.myValueExternalizer.save((DataOutput)out, entry.getValue());
            }
            FileUtil.writeToFile((File)this.myFile, (byte[])bos.getInternalBuffer(), (int)0, (int)bos.size());
        }
        catch (IOException e) {
            this.LOG.error((Throwable)e);
        }
        finally {
            this.myDirty = false;
        }
    }

    public boolean isDirty() {
        return this.myDirty;
    }

    public Collection<K> keySet() {
        ArrayList<Object> result = new ArrayList<Object>(this.myMap.size());
        for (KeyWrapper<K> keyWrapper : this.myMap.keySet()) {
            result.add(((KeyWrapper)keyWrapper).myKey);
        }
        return result;
    }

    private static class KeyWrapper<K> {
        private final K myKey;
        private final KeyDescriptor<K> myDescriptor;

        private KeyWrapper(@NotNull KeyDescriptor<K> descriptor, K key) {
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/openapi/vcs/persistent/SmallMapSerializer$KeyWrapper", "<init>"));
            }
            this.myDescriptor = descriptor;
            this.myKey = key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            KeyWrapper that = (KeyWrapper)o;
            return this.myDescriptor.isEqual(this.myKey, that.myKey);
        }

        public int hashCode() {
            return this.myDescriptor.getHashCode(this.myKey);
        }
    }
}

