/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.InspectionEP;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.deadCode.UnusedDeclarationInspection;
import com.intellij.codeInspection.deadCode.UnusedDeclarationPresentation;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.reference.EntryPoint;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.PathManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.testFramework.IdeaTestUtil;
import com.intellij.testFramework.InspectionTestUtil;
import com.intellij.testFramework.PsiTestCase;
import com.intellij.testFramework.PsiTestUtil;
import com.intellij.testFramework.fixtures.impl.CodeInsightTestFixtureImpl;
import com.intellij.testFramework.fixtures.impl.GlobalInspectionContextForTests;
import com.intellij.util.ArrayUtil;
import java.io.File;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class InspectionTestCase
extends PsiTestCase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.testFramework.InspectionTestCase");
    private EntryPoint myUnusedCodeExtension;
    private VirtualFile ext_src;

    protected static GlobalInspectionToolWrapper getUnusedDeclarationWrapper() {
        InspectionEP ep = new InspectionEP();
        ep.presentation = UnusedDeclarationPresentation.class.getName();
        ep.implementationClass = UnusedDeclarationInspection.class.getName();
        ep.shortName = "unused";
        return new GlobalInspectionToolWrapper(ep);
    }

    public InspectionManagerEx getManager() {
        return (InspectionManagerEx)InspectionManager.getInstance(this.myProject);
    }

    public void doTest(@NonNls String folderName, LocalInspectionTool tool) {
        this.doTest(folderName, (InspectionToolWrapper)new LocalInspectionToolWrapper(tool));
    }

    public void doTest(@NonNls String folderName, GlobalInspectionTool tool) {
        this.doTest(folderName, (InspectionToolWrapper)new GlobalInspectionToolWrapper(tool));
    }

    public void doTest(@NonNls String folderName, GlobalInspectionTool tool, boolean checkRange) {
        this.doTest(folderName, (InspectionToolWrapper)new GlobalInspectionToolWrapper(tool), checkRange);
    }

    public void doTest(@NonNls String folderName, GlobalInspectionTool tool, boolean checkRange, boolean runDeadCodeFirst) {
        this.doTest(folderName, (InspectionToolWrapper)new GlobalInspectionToolWrapper(tool), "java 1.4", checkRange, runDeadCodeFirst, new InspectionToolWrapper[0]);
    }

    public void doTest(@NonNls String folderName, InspectionToolWrapper tool) {
        this.doTest(folderName, tool, "java 1.4");
    }

    public void doTest(@NonNls String folderName, InspectionToolWrapper tool, boolean checkRange) {
        this.doTest(folderName, tool, "java 1.4", checkRange);
    }

    public void doTest(@NonNls String folderName, LocalInspectionTool tool, @NonNls String jdkName) {
        this.doTest(folderName, (InspectionToolWrapper)new LocalInspectionToolWrapper(tool), jdkName);
    }

    public void doTest(@NonNls String folderName, InspectionToolWrapper tool, @NonNls String jdkName) {
        this.doTest(folderName, tool, jdkName, false);
    }

    public void doTest(@NonNls String folderName, InspectionToolWrapper tool, @NonNls String jdkName, boolean checkRange) {
        this.doTest(folderName, tool, jdkName, checkRange, false, new InspectionToolWrapper[0]);
    }

    public void doTest(@NonNls String folderName, InspectionToolWrapper toolWrapper, @NonNls String jdkName, boolean checkRange, boolean runDeadCodeFirst, InspectionToolWrapper ... additional) {
        String testDir = this.getTestDataPath() + "/" + folderName;
        GlobalInspectionContextImpl context = this.runTool(testDir, jdkName, runDeadCodeFirst, toolWrapper, additional);
        InspectionTestUtil.compareToolResults((GlobalInspectionContextImpl)context, (InspectionToolWrapper)toolWrapper, (boolean)checkRange, (String)testDir);
    }

    protected void runTool(@NonNls String testDir, @NonNls String jdkName, InspectionToolWrapper tool) {
        this.runTool(testDir, jdkName, false, tool, new InspectionToolWrapper[0]);
    }

    protected GlobalInspectionContextImpl runTool(final String testDir, final String jdkName, boolean runDeadCodeFirst, @NotNull InspectionToolWrapper toolWrapper, InspectionToolWrapper ... additional) {
        Object[] objectArray;
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/testFramework/InspectionTestCase", "runTool"));
        }
        if (additional == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additional", "com/intellij/testFramework/InspectionTestCase", "runTool"));
        }
        final VirtualFile[] sourceDir = new VirtualFile[1];
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                try {
                    InspectionTestCase.this.setupRootModel(testDir, sourceDir, jdkName);
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            }
        });
        VirtualFile projectDir = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(testDir));
        AnalysisScope scope = this.createAnalysisScope(sourceDir[0].equals(projectDir) ? projectDir : sourceDir[0].getParent());
        InspectionManagerEx inspectionManager = (InspectionManagerEx)InspectionManager.getInstance(this.getProject());
        if (runDeadCodeFirst) {
            InspectionToolWrapper[] inspectionToolWrapperArray = new InspectionToolWrapper[2];
            inspectionToolWrapperArray[0] = InspectionTestCase.getUnusedDeclarationWrapper();
            objectArray = inspectionToolWrapperArray;
            inspectionToolWrapperArray[1] = toolWrapper;
        } else {
            Object[] objectArray2 = new InspectionToolWrapper[1];
            objectArray = objectArray2;
            objectArray2[0] = toolWrapper;
        }
        Object[] toolWrappers = objectArray;
        toolWrappers = (InspectionToolWrapper[])ArrayUtil.mergeArrays((Object[])toolWrappers, (Object[])additional);
        GlobalInspectionContextForTests globalContext = CodeInsightTestFixtureImpl.createGlobalContextForTool((AnalysisScope)scope, (Project)this.getProject(), (InspectionManagerEx)inspectionManager, (InspectionToolWrapper[])toolWrappers);
        InspectionTestUtil.runTool((InspectionToolWrapper)toolWrapper, (AnalysisScope)scope, (GlobalInspectionContextForTests)globalContext);
        return globalContext;
    }

    @NotNull
    protected AnalysisScope createAnalysisScope(VirtualFile sourceDir) {
        PsiManager psiManager = PsiManager.getInstance(this.myProject);
        AnalysisScope analysisScope = new AnalysisScope(psiManager.findDirectory(sourceDir));
        if (analysisScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/InspectionTestCase", "createAnalysisScope"));
        }
        return analysisScope;
    }

    protected void setupRootModel(String testDir, VirtualFile[] sourceDir, String sdkName) {
        VirtualFile projectDir = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(testDir));
        InspectionTestCase.assertNotNull((String)("could not find project dir " + testDir), (Object)projectDir);
        sourceDir[0] = projectDir.findChild("src");
        if (sourceDir[0] == null) {
            sourceDir[0] = projectDir;
        }
        PsiTestUtil.removeAllRoots((Module)this.myModule, (Sdk)this.getTestProjectSdk());
        PsiTestUtil.addContentRoot((Module)this.myModule, (VirtualFile)projectDir);
        PsiTestUtil.addSourceRoot((Module)this.myModule, (VirtualFile)sourceDir[0]);
        this.ext_src = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(testDir + "/ext_src"));
        if (this.ext_src != null) {
            PsiTestUtil.addSourceRoot((Module)this.myModule, (VirtualFile)this.ext_src);
        }
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        ExtensionPoint point = Extensions.getRootArea().getExtensionPoint("com.intellij.deadCode");
        this.myUnusedCodeExtension = new EntryPoint(){

            @Override
            @NotNull
            public String getDisplayName() {
                if ("duh" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/InspectionTestCase$2", "getDisplayName"));
                }
                return "duh";
            }

            @Override
            public boolean isEntryPoint(@NotNull RefElement refElement, @NotNull PsiElement psiElement) {
                if (refElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refElement", "com/intellij/testFramework/InspectionTestCase$2", "isEntryPoint"));
                }
                if (psiElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/testFramework/InspectionTestCase$2", "isEntryPoint"));
                }
                return this.isEntryPoint(psiElement);
            }

            @Override
            public boolean isEntryPoint(@NotNull PsiElement psiElement) {
                if (psiElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/testFramework/InspectionTestCase$2", "isEntryPoint"));
                }
                return InspectionTestCase.this.ext_src != null && VfsUtilCore.isAncestor(InspectionTestCase.this.ext_src, PsiUtilCore.getVirtualFile(psiElement), false);
            }

            @Override
            public boolean isSelected() {
                return false;
            }

            @Override
            public void setSelected(boolean selected) {
            }

            public void readExternal(Element element) {
            }

            public void writeExternal(Element element) {
            }
        };
        point.registerExtension((Object)this.myUnusedCodeExtension);
    }

    @Override
    protected void tearDown() throws Exception {
        ExtensionPoint point = Extensions.getRootArea().getExtensionPoint("com.intellij.deadCode");
        point.unregisterExtension((Object)this.myUnusedCodeExtension);
        this.myUnusedCodeExtension = null;
        this.ext_src = null;
        super.tearDown();
    }

    protected void setUpJdk() {
    }

    protected Sdk getTestProjectSdk() {
        Sdk sdk = IdeaTestUtil.getMockJdk17();
        LanguageLevelProjectExtension.getInstance(this.getProject()).setLanguageLevel(LanguageLevel.JDK_1_5);
        return sdk;
    }

    @Override
    @NonNls
    protected String getTestDataPath() {
        return PathManagerEx.getTestDataPath() + "/inspection/";
    }
}

