/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.MouseDragHelper;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.tabs.JBTabsPosition;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.impl.JBEditorTabs;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.ui.util.Axis;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nullable;

class DragHelper
extends MouseDragHelper {
    private final JBTabsImpl myTabs;
    private TabInfo myDragSource;
    private Rectangle myDragOriginalRec;
    Rectangle myDragRec;
    private Dimension myHoldDelta;
    private TabInfo myDragOutSource;
    private TabLabel myPressedTabLabel;

    public DragHelper(JBTabsImpl tabs) {
        super(tabs, tabs);
        this.myTabs = tabs;
    }

    @Override
    protected boolean isDragOut(MouseEvent event, Point dragToScreenPoint, Point startScreenPoint) {
        if (this.myDragSource == null || !this.myDragSource.canBeDraggedOut()) {
            return false;
        }
        TabLabel label = this.myTabs.myInfo2Label.get(this.myDragSource);
        if (label == null) {
            return false;
        }
        int dX = dragToScreenPoint.x - startScreenPoint.x;
        int dY = dragToScreenPoint.y - startScreenPoint.y;
        boolean dragOut = this.myTabs.getEffectiveLayout().isDragOut(label, dX, dY);
        return dragOut;
    }

    @Override
    protected void processDragOut(MouseEvent event, Point dragToScreenPoint, Point startScreenPoint, boolean justStarted) {
        TabInfo.DragOutDelegate delegate = this.myDragOutSource.getDragOutDelegate();
        if (justStarted) {
            delegate.dragOutStarted(event, this.myDragOutSource);
        } else {
            delegate.processDragOut(event, this.myDragOutSource);
        }
        event.consume();
    }

    @Override
    protected void processDragOutFinish(MouseEvent event) {
        super.processDragOutFinish(event);
        this.myDragOutSource.getDragOutDelegate().dragOutFinished(event, this.myDragOutSource);
    }

    @Override
    protected void processDragOutCancel() {
        this.myDragOutSource.getDragOutDelegate().dragOutCancelled(this.myDragOutSource);
    }

    @Override
    protected void processMousePressed(MouseEvent event) {
        this.myPressedTabLabel = this.findLabel(new RelativePoint(event).getPoint((Component)this.myTabs));
    }

    @Override
    protected void processDrag(MouseEvent event, Point targetScreenPoint, Point startPointScreen) {
        TabLabel targetLabel;
        if (!(this.myTabs.isTabDraggingEnabled() && this.isDragSource(event) && MouseDragHelper.checkModifiers(event))) {
            return;
        }
        SwingUtilities.convertPointFromScreen(startPointScreen, this.myTabs);
        if (this.isDragJustStarted()) {
            if (this.myPressedTabLabel == null) {
                return;
            }
            Rectangle labelBounds = this.myPressedTabLabel.getBounds();
            this.myHoldDelta = new Dimension(startPointScreen.x - labelBounds.x, startPointScreen.y - labelBounds.y);
            this.myDragSource = this.myPressedTabLabel.getInfo();
            this.myDragRec = new Rectangle(startPointScreen, labelBounds.getSize());
            this.myDragOriginalRec = (Rectangle)this.myDragRec.clone();
            this.myDragOriginalRec.x -= this.myHoldDelta.width;
            this.myDragOriginalRec.y -= this.myHoldDelta.height;
        } else {
            if (this.myDragRec == null) {
                return;
            }
            Point toPoint = SwingUtilities.convertPoint(event.getComponent(), event.getPoint(), this.myTabs);
            this.myDragRec.x = toPoint.x;
            this.myDragRec.y = toPoint.y;
        }
        this.myDragRec.x -= this.myHoldDelta.width;
        this.myDragRec.y -= this.myHoldDelta.height;
        Rectangle headerRec = this.myTabs.getLastLayoutPass().getHeaderRectangle();
        ScreenUtil.moveToFit(this.myDragRec, headerRec, null);
        int deadZoneX = 0;
        int deadZoneY = 0;
        TabLabel top = this.findLabel(new Point(this.myDragRec.x + this.myDragRec.width / 2, this.myDragRec.y + deadZoneY));
        TabLabel bottom = this.findLabel(new Point(this.myDragRec.x + this.myDragRec.width / 2, this.myDragRec.y + this.myDragRec.height - deadZoneY));
        TabLabel left = this.findLabel(new Point(this.myDragRec.x + deadZoneX, this.myDragRec.y + this.myDragRec.height / 2));
        TabLabel right = this.findLabel(new Point(this.myDragRec.x + this.myDragRec.width - deadZoneX, this.myDragRec.y + this.myDragRec.height / 2));
        if (this.myTabs.isHorizontalTabs()) {
            targetLabel = this.findMostOverlapping(Axis.X, left, right);
            if (targetLabel == null) {
                targetLabel = this.findMostOverlapping(Axis.Y, top, bottom);
            }
        } else {
            targetLabel = this.findMostOverlapping(Axis.Y, top, bottom);
            if (targetLabel == null) {
                targetLabel = this.findMostOverlapping(Axis.X, left, right);
            }
        }
        if (targetLabel != null) {
            Rectangle saved = this.myDragRec;
            this.myDragRec = null;
            this.myTabs.reallocate(this.myDragSource, targetLabel.getInfo());
            this.myDragOriginalRec = this.myTabs.myInfo2Label.get(this.myDragSource).getBounds();
            this.myDragRec = saved;
            this.myTabs.moveDraggedTabLabel();
        } else {
            this.myTabs.moveDraggedTabLabel();
            int border = this.myTabs.getTabsBorder().getTabBorderSize();
            headerRec.x -= border;
            headerRec.y -= border;
            headerRec.width += border * 2;
            headerRec.height += border * 2;
            this.myTabs.repaint(headerRec);
        }
        event.consume();
    }

    private boolean isDragSource(MouseEvent event) {
        Object source = event.getSource();
        if (source instanceof Component) {
            return SwingUtilities.windowForComponent(this.myTabs) == SwingUtilities.windowForComponent((Component)source);
        }
        return false;
    }

    private TabLabel findMostOverlapping(Axis measurer, TabLabel ... labels) {
        double freeSpace = measurer.getMinValue(this.myDragRec) < measurer.getMinValue(this.myDragOriginalRec) ? (double)(measurer.getMaxValue(this.myDragOriginalRec) - measurer.getMaxValue(this.myDragRec)) : (double)(measurer.getMinValue(this.myDragRec) - measurer.getMinValue(this.myDragOriginalRec));
        int max = -1;
        TabLabel maxLabel = null;
        for (TabLabel each : labels) {
            Rectangle eachBounds;
            if (each == null || (double)measurer.getSize(eachBounds = each.getBounds()) > freeSpace + freeSpace * 0.3) continue;
            Rectangle intersection = this.myDragRec.intersection(eachBounds);
            int size = intersection.width * intersection.height;
            if (size <= max) continue;
            max = size;
            maxLabel = each;
        }
        return maxLabel;
    }

    @Nullable
    private TabLabel findLabel(Point dragPoint) {
        Component at = this.myTabs.findComponentAt(dragPoint);
        if (at instanceof InplaceButton) {
            return null;
        }
        TabLabel label = this.findLabel(at);
        return label != null && label.getParent() == this.myTabs && label.getInfo() != this.myDragSource ? label : null;
    }

    @Nullable
    private TabLabel findLabel(Component c) {
        for (Component eachParent = c; eachParent != null && eachParent != this.myTabs; eachParent = eachParent.getParent()) {
            if (!(eachParent instanceof TabLabel)) continue;
            return (TabLabel)eachParent;
        }
        return null;
    }

    @Override
    protected boolean canStartDragging(JComponent dragComponent, Point dragComponentPoint) {
        return this.findLabel(dragComponentPoint) != null;
    }

    @Override
    protected void processDragFinish(MouseEvent event, boolean willDragOutStart) {
        super.processDragFinish(event, willDragOutStart);
        this.endDrag(willDragOutStart);
        JBTabsPosition position = this.myTabs.getTabsPosition();
        if (!willDragOutStart && this.myTabs.isAlphabeticalMode() && position != JBTabsPosition.top && position != JBTabsPosition.bottom) {
            Point p = new Point(event.getPoint());
            p = SwingUtilities.convertPoint(event.getComponent(), p, this.myTabs);
            if (this.myTabs.getVisibleRect().contains(p)) {
                int answer;
                RelativePoint relativePoint = new RelativePoint(event);
                if (this.myPressedOnScreenPoint.distance(relativePoint.getScreenPoint()) > 15.0 && (answer = Messages.showOkCancelDialog(this.myTabs, IdeBundle.message("alphabetical.mode.is.on.warning", new Object[0]), IdeBundle.message("title.warning", new Object[0]), Messages.getQuestionIcon())) == 0) {
                    JBEditorTabs.setAlphabeticalMode(false);
                    this.myTabs.relayout(true, false);
                    this.myTabs.revalidate();
                }
            }
        }
    }

    private void endDrag(boolean willDragOutStart) {
        if (willDragOutStart) {
            this.myDragOutSource = this.myDragSource;
        }
        this.myDragSource = null;
        this.myDragRec = null;
        this.myTabs.resetTabsCache();
        if (!willDragOutStart) {
            this.myTabs.fireTabsMoved();
        }
        this.myTabs.relayout(true, false);
        this.myTabs.revalidate();
    }

    @Override
    protected void processDragCancel() {
        this.endDrag(false);
    }

    public TabInfo getDragSource() {
        return this.myDragSource;
    }
}

