/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.breakpoints;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointGroupingRule;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XBreakpointType<B extends XBreakpoint<P>, P extends XBreakpointProperties> {
    public static final ExtensionPointName<XBreakpointType> EXTENSION_POINT_NAME = ExtensionPointName.create((String)"com.intellij.xdebugger.breakpointType");
    @NonNls
    @NotNull
    private final String myId;
    @Nls
    @NotNull
    private final String myTitle;
    private final boolean mySuspendThreadSupported;

    protected XBreakpointType(@NonNls @NotNull String id, @Nls @NotNull String title) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/xdebugger/breakpoints/XBreakpointType", "<init>"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/xdebugger/breakpoints/XBreakpointType", "<init>"));
        }
        this(id, title, false);
    }

    protected XBreakpointType(@NonNls @NotNull String id, @Nls @NotNull String title, boolean suspendThreadSupported) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/xdebugger/breakpoints/XBreakpointType", "<init>"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/xdebugger/breakpoints/XBreakpointType", "<init>"));
        }
        this.myId = id;
        this.myTitle = title;
        this.mySuspendThreadSupported = suspendThreadSupported;
    }

    @Nullable
    public P createProperties() {
        return null;
    }

    public boolean isSuspendThreadSupported() {
        return this.mySuspendThreadSupported;
    }

    public EnumSet<StandardPanels> getVisibleStandardPanels() {
        return EnumSet.allOf(StandardPanels.class);
    }

    @NotNull
    public final String getId() {
        String string = this.myId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/breakpoints/XBreakpointType", "getId"));
        }
        return string;
    }

    @NotNull
    public String getTitle() {
        String string = this.myTitle;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/breakpoints/XBreakpointType", "getTitle"));
        }
        return string;
    }

    @NotNull
    public Icon getEnabledIcon() {
        Icon icon = AllIcons.Debugger.Db_set_breakpoint;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/breakpoints/XBreakpointType", "getEnabledIcon"));
        }
        return icon;
    }

    @NotNull
    public Icon getDisabledIcon() {
        Icon icon = AllIcons.Debugger.Db_disabled_breakpoint;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/breakpoints/XBreakpointType", "getDisabledIcon"));
        }
        return icon;
    }

    @NotNull
    public Icon getMutedEnabledIcon() {
        Icon icon = AllIcons.Debugger.Db_muted_breakpoint;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/breakpoints/XBreakpointType", "getMutedEnabledIcon"));
        }
        return icon;
    }

    @NotNull
    public Icon getMutedDisabledIcon() {
        Icon icon = AllIcons.Debugger.Db_muted_disabled_breakpoint;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/breakpoints/XBreakpointType", "getMutedDisabledIcon"));
        }
        return icon;
    }

    @NotNull
    public Icon getInactiveDependentIcon() {
        Icon icon = this.getDisabledDependentIcon();
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/breakpoints/XBreakpointType", "getInactiveDependentIcon"));
        }
        return icon;
    }

    @NotNull
    public Icon getDisabledDependentIcon() {
        Icon icon = AllIcons.Debugger.Db_dep_line_breakpoint;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/breakpoints/XBreakpointType", "getDisabledDependentIcon"));
        }
        return icon;
    }

    public abstract String getDisplayText(B var1);

    @Nullable
    public XBreakpointCustomPropertiesPanel<B> createCustomConditionsPanel() {
        return null;
    }

    @Nullable
    public XBreakpointCustomPropertiesPanel<B> createCustomPropertiesPanel(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/breakpoints/XBreakpointType", "createCustomPropertiesPanel"));
        }
        return this.createCustomPropertiesPanel();
    }

    @Nullable
    public XBreakpointCustomPropertiesPanel<B> createCustomPropertiesPanel() {
        return null;
    }

    @Nullable
    public XBreakpointCustomPropertiesPanel<B> createCustomRightPropertiesPanel(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/breakpoints/XBreakpointType", "createCustomRightPropertiesPanel"));
        }
        return null;
    }

    @Nullable
    public XBreakpointCustomPropertiesPanel<B> createCustomTopPropertiesPanel(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/breakpoints/XBreakpointType", "createCustomTopPropertiesPanel"));
        }
        return null;
    }

    @Nullable
    public XDebuggerEditorsProvider getEditorsProvider() {
        return null;
    }

    @Nullable
    public XDebuggerEditorsProvider getEditorsProvider(@NotNull B breakpoint, @NotNull Project project) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/intellij/xdebugger/breakpoints/XBreakpointType", "getEditorsProvider"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/breakpoints/XBreakpointType", "getEditorsProvider"));
        }
        return this.getEditorsProvider();
    }

    public List<XBreakpointGroupingRule<B, ?>> getGroupingRules() {
        return Collections.emptyList();
    }

    @NotNull
    public Comparator<B> getBreakpointComparator() {
        Comparator comparator = new Comparator<B>(){

            @Override
            public int compare(B b, B b1) {
                return (int)(b1.getTimeStamp() - b.getTimeStamp());
            }
        };
        if (comparator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/breakpoints/XBreakpointType", "getBreakpointComparator"));
        }
        return comparator;
    }

    public boolean isAddBreakpointButtonVisible() {
        return false;
    }

    @Nullable
    public B addBreakpoint(Project project, JComponent parentComponent) {
        return null;
    }

    @Nullable
    public XBreakpoint<P> createDefaultBreakpoint(@NotNull XBreakpointCreator<P> creator) {
        if (creator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "creator", "com/intellij/xdebugger/breakpoints/XBreakpointType", "createDefaultBreakpoint"));
        }
        return null;
    }

    public boolean shouldShowInBreakpointsDialog(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/breakpoints/XBreakpointType", "shouldShowInBreakpointsDialog"));
        }
        return true;
    }

    @Nullable
    @NonNls
    public String getBreakpointsDialogHelpTopic() {
        return null;
    }

    @Nullable
    public XSourcePosition getSourcePosition(@NotNull XBreakpoint<P> breakpoint) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/intellij/xdebugger/breakpoints/XBreakpointType", "getSourcePosition"));
        }
        return null;
    }

    public String getShortText(B breakpoint) {
        return this.getDisplayText(breakpoint);
    }

    public static interface XBreakpointCreator<P extends XBreakpointProperties> {
        @NotNull
        public XBreakpoint<P> createBreakpoint(@Nullable P var1);
    }

    public static enum StandardPanels {
        SUSPEND_POLICY,
        ACTIONS,
        DEPENDENCY;

    }
}

