/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.surroundWith;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.codeInsight.CodeInsightUtils;
import org.jetbrains.kotlin.psi.KtBlockExpression;

public class KotlinSurrounderUtils {
    public static String SURROUND_WITH = KotlinBundle.message("surround.with", new Object[0]);
    public static String SURROUND_WITH_ERROR = KotlinBundle.message("surround.with.cannot.perform.action", new Object[0]);

    private KotlinSurrounderUtils() {
    }

    public static void addStatementsInBlock(@NotNull KtBlockExpression block, @NotNull PsiElement[] statements) {
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/KotlinSurrounderUtils", "addStatementsInBlock"));
        }
        if (statements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statements", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/KotlinSurrounderUtils", "addStatementsInBlock"));
        }
        PsiElement lBrace = block.getFirstChild();
        block.addRangeAfter(statements[0], statements[statements.length - 1], lBrace);
    }

    public static void showErrorHint(@NotNull Project project, @NotNull Editor editor, @NotNull String message2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/KotlinSurrounderUtils", "showErrorHint"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/KotlinSurrounderUtils", "showErrorHint"));
        }
        if (message2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/KotlinSurrounderUtils", "showErrorHint"));
        }
        CodeInsightUtils.showErrorHint(project, editor, message2, SURROUND_WITH, null);
    }
}

