/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.codeInsight.CodeInsightUtils;
import org.jetbrains.kotlin.idea.debugger.KotlinFrameExtraVariablesProviderKt;
import org.jetbrains.kotlin.idea.debugger.VariablesCollector;
import org.jetbrains.kotlin.idea.refactoring.JetRefactoringUtilKt;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0014"}, d2={"findAdditionalExpressions", "", "Lcom/intellij/debugger/engine/evaluation/TextWithImports;", "position", "Lcom/intellij/debugger/SourcePosition;", "getContainingElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "element", "Lcom/intellij/psi/PsiElement;", "getLineRangeForElement", "Lcom/intellij/openapi/util/TextRange;", "containingElement", "doc", "Lcom/intellij/openapi/editor/Document;", "shouldSkipLine", "", "file", "Lcom/intellij/psi/PsiFile;", "line", "", "idea"})
public final class KotlinFrameExtraVariablesProviderKt {
    private static final Set<TextWithImports> findAdditionalExpressions(SourcePosition position) {
        PsiElement elem;
        Document doc;
        int line = position.getLine();
        PsiFile file = position.getFile();
        VirtualFile vFile = file.getVirtualFile();
        Document document = doc = vFile != null ? FileDocumentManager.getInstance().getDocument(vFile) : (Document)null;
        if (doc == null || doc.getLineCount() == 0 || line > doc.getLineCount() - 1) {
            return SetsKt.emptySet();
        }
        Integer n = JetRefactoringUtilKt.getLineStartOffset(file, line);
        if (n == null || (n = AddToStdlibKt.check(n, findAdditionalExpressions.offset.1.INSTANCE)) == null) {
            return SetsKt.emptySet();
        }
        int offset2 = ((Number)n).intValue();
        PsiElement psiElement = elem = file.findElementAt(offset2);
        if (psiElement == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"elem!!");
        KtElement ktElement = KotlinFrameExtraVariablesProviderKt.getContainingElement(psiElement);
        PsiElement psiElement2 = ktElement != null ? (PsiElement)ktElement : elem;
        if (psiElement2 == null) {
            return SetsKt.emptySet();
        }
        PsiElement containingElement = psiElement2;
        TextRange limit = KotlinFrameExtraVariablesProviderKt.getLineRangeForElement(containingElement, doc);
        int startLine = Math.max(limit.getStartOffset(), line);
        while (startLine - 1 > limit.getStartOffset()) {
            PsiFile psiFile = file;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"file");
            if (!KotlinFrameExtraVariablesProviderKt.shouldSkipLine(psiFile, doc, startLine - 1)) break;
            --startLine;
        }
        int endLine = Math.min(limit.getEndOffset(), line);
        while (endLine + 1 < limit.getEndOffset()) {
            PsiFile psiFile = file;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"file");
            if (!KotlinFrameExtraVariablesProviderKt.shouldSkipLine(psiFile, doc, endLine + 1)) break;
            ++endLine;
        }
        Integer n2 = JetRefactoringUtilKt.getLineStartOffset(file, startLine);
        if (n2 == null) {
            return SetsKt.emptySet();
        }
        int startOffset = ((Number)n2).intValue();
        Integer n3 = JetRefactoringUtilKt.getLineEndOffset(file, endLine);
        if (n3 == null) {
            return SetsKt.emptySet();
        }
        int endOffset = ((Number)n3).intValue();
        if (startOffset >= endOffset) {
            return SetsKt.emptySet();
        }
        TextRange lineRange = new TextRange(startOffset, endOffset);
        if (lineRange.isEmpty()) {
            return SetsKt.emptySet();
        }
        LinkedHashSet expressions = new LinkedHashSet();
        VariablesCollector variablesCollector = new VariablesCollector(lineRange, expressions);
        containingElement.accept((PsiElementVisitor)variablesCollector);
        return expressions;
    }

    private static final KtElement getContainingElement(PsiElement element2) {
        PsiElement parent2;
        KtElement contElement;
        KtDeclaration ktDeclaration = (KtDeclaration)PsiTreeUtil.getParentOfType((PsiElement)element2, KtDeclaration.class);
        KtElement ktElement = contElement = ktDeclaration != null ? (KtElement)ktDeclaration : (KtElement)PsiTreeUtil.getParentOfType((PsiElement)element2, KtElement.class);
        if (contElement instanceof KtProperty && ((KtProperty)contElement).isLocal() && (parent2 = ((KtProperty)contElement).getParent()) != null) {
            return KotlinFrameExtraVariablesProviderKt.getContainingElement(parent2);
        }
        if (contElement instanceof KtDeclarationWithBody) {
            return ((KtDeclarationWithBody)contElement).getBodyExpression();
        }
        return contElement;
    }

    private static final TextRange getLineRangeForElement(PsiElement containingElement, Document doc) {
        TextRange elemRange = containingElement.getTextRange();
        return new TextRange(doc.getLineNumber(elemRange.getStartOffset()), doc.getLineNumber(elemRange.getEndOffset()));
    }

    private static final boolean shouldSkipLine(PsiFile file, Document doc, int line) {
        PsiElement topmostElementAtOffset;
        PsiElement elemAtOffset;
        int end;
        int start = CharArrayUtil.shiftForward((CharSequence)doc.getCharsSequence(), (int)doc.getLineStartOffset(line), (String)" \n\t");
        if (start >= (end = doc.getLineEndOffset(line))) {
            return true;
        }
        PsiElement psiElement = elemAtOffset = file.findElementAt(start);
        if (psiElement == null) {
            Intrinsics.throwNpe();
        }
        return !((topmostElementAtOffset = CodeInsightUtils.getTopmostElementAtOffset(psiElement, start)) instanceof KtDeclaration);
    }

    @NotNull
    public static final /* synthetic */ Set access$findAdditionalExpressions(@NotNull SourcePosition position) {
        return KotlinFrameExtraVariablesProviderKt.findAdditionalExpressions(position);
    }
}

